package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 项目安全环保信息表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-18
 */
@ApiModel(value="BizProjectSecurityProtection对象", description="项目安全环保信息表")
@TableName("biz_project_security_protection")
public class BizProjectSecurityProtection extends BizModel<BizProjectSecurityProtection> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "项目id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "项目name")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "子项目id")
    @TableField("SUBPROJECT_ID_")
    private String subprojectId;

    @ApiModelProperty(value = "子项目name")
    @TableField("SUBPROJECT_NAME_")
    private String subprojectName;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getSubprojectId() {
        return subprojectId;
    }

    public void setSubprojectId(String subprojectId) {
        this.subprojectId = subprojectId;
    }
    public String getSubprojectName() {
        return subprojectName;
    }

    public void setSubprojectName(String subprojectName) {
        this.subprojectName = subprojectName;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizProjectSecurityProtection{" +
            "id=" + id +
            ", projectId=" + projectId +
            ", projectName=" + projectName +
            ", subprojectId=" + subprojectId +
            ", subprojectName=" + subprojectName +
            ", remarks=" + remarks +
        "}";
    }
}
