package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 监理巡查记录表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-16
 */
@ApiModel(value="BizInspectionRecordsOfSupervision对象", description="监理巡查记录表")
@TableName("biz_inspection_records_of_supervision")
@Data
public class BizInspectionRecordsOfSupervision extends BizModel<BizInspectionRecordsOfSupervision> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "路段id")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "巡查记录表id")
    @TableField("POLICE_ID_")
    private String policeId;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "巡查时间")
    @TableField("POLICE_TIME_")
    private LocalDate policeTime;

    @ApiModelProperty(value = "巡查地点")
    @TableField("POLICE_LOCATION_")
    private String policeLocation;

    @ApiModelProperty(value = "监理巡查员")
    @TableField("POLICE_USER_")
    private String policeUser;

    @ApiModelProperty(value = "巡查记录")
    @TableField("POLICE_DESCRIPTION_")
    private String policeDescription;

    @ApiModelProperty(value = "填报方")
    @TableField("REPORT_UNIT_")
    private String reportUnit;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;
    @ApiModelProperty(value = "工程表id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "工程表name")
    @TableField("PROJECT_NAME_")
    private String projectName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getPoliceId() {
        return policeId;
    }

    public void setPoliceId(String policeId) {
        this.policeId = policeId;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public LocalDate getPoliceTime() {
        return policeTime;
    }

    public void setPoliceTime(LocalDate policeTime) {
        this.policeTime = policeTime;
    }
    public String getPoliceLocation() {
        return policeLocation;
    }

    public void setPoliceLocation(String policeLocation) {
        this.policeLocation = policeLocation;
    }
    public String getPoliceUser() {
        return policeUser;
    }

    public void setPoliceUser(String policeUser) {
        this.policeUser = policeUser;
    }
    public String getPoliceDescription() {
        return policeDescription;
    }

    public void setPoliceDescription(String policeDescription) {
        this.policeDescription = policeDescription;
    }
    public String getReportUnit() {
        return reportUnit;
    }

    public void setReportUnit(String reportUnit) {
        this.reportUnit = reportUnit;
    }
    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizInspectionRecordsOfSupervision{" +
                "id='" + id + '\'' +
                ", policeId='" + policeId + '\'' +
                ", remarks='" + remarks + '\'' +
                ", policeTime=" + policeTime +
                ", policeLocation='" + policeLocation + '\'' +
                ", policeUser='" + policeUser + '\'' +
                ", policeDescription='" + policeDescription + '\'' +
                ", reportUnit='" + reportUnit + '\'' +
                ", validFlag=" + validFlag +
                ", companyId='" + companyId + '\'' +
                ", companyName='" + companyName + '\'' +
                ", projectId='" + projectId + '\'' +
                ", projectName='" + projectName + '\'' +
                '}';
    }
}
