package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 合同变更申请表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-12
 */
@ApiModel(value="BizApplicationForChangeOfContract对象", description="合同变更申请表")
@TableName("biz_application_for_change_of_contract")
public class BizApplicationForChangeOfContract extends BizModel<BizApplicationForChangeOfContract> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;
    @ApiModelProperty(value = "合同ID")
    @TableField("CONTRACT_ID_")
    private String contractId;

    @ApiModelProperty(value = "合同名称")
    @TableField("CONTRACT_NAME_")
    private String contractName;

    @ApiModelProperty(value = "合同变更业务主键")
    @TableField("CHANGE_ID_")
    private String changeId;

    @ApiModelProperty(value = "变更理由")
    @TableField("CHANGE_REASON_")
    private String changeReason;

    @ApiModelProperty(value = "变更申请人")
    @TableField("CHANGE_APPLY_USER_")
    private String changeApplyUser;

    @ApiModelProperty(value = "变更申请人单位")
    @TableField("CHANGE_APPLY_UNIT_")
    private String changeApplyUnit;

    @ApiModelProperty(value = "变更申请时间")
    @TableField("CHANGE_APPLY_DATE_")
    private LocalDate changeApplyDate;

    @ApiModelProperty(value = "变更申请内容")
    @TableField("CHANGE_APPLY_CONTENTS_")
    private String changeApplyContents;

    @ApiModelProperty(value = "变更申请备注说明")
    @TableField("CHANGE_APPLY_REMARKS_")
    private String changeApplyRemarks;

    @ApiModelProperty(value = "变更申请是否导出（1-已导出、0-未导出）")
    @TableField("CHANGE_APPLY_EXPORT_FLAG_")
    private Integer changeApplyExportFlag;

    @ApiModelProperty(value = "线下审核附件是否导入（1-已导入、0-未导入）")
    @TableField("CHANGE_APPLY_IMPORT_FLAG_")
    private Integer changeApplyImportFlag;

    @ApiModelProperty(value = "正式变更填写人")
    @TableField("CHANGE_EXECUTE_USER_")
    private String changeExecuteUser;

    @ApiModelProperty(value = "正式变更填写人单位")
    @TableField("CHANGE_EXECUTE_UNIT_")
    private String changeExecuteUnit;

    @ApiModelProperty(value = "正式变更填报时间")
    @TableField("CHANGE_EXECUTE_DATE_")
    private LocalDate changeExecuteDate;

    @ApiModelProperty(value = "正式变更待生效表业务主键")
    @TableField("CHANGE_EXECUTE_ID_")
    private String changeExecuteId;

    @ApiModelProperty(value = "是否已填写正式变更内容（1-是、0-否）")
    @TableField("CHANGE_EXECUTE_FLAG_")
    private Integer changeExecuteFlag;

    @ApiModelProperty(value = "正式变更确认人")
    @TableField("CHANGE_CONFIRM_USER_")
    private String changeConfirmUser;

    @ApiModelProperty(value = "正式变更确认人单位")
    @TableField("CHANGE_CONFIRM_UNIT_")
    private String changeConfirmUnit;

    @ApiModelProperty(value = "正式变更审核状态（0-待审核、1-通过、2-不通过）")
    @TableField("CHANGE_CONFIRM_STATUS_")
    private Integer changeConfirmStatus;

    @ApiModelProperty(value = "变更生效时间（审核通过时间）")
    @TableField("CHANGE_CONFIRM_DATE_")
    private LocalDate changeConfirmDate;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getChangeId() {
        return changeId;
    }

    public void setChangeId(String changeId) {
        this.changeId = changeId;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public String getChangeApplyUser() {
        return changeApplyUser;
    }

    public void setChangeApplyUser(String changeApplyUser) {
        this.changeApplyUser = changeApplyUser;
    }
    public String getChangeApplyUnit() {
        return changeApplyUnit;
    }

    public void setChangeApplyUnit(String changeApplyUnit) {
        this.changeApplyUnit = changeApplyUnit;
    }
    public LocalDate getChangeApplyDate() {
        return changeApplyDate;
    }

    public void setChangeApplyDate(LocalDate changeApplyDate) {
        this.changeApplyDate = changeApplyDate;
    }
    public String getChangeApplyContents() {
        return changeApplyContents;
    }

    public void setChangeApplyContents(String changeApplyContents) {
        this.changeApplyContents = changeApplyContents;
    }
    public String getChangeApplyRemarks() {
        return changeApplyRemarks;
    }

    public void setChangeApplyRemarks(String changeApplyRemarks) {
        this.changeApplyRemarks = changeApplyRemarks;
    }
    public Integer getChangeApplyExportFlag() {
        return changeApplyExportFlag;
    }

    public void setChangeApplyExportFlag(Integer changeApplyExportFlag) {
        this.changeApplyExportFlag = changeApplyExportFlag;
    }
    public Integer getChangeApplyImportFlag() {
        return changeApplyImportFlag;
    }

    public void setChangeApplyImportFlag(Integer changeApplyImportFlag) {
        this.changeApplyImportFlag = changeApplyImportFlag;
    }
    public String getChangeExecuteUser() {
        return changeExecuteUser;
    }

    public void setChangeExecuteUser(String changeExecuteUser) {
        this.changeExecuteUser = changeExecuteUser;
    }
    public String getChangeExecuteUnit() {
        return changeExecuteUnit;
    }

    public void setChangeExecuteUnit(String changeExecuteUnit) {
        this.changeExecuteUnit = changeExecuteUnit;
    }
    public LocalDate getChangeExecuteDate() {
        return changeExecuteDate;
    }

    public void setChangeExecuteDate(LocalDate changeExecuteDate) {
        this.changeExecuteDate = changeExecuteDate;
    }
    public String getChangeExecuteId() {
        return changeExecuteId;
    }

    public void setChangeExecuteId(String changeExecuteId) {
        this.changeExecuteId = changeExecuteId;
    }
    public Integer getChangeExecuteFlag() {
        return changeExecuteFlag;
    }

    public void setChangeExecuteFlag(Integer changeExecuteFlag) {
        this.changeExecuteFlag = changeExecuteFlag;
    }
    public String getChangeConfirmUser() {
        return changeConfirmUser;
    }

    public void setChangeConfirmUser(String changeConfirmUser) {
        this.changeConfirmUser = changeConfirmUser;
    }
    public String getChangeConfirmUnit() {
        return changeConfirmUnit;
    }

    public void setChangeConfirmUnit(String changeConfirmUnit) {
        this.changeConfirmUnit = changeConfirmUnit;
    }
    public Integer getChangeConfirmStatus() {
        return changeConfirmStatus;
    }

    public void setChangeConfirmStatus(Integer changeConfirmStatus) {
        this.changeConfirmStatus = changeConfirmStatus;
    }
    public LocalDate getChangeConfirmDate() {
        return changeConfirmDate;
    }

    public void setChangeConfirmDate(LocalDate changeConfirmDate) {
        this.changeConfirmDate = changeConfirmDate;
    }
    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizApplicationForChangeOfContract{" +
            "id=" + id +
            ", changeId=" + changeId +
            ", changeReason=" + changeReason +
            ", changeApplyUser=" + changeApplyUser +
            ", changeApplyUnit=" + changeApplyUnit +
            ", changeApplyDate=" + changeApplyDate +
            ", changeApplyContents=" + changeApplyContents +
            ", changeApplyRemarks=" + changeApplyRemarks +
            ", changeApplyExportFlag=" + changeApplyExportFlag +
            ", changeApplyImportFlag=" + changeApplyImportFlag +
            ", changeExecuteUser=" + changeExecuteUser +
            ", changeExecuteUnit=" + changeExecuteUnit +
            ", changeExecuteDate=" + changeExecuteDate +
            ", changeExecuteId=" + changeExecuteId +
            ", changeExecuteFlag=" + changeExecuteFlag +
            ", changeConfirmUser=" + changeConfirmUser +
            ", changeConfirmUnit=" + changeConfirmUnit +
            ", changeConfirmStatus=" + changeConfirmStatus +
            ", changeConfirmDate=" + changeConfirmDate +
            ", validFlag=" + validFlag +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
        "}";
    }
}
