package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.manager.BizProjectManageQualityChangeManager;
import com.artfess.yhxt.specialproject.model.*;
import com.artfess.yhxt.specialproject.model.BizProjectManageQuality;
import com.artfess.yhxt.specialproject.model.BizProjectManageQuality;
import com.artfess.yhxt.specialproject.dao.BizProjectManageQualityDao;
import com.artfess.yhxt.specialproject.manager.BizProjectManageQualityManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.vo.BizProjectManageQualityVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 工程质量管理质检单表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-12
 */
@Service
public class BizProjectManageQualityManagerImpl extends BaseManagerImpl<BizProjectManageQualityDao, BizProjectManageQuality> implements BizProjectManageQualityManager {
    @Resource
    BizProjectManageQualityChangeManager bizProjectManageQualityChangeManager;

    @Resource
    private BizEngineeringAccessoriesManager bizEngineeringAccessoriesManager;
    @Override
    public PageList<BizProjectManageQuality> queryBizProjectManageQuality(QueryFilter<BizProjectManageQuality> queryFilter) {
        IPage<BizProjectManageQuality> result =  baseMapper.queryBizProjectManageQuality(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizProjectManageQuality getBizProjectManageQualityById(String id) {
        BizProjectManageQuality bizProjectContract = baseMapper.selectById(id);
        return bizProjectContract;
    }

    @Override
    public List<BizProjectManageQuality> selectListById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("ID_",id);
        return this.baseMapper.selectList(queryWrapper);
    }

    @Override
    public void updateReformFlag(String testId) {
        UpdateWrapper<BizProjectManageQuality> updateWrapper = new UpdateWrapper<>();
        updateWrapper.in("TEST_ID_",testId);
        updateWrapper.set("REFORM_FLAG_","1");
        this.baseMapper.update(null, updateWrapper);
    }

    @Override
    public void updateConfirmResult(String testId) {
        // bizProjectManageQualityChange = bizProjectManageQualityChangeManager.getBizProjectManageQualityChangeById(id);
        UpdateWrapper<BizProjectManageQuality> updateWrapper = new UpdateWrapper<>();
        updateWrapper.in("TEST_ID_",testId);
        updateWrapper.set("CONFIRM_RESULT_","1");
        this.baseMapper.update(null, updateWrapper);
    }

    @Override
    public void updateConfirmResults(String testId) {
        UpdateWrapper<BizProjectManageQuality> updateWrapper = new UpdateWrapper<>();
        updateWrapper.in("TEST_ID_",testId);
        updateWrapper.set("CONFIRM_RESULT_","2");
        this.baseMapper.update(null, updateWrapper);
    }

    @Override
    public void saveVo(BizProjectManageQualityVo bizProjectManageQualityVo) {
        //保存项目周报月报
        BizProjectManageQuality bizProjectManageQuality = bizProjectManageQualityVo.getBizProjectManageQuality();
        this.create(bizProjectManageQuality);
        //附件
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizProjectManageQualityVo.getBizEngineeringAccessoriesList();
        String sourceId = bizProjectManageQuality.getId();
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public void updateVo(BizProjectManageQualityVo bizProjectManageQualityVo) {
        //修改项目周报月报
        BizProjectManageQuality bizProjectManageQuality = bizProjectManageQualityVo.getBizProjectManageQuality();

        this.update(bizProjectManageQuality);
        String sourceId = bizProjectManageQuality.getId();
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizProjectManageQualityVo.getBizEngineeringAccessoriesList();
        bizEngineeringAccessoriesManager.removeEngineeringAccessories(sourceId);
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public BizProjectManageQualityVo getVo(String id) {
        BizProjectManageQualityVo bizProjectManageQualityVo= new BizProjectManageQualityVo();
        BizProjectManageQuality bizProjectManageQuality = this.getById(id);
        List<BizEngineeringAccessories> engineeringAccessories = this.bizEngineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        bizProjectManageQualityVo.setBizProjectManageQuality(bizProjectManageQuality);
        bizProjectManageQualityVo.setBizEngineeringAccessoriesList(engineeringAccessories);
        return bizProjectManageQualityVo;
    }
}
