package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.manager.BizProjectContractDetailsManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.model.BizProjectContract;
import com.artfess.yhxt.specialproject.dao.BizProjectContractDao;
import com.artfess.yhxt.specialproject.manager.BizProjectContractManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.model.BizProjectContractDetails;
import com.artfess.yhxt.specialproject.vo.BizProjectContractVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 项目合同表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
@Service
public class BizProjectContractManagerImpl extends BaseManagerImpl<BizProjectContractDao, BizProjectContract> implements BizProjectContractManager {
    @Autowired
    private BizProjectContractDetailsManager bizProjectContractDetailsManager;
    @Autowired
    private BizProjectContractManager bizProjectContractManager;
    @Resource
    private BizEngineeringAccessoriesManager bizEngineeringAccessoriesManager;
    @Override
    public PageList<BizProjectContract> queryBizProjectContract(QueryFilter<BizProjectContract> queryFilter) {
        IPage<BizProjectContract> result =  baseMapper.queryBizProjectContract(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizProjectContractVo getBizProjectContractById(String id) {
        BizProjectContract bizProjectContract = baseMapper.selectById(id);
        BizProjectContractVo bizProjectContractVo = new BizProjectContractVo();
        bizProjectContractVo.setBizProjectContract(bizProjectContract);
        if(null != bizProjectContract && StringUtils.isNotBlank( bizProjectContract.getId())){
            bizProjectContractVo.setDetailList(bizProjectContractDetailsManager.selectListById(id));
        }
        List<BizEngineeringAccessories> engineeringAccessories = bizEngineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        if (engineeringAccessories.size()>0){
            bizProjectContractVo.setBizEngineeringAccessoriesList(engineeringAccessories);}

        return bizProjectContractVo;
    }

    @Override
    public void saveBizProjectContractVo(BizProjectContractVo vo) {
        BizProjectContract bizProjectContract = vo.getBizProjectContract();
        if(BeanUtils.isNotEmpty(bizProjectContract)){
            if (StringUtils.isEmpty(bizProjectContract.getId())) {
                bizProjectContract.setIsDele("0");
                this.save(bizProjectContract);
            } else {
                this.update(bizProjectContract);
            }
            String id = bizProjectContract.getId();
            if (vo.getDetailList() != null && vo.getDetailList().size() > 0) {
                vo.getDetailList().forEach(s -> {
                    s.setContractId(id);
                    if (StringUtils.isEmpty(s.getId())) {
                        s.setIsDele("0");
                        this.bizProjectContractDetailsManager.save(s);
                    }else {
                        bizProjectContractDetailsManager.update(s);
                    }
                });
            }
            bizEngineeringAccessoriesManager.removeEngineeringAccessories(id);

            //工程附件
            List<BizEngineeringAccessories> bizEngineeringAccessoriesList = vo.getBizEngineeringAccessoriesList();
            if (bizEngineeringAccessoriesList !=null&& bizEngineeringAccessoriesList.size()>0 ){
                bizEngineeringAccessoriesList.forEach(s->{
                    s.setSourceId(id);
                    s.setValidFlag(1);
                });
            }
            this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);

        }
    }

    @Override
    public void updateFlag(String ids, Integer flag) {
        List<String> idsList = Arrays.asList(ids.split(","));
        UpdateWrapper<BizProjectContract> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("VALID_FLAG_", flag).in("ID_", idsList);
        this.bizProjectContractManager.update(null, updateWrapper);
    }


}
