package com.artfess.yhxt.specialproject.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.model.BizProjectManageQuality;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.specialproject.vo.BizProjectManageQualityVo;

import java.util.List;

/**
 * 工程质量管理质检单表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-12
 */
public interface BizProjectManageQualityManager extends BaseManager<BizProjectManageQuality> {

    PageList<BizProjectManageQuality> queryBizProjectManageQuality(QueryFilter<BizProjectManageQuality> queryFilter);

    BizProjectManageQuality getBizProjectManageQualityById(String id);

    List<BizProjectManageQuality> selectListById(String id);

    void updateReformFlag(String testId);

    void updateConfirmResult(String testId);

    void updateConfirmResults(String testId);

    //保存工程质量、附件
    void saveVo(BizProjectManageQualityVo bizProjectManageQualityVo);

    //修改工程质量、附件
    void updateVo(BizProjectManageQualityVo bizProjectManageQualityVo);
    //根据ID查询工程质量、附件
    BizProjectManageQualityVo getVo(String id);
}
