package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialproject.model.BizProjectCompletionApplicationForm;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.model.BizProjectCompletionApplicationForm;
import com.artfess.yhxt.specialproject.manager.BizProjectCompletionApplicationFormManager;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 工程竣工申请表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-11
 */
@RestController
@RequestMapping("/bizProjectCompletionApplicationForm/v1/")
@Api(tags = "工程竣工申请")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizProjectCompletionApplicationFormController extends BaseController<BizProjectCompletionApplicationFormManager, BizProjectCompletionApplicationForm> {

    @Resource
    private BaseContext baseContext;

    @RequestMapping(value = "/saveProjectCompletionApplicationForm",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改工程竣工申请信息",httpMethod = "POST")
    public CommonResult<String> saveEngineeringProject(@ApiParam(name = "bizProjectCompletionApplicationForm",value = "工程竣工申请专项检查对象") @RequestBody BizProjectCompletionApplicationForm bizProjectCompletionApplicationForm) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(bizProjectCompletionApplicationForm.getId())){
            bizProjectCompletionApplicationForm.setIsDele("0");
            baseService.create(bizProjectCompletionApplicationForm);
        }else {
            baseService.update(bizProjectCompletionApplicationForm);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "/getJson",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询工程竣工申请信息",httpMethod ="POST")
    public PageList<BizProjectCompletionApplicationForm> getJson(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizProjectCompletionApplicationForm> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){

        }
        PageList<BizProjectCompletionApplicationForm> pageList = baseService.queryBizProjectCompletionApplicationForm(queryFilter);
        return pageList;
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询工程竣工申请信息",httpMethod = "GET",notes = "根据ID查询工程竣工申请信息")
    public BizProjectCompletionApplicationForm get(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getBizProjectCompletionApplicationFormById(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除工程竣工申请信息",httpMethod = "DELETE",notes = "批量删除工程竣工申请信息")
    public CommonResult<String> removes(@ApiParam(name = "ids",value = "对各主键用逗号分隔",required = true) @RequestParam String... ids) throws Exception{
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true,"删除成功");
    }

    @RequestMapping(value = "/updateCompletionApplicationForm",method = RequestMethod.DELETE,produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除工程竣工申请信息",httpMethod = "DELETE",notes = "逻辑删除工程竣工申请信息")
    public CommonResult<String> updateProject(@ApiParam(name = "ids",value = "ID集合以，隔开",required = true)
                                              @RequestParam(value = "ids",required = true)String ids)throws Exception{
        if (StringUtils.isNotBlank(ids)){
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizProjectCompletionApplicationForm> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_",idsList);
            updateWrapper.set("is_dele_","1");
            baseService.update(null,updateWrapper);
        }
        return new CommonResult<>(true,"删除成功");
    }

}
