package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.*;
import com.artfess.base.util.StringUtil;
import com.artfess.yhxt.disease.vo.DiseaseReportVO;
import com.artfess.yhxt.specialproject.vo.BizEngineeringProjectVo;
import com.artfess.yhxt.specialproject.vo.ProjectMoneyListVO;
import com.artfess.yhxt.specialproject.vo.ProjectMoneyVO;
import com.artfess.yhxt.specialproject.vo.ProjectReportVO;
import com.artfess.yhxt.statistics.vo.Org4BudgetVO;
import com.artfess.yhxt.statistics.vo.Org4ProjectMoneyVO;
import com.artfess.yhxt.statistics.vo.Org4ProjectVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.model.BizEngineeringProject;
import com.artfess.yhxt.specialproject.manager.BizEngineeringProjectManager;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 工程项目表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
@RestController
@RequestMapping("/bizEngineeringProject/v1/")
@Api(tags = "工程项目管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizEngineeringProjectController extends BaseController<BizEngineeringProjectManager, BizEngineeringProject> {

    @Resource
    BizEngineeringProjectManager bizEngineeringProjectManager;

    @Resource
    private BaseContext baseContext;
    @Resource
    private PermissionUtils permissionUtils;

    @RequestMapping(value = "projectMoneyReport", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取专项计量统计报表", httpMethod = "GET", notes = "获取专项计量统计报表")
    public List<ProjectMoneyVO> projectMoneyReport(String year, String orgId) throws Exception {
        return baseService.getMoneyReport(year, orgId);
    }

    @RequestMapping(value = "moneyListReport", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取专项计量列表报表", httpMethod = "GET", notes = "获取专项计量列表报表")
    public List<ProjectMoneyListVO> moneyListReport(String year, String orgId) throws Exception {
        return baseService.getMoneyListReport(year, orgId);
    }

    @RequestMapping(value = "projectReport", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取专项报表", httpMethod = "GET", notes = "获取专项报表")
    public List<ProjectReportVO> projectReport(String year,String orgId) throws Exception {
        return baseService.getReport(year,orgId);
    }

    @RequestMapping(value = "getProjectMoneyVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取项目金额统计", httpMethod = "POST", notes = "获取项目金额统计")
    public List<Org4ProjectMoneyVO> getProjectMoneyVo(String year) throws Exception {
        return baseService.getProjectMoneyCount(year);
    }

    @RequestMapping(value = "getProjectCountVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取工程数量", httpMethod = "POST", notes = "获取工程数量")
    public List<Org4ProjectVO> getProjectCountVo(String year) throws Exception {
        return baseService.getProjectCount(year);
    }

    @RequestMapping(value = "/saveEngineeringProject",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改工程项目信息",httpMethod = "POST")
    public CommonResult<String> saveEngineeringProject(@ApiParam(name = "bizEngineeringProject",value = "工程项目专项检查对象") @RequestBody BizEngineeringProject bizEngineeringProject) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(bizEngineeringProject.getId())){
            bizEngineeringProject.setIsDele("0");
            baseService.create(bizEngineeringProject);
        }else {
            baseService.update(bizEngineeringProject);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "/saveVo",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改工程项目、附件信息",httpMethod = "POST")
    public CommonResult<String> saveVo(@ApiParam(name = "bizEngineeringProjectVo",value = "工程项目专项检查对象") @RequestBody BizEngineeringProjectVo bizEngineeringProjectVo) throws Exception {
        String msg = "添加成功";
        BizEngineeringProject bizEngineeringProject = bizEngineeringProjectVo.getBizEngineeringProject();
        if (StringUtils.isEmpty(bizEngineeringProject.getId())){
            bizEngineeringProject.setIsDele("0");
            baseService.saveVo(bizEngineeringProjectVo);
        }else {
            baseService.updateVo(bizEngineeringProjectVo);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "getJson",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询工程项目信息",httpMethod ="POST")
    public PageList<BizEngineeringProject> getJson(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizEngineeringProject> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
//            queryFilter.addFilter("CREATE_ORG_ID_", String.join("','", baseContext.getCurrentOrgId()), QueryOP.IN, FieldRelation.AND);
            permissionUtils.addPermission(queryFilter);
        }
        PageList<BizEngineeringProject> pageList = baseService.queryBizEngineeringProject(queryFilter);
        return pageList;
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询工程项目信息",httpMethod = "GET",notes = "根据ID查询工程项目信息")
    public BizEngineeringProject get(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getBizEngineeringProjectById(id);
    }
    @GetMapping(value = "getVo/{id}")
    @ApiOperation(value = "根据ID查询工程项目信息",httpMethod = "GET",notes = "根据ID查询工程项目信息")
    public BizEngineeringProjectVo getVo(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getVo(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除工程项目信息",httpMethod = "DELETE",notes = "批量删除工程项目信息")
    public CommonResult<String> removes(@ApiParam(name = "ids",value = "对各主键用逗号分隔",required = true) @RequestParam String... ids) throws Exception{
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true,"删除成功");
    }

    @RequestMapping(value = "/updateEngineeringProject",method = RequestMethod.DELETE,produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除工程项目信息",httpMethod = "DELETE",notes = "逻辑删除工程项目信息")
    public CommonResult<String> updateEngineeringProject(@ApiParam(name = "ids",value = "ID集合以，隔开",required = true)
                                              @RequestParam(value = "ids",required = true)String ids)throws Exception{
        if (StringUtils.isNotBlank(ids)){
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizEngineeringProject> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_",idsList);
            updateWrapper.set("is_dele_","1");
            baseService.update(null,updateWrapper);
        }
        return new CommonResult<>(true,"删除成功");
    }

    @RequestMapping(value="/getList",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "不分页查询项目名称信息",httpMethod = "POST")
    public PageList<BizEngineeringProject> getList(@ApiParam(name="queryFilter", value="不分页查询信息") @RequestBody QueryFilter<BizEngineeringProject> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
//        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
//            queryFilter.addFilter("CREATE_ORG_ID_", String.join("','", baseContext.getCurrentOrgId()), QueryOP.IN, FieldRelation.AND);
//        }
        permissionUtils.addPermission(queryFilter);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE);
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        PageList<BizEngineeringProject>   bizEngineeringProject = baseService.queryBizEngineeringProject(queryFilter);
        return bizEngineeringProject;
    }

    @RequestMapping(value = "updateFlag", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量修改启用禁用状态", httpMethod = "POST", notes = "批量修改启用禁用状态")
    public CommonResult<String> updateFlag(@ApiParam(name = "ids", value = "Id集合，以,隔开") @RequestParam String ids,
                                           @ApiParam(name = "validFlag", value = "有效标志（0：无效  1：有效）") @RequestParam Integer flag) throws Exception {
        bizEngineeringProjectManager.updateFlag(ids, flag);
        return new CommonResult<>(true, "状态修改成功");
    }
}
