package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialproject.model.BizConstructionLog;
import com.artfess.yhxt.specialproject.vo.BizConstructionLogVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.manager.BizConstructionLogManager;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 施工日志表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-11
 */
@RestController
@RequestMapping("/bizConstructionLog/v1/")
@Api(tags = "施工日志管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizConstructionLogController extends BaseController<BizConstructionLogManager, BizConstructionLog> {
    @Resource
    private PermissionUtils permissionUtils;

    @Resource
    private BaseContext baseContext;

    @RequestMapping(value = "/saveConstructionLog",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改施工日志信息",httpMethod = "POST")
    public CommonResult<String> saveEngineeringProject(@ApiParam(name = "bizConstructionLog",value = "施工日志对象") @RequestBody BizConstructionLog bizConstructionLog) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(bizConstructionLog.getId())){
            bizConstructionLog.setIsDele("0");
            baseService.create(bizConstructionLog);
        }else {
            baseService.update(bizConstructionLog);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "/saveVo",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改施工日志、附件信息",httpMethod = "POST")
    public CommonResult<String> saveVo(@ApiParam(name = "bizConstructionLog",value = "施工日志对象") @RequestBody BizConstructionLogVo bizConstructionLogVo) throws Exception {
        String msg = "添加成功";
        BizConstructionLog bizConstructionLog = bizConstructionLogVo.getBizConstructionLog();
        if (StringUtils.isEmpty(bizConstructionLog.getId())){
            bizConstructionLog.setIsDele("0");
            baseService.saveVo(bizConstructionLogVo);
        }else {
            baseService.updateVo(bizConstructionLogVo);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }
    @GetMapping(value = "getVo/{id}")
    @ApiOperation(value = "根据ID查询施工日志、附件信息",httpMethod = "GET",notes = "根据ID查询施工日志、附件信息")
    public BizConstructionLogVo getVo(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getVo(id);
    }


    @RequestMapping(value = "/getJson",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询施工日志",httpMethod ="POST")
    public PageList<BizConstructionLog> getJson(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizConstructionLog> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermissionByCreateOrgId(queryFilter);
        }
        //        permissionUtils.addPermission(queryFilter);
        PageList<BizConstructionLog> pageList = baseService.queryBizConstructionLog(queryFilter);
        return pageList;
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询施工日志信息",httpMethod = "GET",notes = "根据ID查询施工日志")
    public BizConstructionLog get(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getBizConstructionLogById(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除施工日志",httpMethod = "DELETE",notes = "批量删除施工日志")
    public CommonResult<String> removes(@ApiParam(name = "ids",value = "对各主键用逗号分隔",required = true) @RequestParam String... ids) throws Exception{
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true,"删除成功");
    }

    @RequestMapping(value = "/updateConstructionLog",method = RequestMethod.DELETE,produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除施工日志",httpMethod = "DELETE",notes = "逻辑删除施工日志")
    public CommonResult<String> updateProject(@ApiParam(name = "ids",value = "ID集合以，隔开",required = true)
                                              @RequestParam(value = "ids",required = true)String ids)throws Exception{
        if (StringUtils.isNotBlank(ids)){
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizConstructionLog> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_",idsList);
            updateWrapper.set("is_dele_","1");
            baseService.update(null,updateWrapper);
        }
        return new CommonResult<>(true,"删除成功");
    }

}
