package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.DataAccess;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialcheck.vo.ApplicationForChangeOfContractVo;
import com.artfess.yhxt.specialproject.model.BizApplicationForChangeOfContract;
import com.artfess.yhxt.specialproject.vo.ChangeContractVo;
import com.artfess.yhxt.specialproject.vo.ProjectContractVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.model.BizApplicationForChangeOfContract;
import com.artfess.yhxt.specialproject.manager.BizApplicationForChangeOfContractManager;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 合同变更申请表 前端控制器
 *
 * @author wangping
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-12
 */
@RestController
@RequestMapping("/bizApplicationForChangeOfContract/v1/")
@Api(tags = "合同变更申请")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizApplicationForChangeOfContractController extends BaseController<BizApplicationForChangeOfContractManager, BizApplicationForChangeOfContract> {

    @Resource
    private BaseContext baseContext;
    @Resource
    private PermissionUtils permissionUtils;


    @RequestMapping(value = "/saveApplicationForChangeOfContract", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改合同变更申请", httpMethod = "POST")
    public CommonResult<String> saveEngineeringProject(@ApiParam(name = "bizApplicationForChangeOfContract", value = "合同变更申请对象") @RequestBody BizApplicationForChangeOfContract bizApplicationForChangeOfContract) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(bizApplicationForChangeOfContract.getId())) {
            bizApplicationForChangeOfContract.setIsDele("0");
            bizApplicationForChangeOfContract.setChangeConfirmStatus(0);
            baseService.create(bizApplicationForChangeOfContract);
        } else {
            Integer changeConfirmStatus = bizApplicationForChangeOfContract.getChangeConfirmStatus();
            if(changeConfirmStatus !=null && changeConfirmStatus == 2){
                bizApplicationForChangeOfContract.setChangeConfirmStatus(0);
            }
            if(changeConfirmStatus !=null && changeConfirmStatus == 1){
                //如果等于1表示审核通过则将审核后的数据
            }
            baseService.update(bizApplicationForChangeOfContract);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }

    @RequestMapping(value = "/updateChangeConfirmStatusById", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改合同审核状态", httpMethod = "POST")
    public CommonResult<String> updateChangeConfirmStatusById(@ApiParam(name = "ids", value = "ids多个使用逗号隔开")
                                                                  @RequestParam("ids") String ids,
                                                              @ApiParam(name = "changeConfirmStatus", value = "审核状态，0-待审核、1-通过、2-不通过")
                                                              @RequestParam("changeConfirmStatus")Integer changeConfirmStatus) throws Exception {
        String msg = "合同审核操作成功";
        List<String> split = Arrays.asList(ids.split(","));
        UpdateWrapper<BizApplicationForChangeOfContract> wrapper = new UpdateWrapper();
        wrapper.set("CHANGE_CONFIRM_STATUS_", changeConfirmStatus);
        wrapper.in("CONTRACT_ID_",split);
        //如果changeConfirmStatus=1说明已经审核通过了，需要将审核通过的数据填入到合同中去
        if(1 == changeConfirmStatus){
            for (String id : split) {
                ChangeContractVo vo = baseService.getChangeContractVoById(id);
                //合同变更数据同步至合同表
                baseService.synchronousContractData(vo);
            }
        }
        baseService.update(null,wrapper);
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "/getJson", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "分页查询合同变更申请", httpMethod = "POST")
    public PageList<BizApplicationForChangeOfContract> getJson(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizApplicationForChangeOfContract> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermissionByCreateOrgId(queryFilter);
        }
//        permissionUtils.addPermission(queryFilter);
        PageList<BizApplicationForChangeOfContract> pageList = baseService.queryBizApplicationForChangeOfContract(queryFilter);
        return pageList;
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询合同变更申请信息", httpMethod = "GET", notes = "根据ID查询合同变更申请")
    public BizApplicationForChangeOfContract get(@ApiParam(name = "id", value = "业务对象主键", required = true) @PathVariable String id) throws Exception {
        return baseService.getBizApplicationForChangeOfContractById(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除合同变更申请", httpMethod = "DELETE", notes = "批量删除合同变更申请")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "对各主键用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping(value = "/updateApplicationForChangeOfContract", method = RequestMethod.DELETE, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除合同变更申请", httpMethod = "DELETE", notes = "逻辑删除合同变更申请")
    public CommonResult<String> updateProject(@ApiParam(name = "ids", value = "ID集合以，隔开", required = true)
                                              @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizApplicationForChangeOfContract> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("CONTRACT_ID_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }

    @RequestMapping(value = "/saveVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改合同变更申请  待生效", httpMethod = "POST")
    public CommonResult<String> saveVo(@ApiParam(name = "vo", value = "合同变更申请对象 VO") @RequestBody ApplicationForChangeOfContractVo vo) throws Exception {
        String msg = "操作成功";

        this.baseService.saveVo(vo);

        return new CommonResult<String>(true, msg);
    }

    @RequestMapping(value = "/getJsonVo", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "分页查询合同变更", httpMethod = "POST")
    @DataAccess
    public PageList<ProjectContractVo> getJsonVo(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizApplicationForChangeOfContract> queryFilter) {
        queryFilter.addFilter("a.is_dele_", "0", QueryOP.EQUAL);
        queryFilter.addFilter("b.is_dele_", "0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            queryFilter.addFilter("a.CREATE_ORG_ID_", String.join("','", baseContext.getCurrentOrgId()), QueryOP.IN, FieldRelation.AND);
        }
        PageList<ProjectContractVo> pageList = baseService.queryApplicationForChangeOfContractVo(queryFilter);
        return pageList;
    }
    @GetMapping(value = "getVo/{id}")
    @ApiOperation(value = "根据ID查询合同变更申请信息", httpMethod = "GET", notes = "根据ID查询合同变更申请")
    public ChangeContractVo getVo(@ApiParam(name = "id", value = "合同ID", required = true) @PathVariable String id) throws Exception {
        return this.baseService.getChangeContractVoById(id);
    }

}
