package com.artfess.yhxt.specialcheck.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.specialcheck.model.BizBridgeSpecialCheck;
import com.artfess.yhxt.specialcheck.dao.BizBridgeSpecialCheckDao;
import com.artfess.yhxt.specialcheck.manager.BizBridgeSpecialCheckManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialcheck.vo.BizBridgeSpecialCheckVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 桥梁专项检查表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
@Service
public class BizBridgeSpecialCheckManagerImpl extends BaseManagerImpl<BizBridgeSpecialCheckDao, BizBridgeSpecialCheck> implements BizBridgeSpecialCheckManager {
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    private AccessoryManager accessoryManager;
    @Resource
    BaseContext baseContext;
    @Override
    public PageList<BizBridgeSpecialCheck> queryBizBridgeSpecialCheck(QueryFilter<BizBridgeSpecialCheck> queryFilter) {
        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())) {
            permissionUtils.addPermission(queryFilter);
        }
        IPage<BizBridgeSpecialCheck> result = baseMapper.queryBizBridgeSpecialCheck(convert2IPage(queryFilter.getPageBean()), map, convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizBridgeSpecialCheck getBizBridgeSpecialById(String id) {
        BizBridgeSpecialCheck bizBridgeSpecialCheck = baseMapper.selectById(id);
        return bizBridgeSpecialCheck;
    }

    @Override
    public void saveVo(BizBridgeSpecialCheckVo bizBridgeSpecialCheckVo) {
        //桥梁专项检查
        BizBridgeSpecialCheck bizBridgeSpecialCheck = bizBridgeSpecialCheckVo.getBizBridgeSpecialCheck();
        //保存桥梁专项检查信息
        this.create(bizBridgeSpecialCheck);

        //保存附件信息
        List<Accessory> accessoryList = bizBridgeSpecialCheckVo.getAccessories();
        //资源ID
        String id = bizBridgeSpecialCheck.getId();
        if (accessoryList.size() > 0) {
            //删除原来的附件信息
            // this.accessoryManager.delAccessoryBySourceId(id);
            //设置附件资源ID
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }
    }

    @Override
    public void updateVo(BizBridgeSpecialCheckVo bizBridgeSpecialCheckVo) {
        BizBridgeSpecialCheck bizBridgeSpecialCheck = bizBridgeSpecialCheckVo.getBizBridgeSpecialCheck();
        //附件信息
        List<Accessory> accessoryList = bizBridgeSpecialCheckVo.getAccessories();
        //修改桥梁专项检查
        this.update(bizBridgeSpecialCheck);
        //资源ID
        String id = bizBridgeSpecialCheck.getId();
        if (accessoryList.size()>0) {
            //删除原来的附件信息
            this.accessoryManager.delAccessoryBySourceId(id);
            //获取附件信息
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public BizBridgeSpecialCheckVo getVo(String id) {
        BizBridgeSpecialCheckVo bizBridgeSpecialCheckVo = new BizBridgeSpecialCheckVo();
        //获取桥梁专项检查
        BizBridgeSpecialCheck bizBridgeSpecialCheck = this.baseMapper.selectById(id);
        //获取附件信息
        List<Accessory> accessoryList = this.accessoryManager.getAccessoryBySourceId(id);
        bizBridgeSpecialCheckVo.setBizBridgeSpecialCheck(bizBridgeSpecialCheck);
        bizBridgeSpecialCheckVo.setAccessories(accessoryList);
        return bizBridgeSpecialCheckVo;
    }
}
