package com.artfess.yhxt.specialcheck.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.model.TunnelInformation;
import com.artfess.yhxt.specialcheck.model.BizBridgeSpecialCheck;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.specialcheck.vo.BizBridgeSpecialCheckVo;

/**
 * 桥梁专项检查表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
public interface BizBridgeSpecialCheckManager extends BaseManager<BizBridgeSpecialCheck> {

    PageList<BizBridgeSpecialCheck> queryBizBridgeSpecialCheck(QueryFilter<BizBridgeSpecialCheck> queryFilter);

    BizBridgeSpecialCheck getBizBridgeSpecialById(String id);

    /**
     * 桥梁专项检查附件 & 桥梁信息
     * @param bizBridgeSpecialCheckVo
     */
    void saveVo(BizBridgeSpecialCheckVo bizBridgeSpecialCheckVo);

    /**
     * 桥梁专项检查附件 & 桥梁信息
     * @param bizBridgeSpecialCheckVo
     */
    void updateVo(BizBridgeSpecialCheckVo bizBridgeSpecialCheckVo);

    /**
     * 桥梁专项检查、附件详情
     * @param id
     * @return
     */
    BizBridgeSpecialCheckVo getVo(String id);
}
