package com.artfess.yhxt.specialcheck.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialcheck.model.BizTunnelSpecialCheck;
import com.artfess.yhxt.specialcheck.vo.BizTunnelSpecialCheckVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialcheck.model.BizTunnelSpecialCheck;
import com.artfess.yhxt.specialcheck.manager.BizTunnelSpecialCheckManager;

import java.util.Arrays;
import java.util.List;

/**
 * 隧道专项检查表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
@RestController
@RequestMapping("/bizTunnelSpecialCheck/v1/")
@Api(tags = "隧道专项检查接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizTunnelSpecialCheckController extends BaseController<BizTunnelSpecialCheckManager, BizTunnelSpecialCheck> {

    @RequestMapping(value = "/saveTunnel", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改隧道专项检查信息", httpMethod = "POST")
    public CommonResult<BizTunnelSpecialCheck> saveTunnel(@ApiParam(name = "bizTunnelSpecialCheck", value = "隧道专项检查对象") @RequestBody BizTunnelSpecialCheck bizTunnelSpecialCheck) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(bizTunnelSpecialCheck.getId())) {
            bizTunnelSpecialCheck.setIsDele("0");
            baseService.create(bizTunnelSpecialCheck);
        } else {
            baseService.update(bizTunnelSpecialCheck);
            msg = "修改成功";
        }
        return new CommonResult<BizTunnelSpecialCheck>(true,msg,bizTunnelSpecialCheck);
    }


    @RequestMapping(value = "/saveVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改隧道专项检查、附件信息", httpMethod = "POST")
    public CommonResult<BizTunnelSpecialCheckVo> saveVo(@ApiParam(name = "bizTunnelSpecialCheckVo", value = "隧道专项检查、附件对象") @RequestBody BizTunnelSpecialCheckVo bizTunnelSpecialCheckVo) throws Exception {
        String msg = "添加成功";
        BizTunnelSpecialCheck bizTunnelSpecialCheck = bizTunnelSpecialCheckVo.getBizTunnelSpecialCheck();
        if (StringUtils.isEmpty(bizTunnelSpecialCheck.getId())) {
            bizTunnelSpecialCheck.setIsDele("0");
            baseService.saveVo(bizTunnelSpecialCheckVo);
        } else {
            baseService.updateVo(bizTunnelSpecialCheckVo);
            msg = "修改成功";
        }
        return new CommonResult<BizTunnelSpecialCheckVo>(true,msg,bizTunnelSpecialCheckVo);
    }


    @RequestMapping(value="/getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询隧道专项检查信息",httpMethod = "POST")
    public PageList<BizTunnelSpecialCheck> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizTunnelSpecialCheck> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<BizTunnelSpecialCheck> pageList = baseService.queryBizTunnelSpecialCheck(queryFilter);
        return pageList;
    }


    @GetMapping(value="get/{id}")
    @ApiOperation(value="根据ID查询隧道专项检查信息",httpMethod = "GET",notes = "根据ID查询隧道专项检查信息")
    public BizTunnelSpecialCheck get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
        return baseService.getBizBridgeSpecialById(id);
    }

//    向贞好-工程图纸、桥梁、隧道附件接口修改
    @GetMapping(value="getVo/{id}")
    @ApiOperation(value="根据ID查询隧道专项检查、附件信息",httpMethod = "GET",notes = "根据ID查询隧道专项检查、附件信息")
    public BizTunnelSpecialCheckVo getVo(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
        return baseService.getVo(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除隧道专项检查信息", httpMethod = "DELETE", notes = "批量删除隧道专项检查信息")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping(value = "/updateBridge", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除隧道专项检查信息", httpMethod = "DELETE", notes = "逻辑删除隧道专项检查信息")
    public CommonResult<String> updateBridge(@ApiParam(name = "ids", value = "可视化分类ID集合以，隔开", required = true)
                                             @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizTunnelSpecialCheck> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }
}
