package com.artfess.yhxt.push.schedule;

import com.artfess.yhxt.push.service.PushTaskService;
import com.artfess.yhxt.push.service.SynchronizationDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;
import org.springframework.scheduling.annotation.Scheduled;

import javax.annotation.Resource;

/**
 * @author zhx
 * @create 2021/11/29
 */
@Component
@EnableScheduling
/**
 * 同步招商平台数据相关定时任务
 */
public class ScheduledSynchronization {
    @Resource
    SynchronizationDataService synchronizationDataService;
    @Resource
    PushTaskService pushTaskService;

//    @Scheduled(cron = "0 30 0 * * ?")
    public void synchronizationData() {
        try {

            synchronizationDataService.synchronizationOrg();
            synchronizationDataService.synchronizationUser();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

//    @Scheduled(cron = "0 0 1 * * ?")
    public void pushBaseData() {
        try {
            //路产数量
            pushTaskService.JV22BASESTRUCT();
            //路产详情
            pushTaskService.JV22BASESTRUCTDETAIL();
            //基本情况
            pushTaskService.jv21Baseinfo();
            //公司人员
            pushTaskService.JV24EmployeeNew();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Scheduled(cron = "0 0 2 * * ?")
    public void pushDiseaseData() {
        try {
            //病害总数
            System.out.println("病害总数");
            pushTaskService.JVA22DiseaseProjTotal();
            //病害类别- 年
            System.out.println("病害类别- 年");
            pushTaskService.JV313DiseaseYear();
            //病害类别 - 月
            System.out.println("病害类别 - 月");
            pushTaskService.JV313Disease();
            //病害统计数据推送接口
            System.out.println("病害统计数据推送");
            pushTaskService.diseaseCount();
            System.out.println("病害平均处理天数1");
            pushTaskService.jv314DiseaseRatioYear();
            System.out.println("病害平均处理天数2");
            pushTaskService.jv314DiseaseRatio();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    @Scheduled(cron = "0 0 3 * * ?")
    public void pushWorkeData() {
        try {
            //养护任务单据(数量) 年
            pushTaskService.jv312ConstructFinnishYear();
            //养护任务单据(数量) 月
            pushTaskService.jv312ConstructFinnish();
            //日常养护合同完成情况(金额) (年)
            pushTaskService.jv36ProjectProgressYear();
            //日常养护合同完成情况(金额) (月)
            pushTaskService.jv36ProjectProgress();
            //施工中工程项目数量年统计(年)
            pushTaskService.jv35ProjectTypeYear();
            //施工中工程项目数量年统计(月)
            pushTaskService.jv35ProjectType();
            //养护成本
            pushTaskService.jVA2113MAINTAIN();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
