package com.artfess.yhxt.contract.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 日常养护-合同外清单-项目管理表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2022-06-23
 */
@ApiModel(value="BillQuantiTypeManag对象", description="日常养护-合同外清单-项目管理表")
@TableName("BIZ_BILL_QUANTI_TYPE_MANAG")
@Data
public class BillQuantiTypeManag extends BaseModel<BillQuantiTypeManag> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "所在路段id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "CODE编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "1.日常养护-日常养护合同外类型")
    @TableField("TYPE_")
    private Integer type;
    @ApiModelProperty(value = "日常养护-日常养护合同外类型")
    @TableField("PROJECT_NAME_")
    private String projectName;


    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "单位")
    @TableField("SPEC_")
    private String spec;

    @ApiModelProperty(value = "单价")
    @TableField("PRICE_")
    private BigDecimal price;

    @ApiModelProperty(value = "数量")
    @TableField("AMOUNT_")
    private BigDecimal amount;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;



    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BillQuantiTypeManag{" +
            "id=" + id +
            ", roadSegmentId=" + roadSegmentId +
            ", roadSegmentName=" + roadSegmentName +
            ", code=" + code +
            ", type=" + type +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
            ", spec=" + spec +
            ", price=" + price +
            ", amount=" + amount +
            ", createTime=" + createTime +
            ", version=" + version +
            ", projectName=" + projectName +
        "}";
    }
}
