package com.artfess.yhxt.contract.manager;

import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.model.User;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.budget.model.YearBudget;
import com.artfess.yhxt.contract.model.BillOfQuantities;
import com.artfess.yhxt.contract.model.WorkOrderInformation;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.contract.vo.*;
import com.artfess.yhxt.specialproject.model.BizEngineeringProject;
import com.artfess.yhxt.statistics.vo.Org4AppVO;
import com.artfess.yhxt.statistics.vo.OrgVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

/**
 * 工单信息表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-20
 */
public interface WorkOrderInformationManager extends BaseManager<WorkOrderInformation> {

    PageList<WorkOrderInformation> queryWorkOrderInformation(QueryFilter<WorkOrderInformation> queryFilter);

    WorkOrderInformation getWorkOrderInformationById(String id);

    /**
     * 添加工单信息
     * @param vo
     */
    void saveVo(WorkOrderInformationVo vo);

    void updateVo(WorkOrderInformationVo vo);

    WorkOrderInformationVo getVo(String id);

    PageList<WorkOrderVo> getWorkOrderVo(QueryFilter queryFilter);

    List<OrgVO> getWorkOrderCount(String startDate,String endDate);

    Org4AppVO getWorkOrderCount4App(String level,String dimension,String date);

    List<Org4AppVO> getWorkOrderCountList4App(String level,String dimension,String date);

    PageList<WorkOrderDiseaseVo> getWorkOrder(QueryFilter queryFilter);

    CompletableFuture<PageList<Map<String, Object>>> getDoneInstList(String currentUserAccout, QueryFilter queryFilter, String status) throws Exception;

    //待办bizKey
    String getBizkey(String bpmnInstId);

    //查询路段
    Road getRoad(String roadSegmentId);

    /**
     * 根据桥梁Id查询养护工单列表
     * @param workOrderByBridgeVo
     * @return
     */
    PageList<WorkOrderVo> getWorkOrderVoByBridge(WorkOrderAndBaseIdVo workOrderByBridgeVo);

    /**
     * 根据隧道ID查询养护工单列表
     * @param workOrderByBridgeVo
     * @return
     */
    PageList<WorkOrderVo> getWorkOrderVoByTunnel(WorkOrderAndBaseIdVo workOrderByBridgeVo);

    /**
     * 根据涵洞ID查询养护工单列表
     * @param workOrderByBridgeVo
     * @return
     */
    PageList<WorkOrderVo> getWorkOrderVoByCulvert(WorkOrderAndBaseIdVo workOrderByBridgeVo);

    /**
     * 根据边坡ID查询养护工单列表
     * @param workOrderByBridgeVo
     * @return
     */
    PageList<WorkOrderVo> getWorkOrderVoBySideSlope(WorkOrderAndBaseIdVo workOrderByBridgeVo);

    /**
     * 单个工单导出
     * @param ids
     * @param response
     */
    void exportWorkOrder(String ids, HttpServletResponse response) throws IOException;

    /**
     * 按照时间导出工单
     * @param
     * @param response
     */
    void exportWorkOrders(String startTime ,String endTime,String contractId,String type, HttpServletResponse response);

    /**
     * 用户ID
     * @param userId
     * @return
     */
    List<User> getPrincipal(String userId);

    /**
     * 根据id删除工单信息
     * @param ids
     * @return
     */
    boolean deleWorkOrderInformation(String ids);

    List<WorkOrderInformation> listFinishWork(String rodeSegmentId, String first, String last);

    List<WorkOrderInformation> listWorkAll(String rodeSegmentId, String first, String last);

    /**
     * 根据合同Id查询查询合同内
     * @param contractId
     * @return
     */
    List<WorkOrderInformation> getWorkOrderContract(String contractId, WorkOrderParamVo param);

    List<OrderReportVO> getReport(String year,String orgId);

    List<OrderMoneyVO> getMoneyReport(String year,String orgId);

    List<OrderCheckVO> getCheckReport(String year,String orgId);

    List<OrderMonthVO> getMonthReport(String year,String orgId);

    List<OrderWorkFinishVO> getWorkFinishReport(String year,String orgId);

    /**
     * 获取养护资金执行情况报表
     *
     * @return
     */
    PageList<OrderCashVo> getOrderCashReport(QueryFilter<YearBudget> queryFilter);

    /**
     * 获取养护专项资金执行情况报表
     * @param queryFilter
     * @return
     */
    PageList<OrderSpecialCashVo> getOrderSpecialCashReport(QueryFilter<BizEngineeringProject> queryFilter);

    void exportOrderCashReport(QueryFilter<YearBudget> queryFilter, HttpServletResponse response);

    void exportOrderSpecialCashReport(QueryFilter<BizEngineeringProject> queryFilter, HttpServletResponse response);

    void approve(String id, Integer state);

    PageList<OrderItemCountVo> orderItemCountReport(QueryFilter<WorkOrderInformation> queryFilter);

    void orderItemCountReportExport(QueryFilter<WorkOrderInformation> queryFilter, HttpServletResponse response)  throws IOException;

    void exportWorkOrdersConstruction(String startTime, String endTime, String contractId, String type, HttpServletResponse response) throws Exception;


}
