package com.artfess.yhxt.check.regular.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 桥梁定期检查表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-16
 */
@ApiModel(value="BridgeRegularCheck对象", description="桥梁定期检查表")
@TableName("biz_bridge_regular_check")
public class BridgeRegularCheck extends BizModel<BridgeRegularCheck> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "桥梁id")
    @TableField("BRIGE_ID_")
    private String brigeId;


    @ApiModelProperty(value = "桥梁名称")
    @TableField("BRIGE_NAME_")
    private String brigeName;

    @ApiModelProperty(value = "上次大中修日期")
    @TableField("LAST_REPAIR_DATE_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private LocalDate lastRepairDate;

    @ApiModelProperty(value = "上次检查日期")
    @TableField("LAST_CHECK_DATE_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private LocalDate lastCheckDate;

    @ApiModelProperty(value = "本次检查日期")
    @TableField("CHECK_DATE_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private LocalDate checkDate;

    @ApiModelProperty(value = "天气")
    @TableField("WEATHER_")
    private String weather;

    @ApiModelProperty(value = "总体状况评定等级")
    @TableField("OVERALL_RATING_")
    private String overallRating;

    @ApiModelProperty(value = "全桥清洁情况评分")
    @TableField("CLEAN_SCORE_")
    private String cleanScore;

    @ApiModelProperty(value = "保养、小修情况评分")
    @TableField("MAINTAIN_SCORE_")
    private String maintainScore;

    @ApiModelProperty(value = "养护建议")
    @TableField("MAINTAIN_PROPOSAL_")
    private String maintainProposal;

    @ApiModelProperty(value = "记录人")
    @TableField("NOTE_TAKER_")
    private String noteTaker;

    @ApiModelProperty(value = "负责人")
    @TableField("PERSON_IN_CHARGE_")
    private String personInCharge;

    @ApiModelProperty(value = "下次检查日期")
    @TableField("NEXT_CHECK_DATE_")
    private LocalDate nextCheckDate;

    @ApiModelProperty(value = "处置情况")
    @TableField("PROCESSING_")
    private String processing;

    @ApiModelProperty(value = "附件地址")
    @TableField("URL_")
    private String url;

    @ApiModelProperty(value = "天气值")
    @TableField("WEATHER_VALUE_")
    private String weatherValue;

    @ApiModelProperty(value = "总体状况评定等级值")
    @TableField("OVERALL_RATING_VALUE_")
    private String overallRatingValue;

    @ApiModelProperty(value = "检查明细")
    @TableField("CHCEK_DETAIL_JSON_")
    private String chcekDetailJson;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getBrigeId() {
        return brigeId;
    }

    public void setBrigeId(String brigeId) {
        this.brigeId = brigeId;
    }
    public LocalDate getLastRepairDate() {
        return lastRepairDate;
    }

    public void setLastRepairDate(LocalDate lastRepairDate) {
        this.lastRepairDate = lastRepairDate;
    }
    public LocalDate getLastCheckDate() {
        return lastCheckDate;
    }

    public void setLastCheckDate(LocalDate lastCheckDate) {
        this.lastCheckDate = lastCheckDate;
    }
    public LocalDate getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(LocalDate checkDate) {
        this.checkDate = checkDate;
    }
    public String getWeather() {
        return weather;
    }

    public void setWeather(String weather) {
        this.weather = weather;
    }
    public String getOverallRating() {
        return overallRating;
    }

    public void setOverallRating(String overallRating) {
        this.overallRating = overallRating;
    }
    public String getCleanScore() {
        return cleanScore;
    }

    public void setCleanScore(String cleanScore) {
        this.cleanScore = cleanScore;
    }
    public String getMaintainScore() {
        return maintainScore;
    }

    public void setMaintainScore(String maintainScore) {
        this.maintainScore = maintainScore;
    }
    public String getMaintainProposal() {
        return maintainProposal;
    }

    public void setMaintainProposal(String maintainProposal) {
        this.maintainProposal = maintainProposal;
    }
    public String getNoteTaker() {
        return noteTaker;
    }

    public void setNoteTaker(String noteTaker) {
        this.noteTaker = noteTaker;
    }
    public String getPersonInCharge() {
        return personInCharge;
    }

    public void setPersonInCharge(String personInCharge) {
        this.personInCharge = personInCharge;
    }
    public LocalDate getNextCheckDate() {
        return nextCheckDate;
    }

    public void setNextCheckDate(LocalDate nextCheckDate) {
        this.nextCheckDate = nextCheckDate;
    }
    public String getProcessing() {
        return processing;
    }

    public void setProcessing(String processing) {
        this.processing = processing;
    }
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
    public String getWeatherValue() {
        return weatherValue;
    }

    public void setWeatherValue(String weatherValue) {
        this.weatherValue = weatherValue;
    }
    public String getOverallRatingValue() {
        return overallRatingValue;
    }

    public void setOverallRatingValue(String overallRatingValue) {
        this.overallRatingValue = overallRatingValue;
    }
    public String getChcekDetailJson() {
        return chcekDetailJson;
    }

    public void setChcekDetailJson(String chcekDetailJson) {
        this.chcekDetailJson = chcekDetailJson;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    public String getBrigeName() {
        return brigeName;
    }

    public void setBrigeName(String brigeName) {
        this.brigeName = brigeName;
    }

    @Override
    public String toString() {
        return "BridgeRegularCheck{" +
            "id=" + id +
            ", brigeId=" + brigeId +
            ", brigeName=" + brigeName +
            ", lastRepairDate=" + lastRepairDate +
            ", lastCheckDate=" + lastCheckDate +
            ", checkDate=" + checkDate +
            ", weather=" + weather +
            ", overallRating=" + overallRating +
            ", cleanScore=" + cleanScore +
            ", maintainScore=" + maintainScore +
            ", maintainProposal=" + maintainProposal +
            ", noteTaker=" + noteTaker +
            ", personInCharge=" + personInCharge +
            ", nextCheckDate=" + nextCheckDate +
            ", processing=" + processing +
            ", url=" + url +
            ", weatherValue=" + weatherValue +
            ", overallRatingValue=" + overallRatingValue +
            ", chcekDetailJson=" + chcekDetailJson +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
            ", brigeName=" + brigeName +

        "}";
    }
}
