package com.artfess.yhxt.check.regular.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.context.BaseContext;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.model.SysDictionaryDetail;
import com.artfess.yhxt.basedata.manager.*;
import com.artfess.yhxt.check.detail.manager.*;
import com.artfess.yhxt.check.regular.manager.*;
import io.jsonwebtoken.lang.Assert;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.util.Zip4jConstants;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @author zhx
 * @create 2022/3/16
 */
@Service
public class CheckExportRegularManagerImpl implements CheckExportRegularManager {
    @Resource
    private BridgeInformationManager bridgeInformationManager;

    @Resource
    private BridgeRegularCheckManager bridgeRegularCheckManager;
    @Resource
    private BridgeRegularCheckDetailManager bridgeRegularCheckDetailManager;


    @Resource
    private SysDictionaryManager sysDictionaryManager;
    @Resource
    private RoadManager roadManager;
    @Resource
    BaseContext  baseContext;
    @Override
    public void exportBridgeRegular(String ids, HttpServletResponse response) {
        try {
            long time = System.currentTimeMillis();
            String fileName = "桥梁定期检查" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            //查询桥梁定期检查字典
            Map<String, List<SysDictionaryDetail>> qldqjclsq = sysDictionaryManager.queryDictItemsByCode("qldqjclsq");
            List<String> strings = Arrays.asList(ids.split(","));

            List<SysDictionaryDetail> sysDictionaryDetails = qldqjclsq.get("qldqjclsq");
            for (int i = 0; i < sysDictionaryDetails.size(); i++) {
                Map map = (Map) sysDictionaryDetails.get(i);
                SysDictionaryDetail detail = BeanUtil.toBean(map, SysDictionaryDetail.class);
                String[] split = detail.getName().split("-");
                System.out.println(split.length);
                if (split.length==2) System.out.println(split[0]+"==="+split[1]);
                if (split.length==1) System.out.println(split[0]);



            }


            this.zip(fileName, true);
            String zip = fileName + ".zip";

            HttpUtil.downLoadFile(response, zip, zip);
            // 删除导出的文件
            FileUtil.deleteFile(zip);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }

    /**
     * 压缩文件
     *
     * @param path     压缩文件\文件夹路径
     * @param isDelete 压缩后是否删除原文件\文件夹
     */
    private void zip(String path, Boolean isDelete) {
        ZipFile zipFile = null;
        try {
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(Zip4jConstants.COMP_DEFLATE);
            parameters.setCompressionLevel(Zip4jConstants.DEFLATE_LEVEL_NORMAL);
            File file = new File(path);
            Assert.isTrue(file.exists(), "文件不存在");
            ArrayList<String> list = new ArrayList<>();
            if (file.isDirectory()) {
                zipFile = new ZipFile(new File(path + ".zip"));
                zipFile.setFileNameCharset("GBK");
                zipFile.addFolder(path, parameters);
            } else {
                zipFile = new ZipFile(new File(path.split(".")[0] + ".zip"));
                zipFile.setFileNameCharset("GBK");
                zipFile.addFile(file, parameters);
            }
            if (isDelete) {
                FileUtil.deleteDir(file);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //设置边框
    private void setExcelStyle(HSSFCellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.MEDIUM);
        cellStyle.setBorderLeft(BorderStyle.MEDIUM);
        cellStyle.setBorderRight(BorderStyle.MEDIUM);
        cellStyle.setWrapText(true);
    }
}
