package com.artfess.yhxt.check.regular.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.model.SysDictionaryDetail;
import com.artfess.uc.exception.BaseException;
import com.artfess.yhxt.basedata.manager.*;
import com.artfess.yhxt.basedata.model.*;
import com.artfess.yhxt.check.detail.manager.BridgeOftenCheckDetailManager;
import com.artfess.yhxt.check.detail.manager.CulvertOftenCheckDetailManager;
import com.artfess.yhxt.check.detail.manager.SideSlopeOftenCheckDetailManager;
import com.artfess.yhxt.check.detail.manager.TunnelOftenCheckDetailManager;
import com.artfess.yhxt.check.detail.model.BridgeOftenCheckDetail;
import com.artfess.yhxt.check.detail.model.CulvertOftenCheckDetail;
import com.artfess.yhxt.check.detail.model.SideSlopeOftenCheckDetail;
import com.artfess.yhxt.check.detail.model.TunnelOftenCheckDetail;
import com.artfess.yhxt.check.regular.manager.*;
import com.artfess.yhxt.check.regular.model.BridgeOftenCheck;
import com.artfess.yhxt.check.regular.model.CulvertOftenCheck;
import com.artfess.yhxt.check.regular.model.SideSlopeOftenCheck;
import com.artfess.yhxt.check.regular.model.TunnelOftenCheck;
import com.artfess.yhxt.util.StreamUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.jsonwebtoken.lang.Assert;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.util.Zip4jConstants;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.jsoup.select.Collector;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

/**
 * @author zhx
 * @create 2022/3/2
 */
@Service
public class CheckExportOftenManagerImpl implements CheckExportOftenManager {

    @Resource
    private BridgeInformationManager bridgeInformationManager;

    @Resource
    private BridgeOftenCheckManager bridgeOftenCheckManager;
    @Resource
    private BridgeOftenCheckDetailManager bridgeOftenCheckDetailManager;
    @Resource
    private TunnelInformationManager tunnelInformationManager;
    @Resource
    private TunnelOftenCheckManager tunnelOftenCheckManager;
    @Resource
    private TunnelOftenCheckDetailManager tunnelOftenCheckDetailManager;
    @Resource
    private BizCulvertInformationManager culvertInformationManager;
    @Resource
    private CulvertOftenCheckManager culvertOftenCheckManager;
    @Resource
    private CulvertOftenCheckDetailManager culvertOftenCheckDetailManager;
    @Resource
    private SideSlopeInformationManager sideSlopeInformationManager;
    @Resource
    private SideSlopeOftenCheckManager sideSlopeOftenCheckManager;
    @Resource
    private SideSlopeOftenCheckDetailManager sideSlopeOftenCheckDetailManager;

    @Resource
    private SysDictionaryManager sysDictionaryManager;
    @Resource
    private RoadManager roadManager;

    private static final String FX="fx";

    @Override
    public void exportBridgeOften(String ids, HttpServletResponse response) {
        try {
            long time = System.currentTimeMillis();
            String fileName = "桥梁经常检查记录表" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            //查询桥梁经常检查字典
            Map<String, List<SysDictionaryDetail>> qljcmxb = sysDictionaryManager.queryDictItemsByCode("qljcmxb");
            Map<String, List<SysDictionaryDetail>> qljcmxblsq = sysDictionaryManager.queryDictItemsByCode("qljcmxblsq");
            List<String> strings = Arrays.asList(ids.split(","));
            strings.forEach(s -> {
                        //查询桥梁信息
                        BridgeInformation bridge = bridgeInformationManager.getBridgeById(s);
                        //根据桥梁信息查询路段
                        Road road = roadManager.getById(bridge.getRoadSegmentId());

                        QueryWrapper<BridgeOftenCheck> queryWrapper = new QueryWrapper<BridgeOftenCheck>();
                        //查询最新一次的检查信息
                        BridgeOftenCheck bridgeOftenCheck = bridgeOftenCheckManager.getBaseMapper().selectOne(queryWrapper.eq("BRIGE_ID_", s).orderByDesc("CHECK_DATE_").orderByDesc("CREATE_TIME_").last("limit 0,1"));
                        HSSFWorkbook workbook = new HSSFWorkbook();
                        HSSFCellStyle cellStyle = workbook.createCellStyle();
                        HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
                        setExcelStyle(cellStyle, workbook);
                        HSSFSheet sheet = workbook.createSheet(" 桥梁经常检查记录表");
                        sheet.getPrintSetup().setPaperSize(HSSFPrintSetup.A4_PAPERSIZE);
                        if (bridgeOftenCheck != null) {
                            if (bridge.getBriShape() == null || bridge.getBriShape() == 1) {
                                exportBeamBridgeData(file, bridge, road, bridgeOftenCheck, workbook, cellStyle, cellStyleTitle, sheet);
                            }
                            if (bridge.getBriShape() != null && bridge.getBriShape() == 10) {
                                exportBriCableStayedData(file, bridge, road, bridgeOftenCheck, workbook, cellStyle, cellStyleTitle, sheet);
                            }


                        } else {
                            if (bridge.getBriShape() == null || bridge.getBriShape() == 1) {
                                exportBeamBridge(file, qljcmxblsq, bridge, road, workbook, cellStyle, cellStyleTitle, sheet);
                            }
                            if (bridge.getBriShape() != null && bridge.getBriShape() == 10) {
                                exportBriCableStayed(file, qljcmxb, bridge, road, workbook, cellStyle, cellStyleTitle, sheet);
                            }

                        }
                    }
            );
            this.zip(fileName, true);
            String zip = fileName + ".zip";

            HttpUtil.downLoadFile(response, zip, zip);
            // 删除导出的文件
            FileUtil.deleteFile(zip);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }

    }

    //梁式桥data
    private void exportBeamBridgeData(File file, BridgeInformation bridge, Road road, BridgeOftenCheck bridgeOftenCheck, HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFCellStyle cellStyleTitle, HSSFSheet sheet) {
        sheet.setColumnWidth(0, 20 * 256);
        sheet.setColumnWidth(1, 10 * 256);
        sheet.setColumnWidth(2, 8 * 256);
        sheet.setColumnWidth(3, 15 * 256);
        sheet.setColumnWidth(4, 11 * 256);
        sheet.setColumnWidth(5, 10 * 256);
        sheet.setColumnWidth(6, 10 * 256);
        List<BridgeOftenCheckDetail> list = bridgeOftenCheckDetailManager.list(new QueryWrapper<BridgeOftenCheckDetail>().lambda().eq(BridgeOftenCheckDetail::getBridgeOftenCheckId, bridgeOftenCheck.getId()));
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 6));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 6));
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 2, 3));
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 5, 6));
        HSSFRow row0 = sheet.createRow(0);
        HSSFCell cell0 = row0.createCell(0);
        cell0.setCellValue(" 桥梁经常检查记录表");
        cell0.setCellStyle(cellStyleTitle);
        setExcelStyleTitle(cellStyleTitle, workbook);

        HSSFRow row1 = sheet.createRow(1);
        HSSFCell cell = row1.createCell(0);
        HSSFCell cell1 = row1.createCell(1);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("管理单位");
        cell1.setCellStyle(cellStyle);
        cell1.setCellValue(getCompany(bridge.getOfficeName()));
        row1.createCell(2).setCellStyle(cellStyle);
        row1.createCell(3).setCellStyle(cellStyle);
        row1.createCell(4).setCellStyle(cellStyle);
        row1.createCell(5).setCellStyle(cellStyle);
        row1.createCell(6).setCellStyle(cellStyle);
        HSSFRow row2 = sheet.createRow(2);
        HSSFCell cell2 = row2.createCell(0);
        cell2.setCellValue("路线编码");
        cell2.setCellStyle(cellStyle);
        HSSFCell cell3 = row2.createCell(1);
        cell3.setCellStyle(cellStyle);
        cell3.setCellValue(road.getCode());

        HSSFCell cell4 = row2.createCell(3);
        cell4.setCellValue("路线名称");
        cell4.setCellStyle(cellStyle);

        HSSFCell cell5 = row2.createCell(4);
        cell5.setCellValue(road.getName());
        cell5.setCellStyle(cellStyle);
        HSSFCell cell6 = row2.createCell(5);
        cell6.setCellValue("桥位桩号");
        cell6.setCellStyle(cellStyle);
        HSSFCell cell7 = row2.createCell(6);
        cell7.setCellValue(bridge.getCentPeg());
        cell7.setCellStyle(cellStyle);
        row2.createCell(2).setCellStyle(cellStyle);

        HSSFRow row3 = sheet.createRow(3);
        HSSFCell cell8 = row3.createCell(0);
        cell8.setCellValue("桥梁编码");
        cell8.setCellStyle(cellStyle);
        HSSFCell cell9 = row3.createCell(1);
        cell9.setCellStyle(cellStyle);
        cell9.setCellValue(bridge.getNumber());

        HSSFCell cell10 = row3.createCell(3);
        cell10.setCellValue("桥梁名称");
        cell10.setCellStyle(cellStyle);

        HSSFCell cell11 = row3.createCell(4);
        cell11.setCellValue(bridge.getName() + "(" + bridge.getDirectionValue() + ")");
        cell11.setCellStyle(cellStyle);
        HSSFCell cell12 = row3.createCell(5);
        cell12.setCellValue("总体评价");
        cell12.setCellStyle(cellStyle);
        HSSFCell cell13 = row3.createCell(6);
        cell13.setCellValue(bridgeOftenCheck.getEvaluateValue());
        cell13.setCellStyle(cellStyle);
        row3.createCell(2).setCellStyle(cellStyle);

        HSSFRow row4 = sheet.createRow(4);
        HSSFCell cell14 = row4.createCell(0);
        cell14.setCellValue("部件名称");
        cell14.setCellStyle(cellStyle);
        HSSFCell cell15 = row4.createCell(1);
        cell15.setCellValue("缺损类型");
        cell15.setCellStyle(cellStyle);
        HSSFCell cell16 = row4.createCell(2);
        cell16.setCellValue("缺损范围");
        cell16.setCellStyle(cellStyle);
        HSSFCell cell17 = row4.createCell(4);
        cell17.setCellValue("保养措施意见");
        cell17.setCellStyle(cellStyle);
        HSSFCell cell18 = row4.createCell(5);
        cell18.setCellValue("处理措施");
        cell18.setCellStyle(cellStyle);
        row4.createCell(3).setCellStyle(cellStyle);
        row4.createCell(6).setCellStyle(cellStyle);
        row0.setHeight((short) (32 * 20));
        row1.setHeight((short) (29 * 20));
        row2.setHeight((short) (29 * 20));
        row3.setHeight((short) (29 * 20));
        row4.setHeight((short) (29 * 20));
        for (int i = 0; i < list.size(); i++) {
            HSSFRow row5 = sheet.createRow(5 + i);
            sheet.addMergedRegion(new CellRangeAddress(5 + i, 5 + i, 2, 3));
            sheet.addMergedRegion(new CellRangeAddress(5 + i, 5 + i, 5, 6));
            BridgeOftenCheckDetail bridgeOftenCheckDetail = list.get(i);
            row5.setHeight((short) (25 * 20));
            HSSFCell cell19 = row5.createCell(0);
            cell19.setCellValue(bridgeOftenCheckDetail.getName());
            cell19.setCellStyle(cellStyle);
            HSSFCell cell20 = row5.createCell(1);
            cell20.setCellValue(bridgeOftenCheckDetail.getDefectType());
            cell20.setCellStyle(cellStyle);
            HSSFCell cell21 = row5.createCell(2);
            cell21.setCellValue(bridgeOftenCheckDetail.getDefectScope());
            cell21.setCellStyle(cellStyle);
            HSSFCell cell22 = row5.createCell(4);
            cell22.setCellValue(bridgeOftenCheckDetail.getMaintainAdvice());
            cell22.setCellStyle(cellStyle);
            HSSFCell cell23 = row5.createCell(5);
            cell23.setCellValue(bridgeOftenCheckDetail.getProcessMode());
            cell23.setCellStyle(cellStyle);
            row5.createCell(3).setCellStyle(cellStyle);
            row5.createCell(6).setCellStyle(cellStyle);

        }
        HSSFRow row5 = sheet.createRow(5 + list.size());
        sheet.addMergedRegion(new CellRangeAddress(5 + list.size(), 5 + list.size(), 1, 2));
        HSSFCell cell24 = row5.createCell(0);
        cell24.setCellStyle(cellStyle);
        cell24.setCellValue("负责人");
        HSSFCell cell25 = row5.createCell(1);
        cell25.setCellStyle(cellStyle);
        cell25.setCellValue(bridgeOftenCheck.getRummager());
        HSSFCell cell26 = row5.createCell(3);
        cell26.setCellStyle(cellStyle);
        cell26.setCellValue("记录人");
        HSSFCell cell27 = row5.createCell(4);
        cell27.setCellStyle(cellStyle);
        cell27.setCellValue(bridgeOftenCheck.getNoteTaker());
        HSSFCell cell28 = row5.createCell(5);
        cell28.setCellStyle(cellStyle);
        cell28.setCellValue("检查日期");
        HSSFCell cell29 = row5.createCell(6);
        cell29.setCellStyle(cellStyle);
        String dateStr = new SimpleDateFormat("yyyy/MM/dd").format(bridgeOftenCheck.getCheckDate());
        cell29.setCellValue(dateStr);
        row5.createCell(2).setCellStyle(cellStyle);

        try {
            OutputStream os = new FileOutputStream(file + "/" + bridge.getName() + "-" + bridge.getNumber() + "-" + bridge.getDirectionValue() +"-"+new SimpleDateFormat("yyyy-MM-dd").format(bridgeOftenCheck.getCheckDate()) + ".xls");
            workbook.write(os);
            os.flush();
            os.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //梁式桥
    private void exportBeamBridge(File file, Map<String, List<SysDictionaryDetail>> qljcmxblsq, BridgeInformation bridge, Road road, HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFCellStyle cellStyleTitle, HSSFSheet sheet) {
        sheet.setColumnWidth(0, 20 * 256);
        sheet.setColumnWidth(1, 10 * 256);
        sheet.setColumnWidth(2, 8 * 256);
        sheet.setColumnWidth(3, 15 * 256);
        sheet.setColumnWidth(4, 11 * 256);
        sheet.setColumnWidth(5, 10 * 256);
        sheet.setColumnWidth(6, 10 * 256);

        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 6));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 6));
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 2, 3));
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 5, 6));
        HSSFRow row0 = sheet.createRow(0);
        HSSFCell cell0 = row0.createCell(0);
        cell0.setCellValue(" 桥梁经常检查记录表");
        cell0.setCellStyle(cellStyleTitle);
        setExcelStyleTitle(cellStyleTitle, workbook);

        HSSFRow row1 = sheet.createRow(1);
        HSSFCell cell = row1.createCell(0);
        HSSFCell cell1 = row1.createCell(1);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("管理单位");
        cell1.setCellStyle(cellStyle);
        cell1.setCellValue(getCompany(bridge.getOfficeName()));
        row1.createCell(2).setCellStyle(cellStyle);
        row1.createCell(3).setCellStyle(cellStyle);
        row1.createCell(4).setCellStyle(cellStyle);
        row1.createCell(5).setCellStyle(cellStyle);
        row1.createCell(6).setCellStyle(cellStyle);
        HSSFRow row2 = sheet.createRow(2);
        HSSFCell cell2 = row2.createCell(0);
        cell2.setCellValue("路线编码");
        cell2.setCellStyle(cellStyle);
        HSSFCell cell3 = row2.createCell(1);
        cell3.setCellStyle(cellStyle);
        cell3.setCellValue(road.getCode());

        HSSFCell cell4 = row2.createCell(3);
        cell4.setCellValue("路线名称");
        cell4.setCellStyle(cellStyle);

        HSSFCell cell5 = row2.createCell(4);
        cell5.setCellValue(road.getName());
        cell5.setCellStyle(cellStyle);
        HSSFCell cell6 = row2.createCell(5);
        cell6.setCellValue("桥位桩号");
        cell6.setCellStyle(cellStyle);
        HSSFCell cell7 = row2.createCell(6);
        cell7.setCellValue(bridge.getCentPeg());
        cell7.setCellStyle(cellStyle);
        row2.createCell(2).setCellStyle(cellStyle);

        HSSFRow row3 = sheet.createRow(3);
        HSSFCell cell8 = row3.createCell(0);
        cell8.setCellValue("桥梁编码");
        cell8.setCellStyle(cellStyle);
        HSSFCell cell9 = row3.createCell(1);
        cell9.setCellStyle(cellStyle);
        cell9.setCellValue(bridge.getNumber());

        HSSFCell cell10 = row3.createCell(3);
        cell10.setCellValue("桥梁名称");
        cell10.setCellStyle(cellStyle);

        HSSFCell cell11 = row3.createCell(4);
        cell11.setCellValue(bridge.getName() + "(" + bridge.getDirectionValue() + ")");
        cell11.setCellStyle(cellStyle);
        HSSFCell cell12 = row3.createCell(5);
        cell12.setCellValue("总体评价");
        cell12.setCellStyle(cellStyle);
        HSSFCell cell13 = row3.createCell(6);
        cell13.setCellStyle(cellStyle);
        row3.createCell(2).setCellStyle(cellStyle);
        HSSFRow row4 = sheet.createRow(4);
        HSSFCell cell14 = row4.createCell(0);
        cell14.setCellValue("部件名称");
        cell14.setCellStyle(cellStyle);
        HSSFCell cell15 = row4.createCell(1);
        cell15.setCellValue("缺损类型");
        cell15.setCellStyle(cellStyle);
        HSSFCell cell16 = row4.createCell(2);
        cell16.setCellValue("缺损范围");
        cell16.setCellStyle(cellStyle);
        HSSFCell cell17 = row4.createCell(4);
        cell17.setCellValue("保养措施意见");
        cell17.setCellStyle(cellStyle);
        HSSFCell cell18 = row4.createCell(5);
        cell18.setCellValue("处理措施");
        cell18.setCellStyle(cellStyle);
        List<SysDictionaryDetail> list = qljcmxblsq.get("qljcmxblsq");
        row4.createCell(3).setCellStyle(cellStyle);
        row4.createCell(6).setCellStyle(cellStyle);
        row0.setHeight((short) (32 * 20));
        row1.setHeight((short) (29 * 20));
        row2.setHeight((short) (29 * 20));
        row3.setHeight((short) (29 * 20));
        row4.setHeight((short) (29 * 20));
        for (int i = 0; i < list.size(); i++) {
            HSSFRow row5 = sheet.createRow(5 + i);
            sheet.addMergedRegion(new CellRangeAddress(5 + i, 5 + i, 2, 3));
            sheet.addMergedRegion(new CellRangeAddress(5 + i, 5 + i, 5, 6));
            SysDictionaryDetail detail = null;
            try {
                Map map = (Map) list.get(i);
                detail = BeanUtil.toBean(map, SysDictionaryDetail.class);
            } catch (Exception e) {
                detail = list.get(i);
            }
            row5.setHeight((short) (25 * 20));
            HSSFCell cell19 = row5.createCell(0);
            cell19.setCellValue(detail.getName());
            cell19.setCellStyle(cellStyle);
            HSSFCell cell20 = row5.createCell(1);
            cell20.setCellStyle(cellStyle);
            HSSFCell cell21 = row5.createCell(2);
            cell21.setCellStyle(cellStyle);
            HSSFCell cell22 = row5.createCell(4);
            cell22.setCellStyle(cellStyle);
            HSSFCell cell23 = row5.createCell(5);
            cell23.setCellStyle(cellStyle);
            row5.createCell(3).setCellStyle(cellStyle);
            row5.createCell(6).setCellStyle(cellStyle);

        }
        HSSFRow row5 = sheet.createRow(5 + list.size());
        sheet.addMergedRegion(new CellRangeAddress(5 + list.size(), 5 + list.size(), 1, 2));
        HSSFCell cell24 = row5.createCell(0);
        cell24.setCellStyle(cellStyle);
        cell24.setCellValue("负责人");
        HSSFCell cell25 = row5.createCell(1);
        cell25.setCellStyle(cellStyle);
        HSSFCell cell26 = row5.createCell(3);
        cell26.setCellStyle(cellStyle);
        cell26.setCellValue("记录人");
        HSSFCell cell27 = row5.createCell(4);
        cell27.setCellStyle(cellStyle);
        HSSFCell cell28 = row5.createCell(5);
        cell28.setCellStyle(cellStyle);
        cell28.setCellValue("检查日期");
        row5.createCell(2).setCellStyle(cellStyle);
        row5.createCell(6).setCellStyle(cellStyle);

        try {
            OutputStream os = new FileOutputStream(file + "/" + bridge.getName() + "-" + bridge.getNumber() + "-" + bridge.getDirectionValue() + System.currentTimeMillis() + ".xls");
            workbook.write(os);
            os.flush();
            os.close();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }

    //斜拉
    private void exportBriCableStayed(File file, Map<String, List<SysDictionaryDetail>> qljcmxb, BridgeInformation bridge, Road road, HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFCellStyle cellStyleTitle, HSSFSheet sheet) {
        sheet.setColumnWidth(0, 20 * 256);
        sheet.setColumnWidth(1, 10 * 256);
        sheet.setColumnWidth(2, 10 * 256);
        sheet.setColumnWidth(3, 25 * 256);
        sheet.setColumnWidth(4, 9 * 256);
        sheet.setColumnWidth(5, 10 * 256);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 5));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 5));
        HSSFRow row0 = sheet.createRow(0);
        HSSFCell cell21 = row0.createCell(0);
        cell21.setCellValue(" 桥梁经常检查记录表");
        cell21.setCellStyle(cellStyleTitle);
        setExcelStyleTitle(cellStyleTitle, workbook);
        HSSFRow row = sheet.createRow(1);
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle(cellStyle);
        HSSFCell cell20 = row.createCell(1);
        cell20.setCellStyle(cellStyle);
        cell20.setCellValue(getCompany(bridge.getOfficeName()));
        row.createCell(2).setCellStyle(cellStyle);
        row.createCell(3).setCellStyle(cellStyle);
        row.createCell(4).setCellStyle(cellStyle);
        row.createCell(5).setCellStyle(cellStyle);
        cell.setCellValue("管理单位");
        HSSFRow row1 = sheet.createRow(2);
        HSSFCell cell1 = row1.createCell(0);
        cell1.setCellStyle(cellStyle);
        cell1.setCellValue("路线编号");
        HSSFCell cell2 = row1.createCell(1);
        cell2.setCellStyle(cellStyle);
        cell2.setCellValue(road.getCode());
        HSSFCell cell3 = row1.createCell(2);
        cell3.setCellStyle(cellStyle);
        cell3.setCellValue("路线名称");
        HSSFCell cell4 = row1.createCell(3);
        cell4.setCellStyle(cellStyle);
        cell4.setCellValue(road.getName());
        HSSFCell cell5 = row1.createCell(4);
        cell5.setCellStyle(cellStyle);
        cell5.setCellValue("桥位桩号");
        HSSFCell cell6 = row1.createCell(5);
        cell6.setCellStyle(cellStyle);
        cell6.setCellValue(bridge.getCentPeg());
        HSSFRow row2 = sheet.createRow(3);
        HSSFCell cell7 = row2.createCell(0);
        cell7.setCellStyle(cellStyle);
        cell7.setCellValue("桥梁编号");
        HSSFCell cell8 = row2.createCell(1);
        cell8.setCellStyle(cellStyle);
        cell8.setCellValue(bridge.getNumber());
        HSSFCell cell9 = row2.createCell(2);
        cell9.setCellStyle(cellStyle);
        cell9.setCellValue("桥梁名称");
        HSSFCell cell10 = row2.createCell(3);
        cell10.setCellStyle(cellStyle);
        cell10.setCellValue(bridge.getName());
        HSSFCell cell11 = row2.createCell(4);
        cell11.setCellStyle(cellStyle);
        cell11.setCellValue("养护单位");
        HSSFCell cell12 = row2.createCell(5);
        cell12.setCellStyle(cellStyle);
        cell12.setCellValue(bridge.getOfficeName());
        HSSFRow row3 = sheet.createRow(4);
        HSSFCell cell13 = row3.createCell(0);
        cell13.setCellStyle(cellStyle);
        cell13.setCellValue("检查项目");
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 4, 5));
        HSSFCell cell14 = row3.createCell(1);
        cell14.setCellStyle(cellStyle);
        cell14.setCellValue("缺损类型");
        row3.createCell(2).setCellStyle(cellStyle);
        HSSFCell cell15 = row3.createCell(3);
        cell15.setCellStyle(cellStyle);
        cell15.setCellValue("缺损范围");
        HSSFCell cell16 = row3.createCell(4);
        cell16.setCellStyle(cellStyle);
        cell16.setCellValue("处治建议");
        row3.createCell(5).setCellStyle(cellStyle);
        row0.setHeight((short) (32 * 20));
        row.setHeight((short) (25 * 20));
        row1.setHeight((short) (25 * 20));
        row2.setHeight((short) (25 * 20));
        row3.setHeight((short) (25 * 20));
        List<SysDictionaryDetail> list = qljcmxb.get("qljcmxb");
        for (int i = 0; i < list.size(); i++) {
            HSSFRow row4 = sheet.createRow(5 + i);
            SysDictionaryDetail detail = null;
            try {
                Map map = (Map) list.get(i);
                detail = BeanUtil.toBean(map, SysDictionaryDetail.class);
            } catch (Exception e) {
                detail = list.get(i);
            }
            HSSFCell cell17 = row4.createCell(0);
            row4.setHeight((short) (21 * 20));
            cell17.setCellStyle(cellStyle);
            cell17.setCellValue(detail.getName());
            sheet.addMergedRegion(new CellRangeAddress(5 + i, 5 + i, 1, 2));
            sheet.addMergedRegion(new CellRangeAddress(5 + i, 5 + i, 4, 5));
            row4.createCell(1).setCellStyle(cellStyle);
            row4.createCell(2).setCellStyle(cellStyle);
            row4.createCell(3).setCellStyle(cellStyle);
            row4.createCell(4).setCellStyle(cellStyle);
            row4.createCell(5).setCellStyle(cellStyle);
        }
        HSSFRow row4 = sheet.createRow(5 + list.size());
        HSSFCell cell17 = row4.createCell(0);
        cell17.setCellStyle(cellStyle);
        cell17.setCellValue("负责人");
        HSSFCell cell18 = row4.createCell(2);
        cell18.setCellStyle(cellStyle);
        cell18.setCellValue("记录人");
        HSSFCell cell19 = row4.createCell(4);
        cell19.setCellStyle(cellStyle);
        cell19.setCellValue("检查日期");
        row4.createCell(1).setCellStyle(cellStyle);
        row4.createCell(3).setCellStyle(cellStyle);
        row4.createCell(5).setCellStyle(cellStyle);

        try {
            OutputStream os = new FileOutputStream(file + "/" + bridge.getName() + "-" + bridge.getNumber() + "-" + bridge.getDirectionValue() + System.currentTimeMillis() + ".xls");
            workbook.write(os);
            os.flush();
            os.close();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }

    //斜拉Data
    private void exportBriCableStayedData(File file, BridgeInformation bridge, Road road, BridgeOftenCheck bridgeOftenCheck, HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFCellStyle cellStyleTitle, HSSFSheet sheet) {
        sheet.setColumnWidth(0, 20 * 256);
        sheet.setColumnWidth(1, 10 * 256);
        sheet.setColumnWidth(2, 10 * 256);
        sheet.setColumnWidth(3, 25 * 256);
        sheet.setColumnWidth(4, 9 * 256);
        sheet.setColumnWidth(5, 10 * 256);
        List<BridgeOftenCheckDetail> list = bridgeOftenCheckDetailManager.list(new QueryWrapper<BridgeOftenCheckDetail>().lambda().eq(BridgeOftenCheckDetail::getBridgeOftenCheckId, bridgeOftenCheck.getId()));
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 5));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 5));
        HSSFRow row0 = sheet.createRow(0);
        HSSFCell cell24 = row0.createCell(0);
        cell24.setCellValue(" 桥梁经常检查记录表");
        cell24.setCellStyle(cellStyleTitle);
        setExcelStyleTitle(cellStyleTitle, workbook);
        HSSFRow row = sheet.createRow(1);
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle(cellStyle);
        HSSFCell cell23 = row.createCell(1);
        cell23.setCellStyle(cellStyle);
        cell23.setCellValue(getCompany(bridge.getOfficeName()));
        row.createCell(2).setCellStyle(cellStyle);
        row.createCell(3).setCellStyle(cellStyle);
        row.createCell(4).setCellStyle(cellStyle);
        row.createCell(5).setCellStyle(cellStyle);
        cell.setCellValue("管理单位");
        HSSFRow row1 = sheet.createRow(2);
        HSSFCell cell1 = row1.createCell(0);
        cell1.setCellStyle(cellStyle);
        cell1.setCellValue("路线编号");
        HSSFCell cell2 = row1.createCell(1);
        cell2.setCellStyle(cellStyle);
        cell2.setCellValue(road.getCode());
        HSSFCell cell3 = row1.createCell(2);
        cell3.setCellStyle(cellStyle);
        cell3.setCellValue("路线名称");
        HSSFCell cell4 = row1.createCell(3);
        cell4.setCellStyle(cellStyle);
        cell4.setCellValue(road.getName());
        HSSFCell cell5 = row1.createCell(4);
        cell5.setCellStyle(cellStyle);
        cell5.setCellValue("桥位桩号");
        HSSFCell cell6 = row1.createCell(5);
        cell6.setCellStyle(cellStyle);
        cell6.setCellValue(bridge.getCentPeg());
        HSSFRow row2 = sheet.createRow(3);
        HSSFCell cell7 = row2.createCell(0);
        cell7.setCellStyle(cellStyle);
        cell7.setCellValue("桥梁编号");
        HSSFCell cell8 = row2.createCell(1);
        cell8.setCellStyle(cellStyle);
        cell8.setCellValue(bridge.getNumber());
        HSSFCell cell9 = row2.createCell(2);
        cell9.setCellStyle(cellStyle);
        cell9.setCellValue("桥梁名称");
        HSSFCell cell10 = row2.createCell(3);
        cell10.setCellStyle(cellStyle);
        cell10.setCellValue(bridge.getName());
        HSSFCell cell11 = row2.createCell(4);
        cell11.setCellStyle(cellStyle);
        cell11.setCellValue("养护单位");
        HSSFCell cell12 = row2.createCell(5);
        cell12.setCellStyle(cellStyle);
        cell12.setCellValue(bridge.getOfficeName());
        HSSFRow row3 = sheet.createRow(4);
        HSSFCell cell13 = row3.createCell(0);
        cell13.setCellStyle(cellStyle);
        cell13.setCellValue("检查项目");
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 4, 5));
        HSSFCell cell14 = row3.createCell(1);
        cell14.setCellStyle(cellStyle);
        cell14.setCellValue("缺损类型");
        row3.createCell(2).setCellStyle(cellStyle);
        HSSFCell cell15 = row3.createCell(3);
        cell15.setCellStyle(cellStyle);
        cell15.setCellValue("缺损范围");
        HSSFCell cell16 = row3.createCell(4);
        cell16.setCellStyle(cellStyle);
        cell16.setCellValue("处治建议");
        row3.createCell(5).setCellStyle(cellStyle);
        row0.setHeight((short) (32 * 20));
        row.setHeight((short) (25 * 20));
        row1.setHeight((short) (25 * 20));
        row2.setHeight((short) (25 * 20));
        row3.setHeight((short) (25 * 20));

        for (int i = 0; i < list.size(); i++) {
            HSSFRow row4 = sheet.createRow(5 + i);
            row4.setHeight((short) (21 * 20));
            BridgeOftenCheckDetail bridgeOftenCheckDetail = list.get(i);
            HSSFCell cell17 = row4.createCell(0);
            cell17.setCellStyle(cellStyle);
            cell17.setCellValue(bridgeOftenCheckDetail.getName());
            sheet.addMergedRegion(new CellRangeAddress(5 + i, 5 + i, 1, 2));
            sheet.addMergedRegion(new CellRangeAddress(5 + i, 5 + i, 4, 5));
            HSSFCell cell18 = row4.createCell(1);
            cell18.setCellStyle(cellStyle);
            cell18.setCellValue(bridgeOftenCheckDetail.getDefectType());
            HSSFCell cell19 = row4.createCell(3);
            cell19.setCellStyle(cellStyle);
            cell19.setCellValue(bridgeOftenCheckDetail.getDefectScope());
            HSSFCell cell20 = row4.createCell(4);
            cell20.setCellStyle(cellStyle);
            cell20.setCellValue(bridgeOftenCheckDetail.getProcessMode());
            row4.createCell(2).setCellStyle(cellStyle);
            row4.createCell(5).setCellStyle(cellStyle);
        }
        HSSFRow row4 = sheet.createRow(5 + list.size());
        HSSFCell cell17 = row4.createCell(0);
        cell17.setCellStyle(cellStyle);
        cell17.setCellValue("负责人");
        HSSFCell cell18 = row4.createCell(1);
        cell18.setCellStyle(cellStyle);
        cell18.setCellValue(bridgeOftenCheck.getRummager());
        HSSFCell cell22 = row4.createCell(2);
        cell22.setCellStyle(cellStyle);
        cell22.setCellValue("记录人");
        HSSFCell cell19 = row4.createCell(3);
        cell19.setCellStyle(cellStyle);
        cell19.setCellValue(bridgeOftenCheck.getNoteTaker());
        HSSFCell cell20 = row4.createCell(4);
        cell20.setCellStyle(cellStyle);
        cell20.setCellValue("检查日期");
        HSSFCell cell21 = row4.createCell(5);
        cell21.setCellStyle(cellStyle);
        String dateStr = new SimpleDateFormat("yyyy/MM/dd").format(bridgeOftenCheck.getCheckDate());
        cell21.setCellValue(dateStr);
        try {
            OutputStream os = new FileOutputStream(file + "/" + bridge.getName() + "-" + bridge.getNumber() + "-" + bridge.getDirectionValue() +"-"+new SimpleDateFormat("yyyy-MM-dd").format(bridgeOftenCheck.getCheckDate()) + ".xls");
            workbook.write(os);
            os.flush();
            os.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportTunnelOften(String ids, HttpServletResponse response) {
        try {
            long time = System.currentTimeMillis();
            String fileName = "隧道经常检查记录表" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            List<String> strings = Arrays.asList(ids.split(","));
            Map<String, List<SysDictionaryDetail>> qljcmxb = sysDictionaryManager.queryDictItemsByCode("sdsdjcjc");
            strings.forEach(s -> {
                TunnelInformation tunnel = tunnelInformationManager.getTunnelById(s);
                //根据隧道信息查询路段
                Road road = roadManager.getById(tunnel.getRoadSegmentId());
                //查询该隧道最近的一次检查记录
                QueryWrapper<TunnelOftenCheck> queryWrapper = new QueryWrapper<TunnelOftenCheck>();
                //查询最新一次的检查信息
                TunnelOftenCheck tunnelOftenCheck = tunnelOftenCheckManager.getBaseMapper().selectOne(queryWrapper.eq("TUNNEL_ID_", s).orderByDesc("CHECK_DATE_").orderByDesc("CREATE_TIME_").last("limit 0,1"));
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                setExcelStyle(cellStyle, workbook);
                HSSFCellStyle cellStyleTitle = workbook.createCellStyle();

                HSSFSheet sheet = workbook.createSheet("隧道经常检查记录表");
                sheet.getPrintSetup().setPaperSize(HSSFPrintSetup.A4_PAPERSIZE);
                sheet.setColumnWidth(0, 10 * 256);
                sheet.setColumnWidth(1, 10 * 256);
                sheet.setColumnWidth(2, 30 * 256);
                sheet.setColumnWidth(3, 8 * 256);
                sheet.setColumnWidth(4, 6 * 256);
                sheet.setColumnWidth(5, 5 * 256);
                sheet.setColumnWidth(6, 5 * 256);
                sheet.setColumnWidth(7, 5 * 256);
                if (tunnelOftenCheck != null) {
                    exportTunnelData(tunnel, road, tunnelOftenCheck, workbook, cellStyle, cellStyleTitle, sheet);

                } else {
                    exportTunnel(qljcmxb, tunnel, road, workbook, cellStyle, cellStyleTitle, sheet);
                }
                try {
                    OutputStream os = new FileOutputStream(file + "/" + tunnel.getName() + "-" + tunnel.getNumber() + "-" + tunnel.getDirectionValue() + System.currentTimeMillis() + ".xls");
                    workbook.write(os);
                    os.flush();
                    os.close();
                } catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("导出列表失败！");
                }
            });
            this.zip(fileName, true);
            String zip = fileName + ".zip";

            HttpUtil.downLoadFile(response, zip, zip);
            // 删除导出的文件
            FileUtil.deleteFile(zip);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }

    private void exportTunnel(Map<String, List<SysDictionaryDetail>> qljcmxb, TunnelInformation tunnel, Road road, HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFCellStyle cellStyleTitle, HSSFSheet sheet) {
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 7));
        HSSFRow row0 = sheet.createRow(0);
        HSSFCell cell0 = row0.createCell(0);
        cell0.setCellValue("隧道经常检查记录表");
        cell0.setCellStyle(cellStyleTitle);
        setExcelStyleTitle(cellStyleTitle, workbook);
        HSSFRow row = sheet.createRow(1);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("隧道名称");
        cell.setCellStyle(cellStyle);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 2));
        HSSFCell cell1 = row.createCell(1);
        cell1.setCellStyle(cellStyle);
        cell1.setCellValue(tunnel.getName() + "(" + tunnel.getDirectionValue() + ")");
        HSSFCell cell2 = row.createCell(3);
        cell2.setCellStyle(cellStyle);
        cell2.setCellValue("路线名称");
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 4, 7));
        HSSFCell cell3 = row.createCell(4);
        cell3.setCellStyle(cellStyle);
        cell3.setCellValue(road.getName());
        row.createCell(2).setCellStyle(cellStyle);
        row.createCell(5).setCellStyle(cellStyle);
        row.createCell(6).setCellStyle(cellStyle);
        row.createCell(7).setCellStyle(cellStyle);
        HSSFRow row1 = sheet.createRow(2);
        HSSFCell cell4 = row1.createCell(0);
        cell4.setCellStyle(cellStyle);
        cell4.setCellValue("隧道编码");
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 1, 2));
        HSSFCell cell5 = row1.createCell(1);
        cell5.setCellStyle(cellStyle);
        cell5.setCellValue(tunnel.getNumber());
        HSSFCell cell6 = row1.createCell(3);
        cell6.setCellStyle(cellStyle);
        cell6.setCellValue("路线编码");
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 4, 7));
        HSSFCell cell7 = row1.createCell(4);
        cell7.setCellStyle(cellStyle);
        cell7.setCellValue(road.getCode());
        row1.createCell(2).setCellStyle(cellStyle);
        row1.createCell(5).setCellStyle(cellStyle);
        row1.createCell(6).setCellStyle(cellStyle);
        row1.createCell(7).setCellStyle(cellStyle);
        HSSFRow row2 = sheet.createRow(3);
        HSSFCell cell8 = row2.createCell(0);
        cell8.setCellStyle(cellStyle);
        cell8.setCellValue("养护机构");
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 1, 2));
        HSSFCell cell9 = row2.createCell(1);
        cell9.setCellStyle(cellStyle);
        cell9.setCellValue(tunnel.getOfficeName());
        HSSFCell cell10 = row2.createCell(3);
        cell10.setCellStyle(cellStyle);
        cell10.setCellValue("检查日期");
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 4, 5));
        HSSFCell cell11 = row2.createCell(4);
        cell11.setCellStyle(cellStyle);

        HSSFCell cell12 = row2.createCell(6);
        cell12.setCellStyle(cellStyle);
        cell12.setCellValue("天气");
        HSSFCell cell13 = row2.createCell(7);
        cell13.setCellStyle(cellStyle);

        row2.createCell(2).setCellStyle(cellStyle);
        row2.createCell(5).setCellStyle(cellStyle);
        HSSFRow row3 = sheet.createRow(4);
        HSSFCell cell14 = row3.createCell(0);
        cell14.setCellValue("总体评价");
        cell14.setCellStyle(cellStyle);
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 1, 7));
        HSSFCell cell15 = row3.createCell(2);
        cell15.setCellStyle(cellStyle);

        row3.createCell(1).setCellStyle(cellStyle);
        row3.createCell(3).setCellStyle(cellStyle);
        row3.createCell(4).setCellStyle(cellStyle);
        row3.createCell(5).setCellStyle(cellStyle);
        row3.createCell(6).setCellStyle(cellStyle);
        row3.createCell(7).setCellStyle(cellStyle);
        HSSFRow row4 = sheet.createRow(5);
        sheet.addMergedRegion(new CellRangeAddress(5, 6, 0, 0));
        sheet.addMergedRegion(new CellRangeAddress(5, 6, 1, 1));
        sheet.addMergedRegion(new CellRangeAddress(5, 6, 2, 2));
        sheet.addMergedRegion(new CellRangeAddress(5, 6, 3, 4));
        sheet.addMergedRegion(new CellRangeAddress(5, 5, 5, 7));
        HSSFCell cell16 = row4.createCell(0);
        cell16.setCellStyle(cellStyle);
        cell16.setCellValue("里程桩号/异常位置");
        HSSFCell cell17 = row4.createCell(1);
        cell17.setCellStyle(cellStyle);
        cell17.setCellValue("结构名称");
        HSSFCell cell18 = row4.createCell(2);
        cell18.setCellStyle(cellStyle);
        cell18.setCellValue("检查内容");
        HSSFCell cell19 = row4.createCell(3);
        cell19.setCellStyle(cellStyle);
        cell19.setCellValue("异常描述(性质、范围、程度等)");
        HSSFCell cell20 = row4.createCell(5);
        cell20.setCellStyle(cellStyle);
        cell20.setCellValue("判断");
        row4.createCell(6).setCellStyle(cellStyle);
        row4.createCell(7).setCellStyle(cellStyle);
        HSSFRow row5 = sheet.createRow(6);
        HSSFCell cell21 = row5.createCell(5);
        cell21.setCellStyle(cellStyle);
        cell21.setCellValue("情况正常");
        HSSFCell cell22 = row5.createCell(6);
        cell22.setCellStyle(cellStyle);
        cell22.setCellValue("一般异常");
        HSSFCell cell23 = row5.createCell(7);
        cell23.setCellStyle(cellStyle);
        cell23.setCellValue("严重异常");
        row5.createCell(0).setCellStyle(cellStyle);
        row5.createCell(1).setCellStyle(cellStyle);
        row5.createCell(2).setCellStyle(cellStyle);
        row5.createCell(3).setCellStyle(cellStyle);
        row5.createCell(4).setCellStyle(cellStyle);
        row0.setHeight((short) (32 * 20));
        row.setHeight((short) (29 * 20));
        row1.setHeight((short) (29 * 20));
        row2.setHeight((short) (29 * 20));
        row3.setHeight((short) (29 * 20));
        row4.setHeight((short) (29 * 20));
        row5.setHeight((short) (29 * 20));
        List<SysDictionaryDetail> list = qljcmxb.get("sdsdjcjc");
        for (int i = 0; i < list.size(); i++) {
            Map map = (Map) list.get(i);
            SysDictionaryDetail detail = BeanUtil.toBean(map, SysDictionaryDetail.class);
            HSSFRow row6 = sheet.createRow(7 + i);
            HSSFCell cell24 = row6.createCell(0);
            cell24.setCellStyle(cellStyle);
            HSSFCell cell25 = row6.createCell(1);
            cell25.setCellStyle(cellStyle);
            cell25.setCellValue(detail.getName());
            HSSFCell cell26 = row6.createCell(2);
            cell26.setCellStyle(cellStyle);
            cell26.setCellValue(detail.getValue());
            sheet.addMergedRegion(new CellRangeAddress(7 + i, 7 + i, 3, 4));
            HSSFCell cell27 = row6.createCell(3);
            cell27.setCellStyle(cellStyle);
            row6.setHeight((short) (60 * 20));
            row6.createCell(4).setCellStyle(cellStyle);
            row6.createCell(5).setCellStyle(cellStyle);
            row6.createCell(6).setCellStyle(cellStyle);
            row6.createCell(7).setCellStyle(cellStyle);
        }
        HSSFRow row7 = sheet.createRow(7 + list.size());
        HSSFCell hssfCell = row7.createCell(0);
        hssfCell.setCellStyle(cellStyle);
        hssfCell.setCellValue("负责人");
        sheet.addMergedRegion(new CellRangeAddress(7 + list.size(), 7 + list.size(), 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(7 + list.size(), 7 + list.size(), 4, 7));
        HSSFCell hssfCell2 = row7.createCell(1);
        hssfCell2.setCellStyle(cellStyle);
        HSSFCell hssfCell3 = row7.createCell(3);
        hssfCell3.setCellStyle(cellStyle);
        hssfCell3.setCellValue("记录人");
        HSSFCell hssfCell4 = row7.createCell(4);
        hssfCell4.setCellStyle(cellStyle);
        row7.setHeight((short) (22 * 20));
        row7.createCell(2).setCellStyle(cellStyle);
        row7.createCell(5).setCellStyle(cellStyle);
        row7.createCell(6).setCellStyle(cellStyle);
        row7.createCell(7).setCellStyle(cellStyle);
    }

    private void exportTunnelData(TunnelInformation tunnel, Road road, TunnelOftenCheck tunnelOftenCheck, HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFCellStyle cellStyleTitle, HSSFSheet sheet) {
        List<TunnelOftenCheckDetail> list = tunnelOftenCheckDetailManager.list(new QueryWrapper<TunnelOftenCheckDetail>().lambda().eq(TunnelOftenCheckDetail::getTunnelOftenCheckId, tunnelOftenCheck.getId()));
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 7));
        HSSFRow row0 = sheet.createRow(0);
        HSSFCell cell0 = row0.createCell(0);
        cell0.setCellValue("隧道经常检查记录表");
        cell0.setCellStyle(cellStyleTitle);
        setExcelStyleTitle(cellStyleTitle, workbook);
        HSSFRow row = sheet.createRow(1);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("隧道名称");
        cell.setCellStyle(cellStyle);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 2));
        HSSFCell cell1 = row.createCell(1);
        cell1.setCellStyle(cellStyle);
        cell1.setCellValue(tunnel.getName() + "(" + tunnel.getDirectionValue() + ")");
        HSSFCell cell2 = row.createCell(3);
        cell2.setCellStyle(cellStyle);
        cell2.setCellValue("路线名称");
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 4, 7));
        HSSFCell cell3 = row.createCell(4);
        cell3.setCellStyle(cellStyle);
        cell3.setCellValue(road.getName());
        row.createCell(2).setCellStyle(cellStyle);
        row.createCell(5).setCellStyle(cellStyle);
        row.createCell(6).setCellStyle(cellStyle);
        row.createCell(7).setCellStyle(cellStyle);
        HSSFRow row1 = sheet.createRow(2);
        HSSFCell cell4 = row1.createCell(0);
        cell4.setCellStyle(cellStyle);
        cell4.setCellValue("隧道编码");
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 1, 2));
        HSSFCell cell5 = row1.createCell(1);
        cell5.setCellStyle(cellStyle);
        cell5.setCellValue(tunnel.getNumber());
        HSSFCell cell6 = row1.createCell(3);
        cell6.setCellStyle(cellStyle);
        cell6.setCellValue("路线编码");
        sheet.addMergedRegion(new CellRangeAddress(2, 2, 4, 7));
        HSSFCell cell7 = row1.createCell(4);
        cell7.setCellStyle(cellStyle);
        cell7.setCellValue(road.getCode());
        row1.createCell(2).setCellStyle(cellStyle);
        row1.createCell(5).setCellStyle(cellStyle);
        row1.createCell(6).setCellStyle(cellStyle);
        row1.createCell(7).setCellStyle(cellStyle);
        HSSFRow row2 = sheet.createRow(3);
        HSSFCell cell8 = row2.createCell(0);
        cell8.setCellStyle(cellStyle);
        cell8.setCellValue("养护机构");
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 1, 2));
        HSSFCell cell9 = row2.createCell(1);
        cell9.setCellStyle(cellStyle);
        cell9.setCellValue(tunnel.getOfficeName());
        HSSFCell cell10 = row2.createCell(3);
        cell10.setCellStyle(cellStyle);
        cell10.setCellValue("检查日期");
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 4, 5));
        HSSFCell cell11 = row2.createCell(4);
        cell11.setCellStyle(cellStyle);
        cell11.setCellValue(new SimpleDateFormat("yyyy/MM/dd").format(tunnelOftenCheck.getCheckDate()));
        HSSFCell cell12 = row2.createCell(6);
        cell12.setCellStyle(cellStyle);
        cell12.setCellValue("天气");
        HSSFCell cell13 = row2.createCell(7);
        cell13.setCellStyle(cellStyle);
        cell13.setCellValue(tunnelOftenCheck.getWeatherValue());
        row2.createCell(2).setCellStyle(cellStyle);
        row2.createCell(5).setCellStyle(cellStyle);
        HSSFRow row3 = sheet.createRow(4);
        HSSFCell cell14 = row3.createCell(0);
        cell14.setCellValue("总体评价");
        cell14.setCellStyle(cellStyle);
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 1, 7));
        HSSFCell cell15 = row3.createCell(1);
        cell15.setCellStyle(cellStyle);
        cell15.setCellValue(tunnelOftenCheck.getEvaluateValue());
        row3.createCell(2).setCellStyle(cellStyle);
        row3.createCell(3).setCellStyle(cellStyle);
        row3.createCell(4).setCellStyle(cellStyle);
        row3.createCell(5).setCellStyle(cellStyle);
        row3.createCell(6).setCellStyle(cellStyle);
        row3.createCell(7).setCellStyle(cellStyle);
        HSSFRow row4 = sheet.createRow(5);
        sheet.addMergedRegion(new CellRangeAddress(5, 6, 0, 0));
        sheet.addMergedRegion(new CellRangeAddress(5, 6, 1, 1));
        sheet.addMergedRegion(new CellRangeAddress(5, 6, 2, 2));
        sheet.addMergedRegion(new CellRangeAddress(5, 6, 3, 4));
        sheet.addMergedRegion(new CellRangeAddress(5, 5, 5, 7));
        HSSFCell cell16 = row4.createCell(0);
        cell16.setCellStyle(cellStyle);
        cell16.setCellValue("里程桩号/异常位置");
        HSSFCell cell17 = row4.createCell(1);
        cell17.setCellStyle(cellStyle);
        cell17.setCellValue("结构名称");
        HSSFCell cell18 = row4.createCell(2);
        cell18.setCellStyle(cellStyle);
        cell18.setCellValue("检查内容");
        HSSFCell cell19 = row4.createCell(3);
        cell19.setCellStyle(cellStyle);
        cell19.setCellValue("异常描述(性质、范围、程度等)");
        HSSFCell cell20 = row4.createCell(5);
        cell20.setCellStyle(cellStyle);
        cell20.setCellValue("判断");
        row4.createCell(6).setCellStyle(cellStyle);
        row4.createCell(7).setCellStyle(cellStyle);
        HSSFRow row5 = sheet.createRow(6);
        HSSFCell cell21 = row5.createCell(5);
        cell21.setCellStyle(cellStyle);
        cell21.setCellValue("情况正常");
        HSSFCell cell22 = row5.createCell(6);
        cell22.setCellStyle(cellStyle);
        cell22.setCellValue("一般异常");
        HSSFCell cell23 = row5.createCell(7);
        cell23.setCellStyle(cellStyle);
        cell23.setCellValue("严重异常");
        row5.createCell(0).setCellStyle(cellStyle);
        row5.createCell(1).setCellStyle(cellStyle);
        row5.createCell(2).setCellStyle(cellStyle);
        row5.createCell(3).setCellStyle(cellStyle);
        row5.createCell(4).setCellStyle(cellStyle);
        row0.setHeight((short) (32 * 20));
        row.setHeight((short) (29 * 20));
        row1.setHeight((short) (29 * 20));
        row2.setHeight((short) (29 * 20));
        row3.setHeight((short) (29 * 20));
        row4.setHeight((short) (29 * 20));
        row5.setHeight((short) (29 * 20));
        for (int i = 0; i < list.size(); i++) {
            HSSFRow row6 = sheet.createRow(7 + i);
            row6.setHeight((short) (60 * 20));
            HSSFCell cell24 = row6.createCell(0);
            TunnelOftenCheckDetail tunnelOftenCheckDetail = list.get(i);
            cell24.setCellValue(tunnelOftenCheckDetail.getMileagePilenum());
            cell24.setCellStyle(cellStyle);
            HSSFCell cell25 = row6.createCell(1);
            cell25.setCellStyle(cellStyle);
            cell25.setCellValue(tunnelOftenCheckDetail.getUnitName());
            HSSFCell cell26 = row6.createCell(2);
            cell26.setCellStyle(cellStyle);
            cell26.setCellValue(tunnelOftenCheckDetail.getCheckContent());
            sheet.addMergedRegion(new CellRangeAddress(7 + i, 7 + i, 3, 4));
            HSSFCell cell27 = row6.createCell(3);
            cell27.setCellStyle(cellStyle);
            cell27.setCellValue(tunnelOftenCheckDetail.getStatusDesc());
            if ("情况正常".equals(tunnelOftenCheckDetail.getFlag()) || "1".equals(tunnelOftenCheckDetail.getFlag())) {
                HSSFCell cell28 = row6.createCell(5);
                cell28.setCellValue("√");
                cell28.setCellStyle(cellStyle);
                row6.createCell(6).setCellStyle(cellStyle);
                row6.createCell(7).setCellStyle(cellStyle);
            } else if ("一般异常".equals(tunnelOftenCheckDetail.getFlag()) || "2".equals(tunnelOftenCheckDetail.getFlag())) {
                HSSFCell cell28 = row6.createCell(6);
                cell28.setCellValue("√");
                cell28.setCellStyle(cellStyle);
                row6.createCell(5).setCellStyle(cellStyle);
                row6.createCell(7).setCellStyle(cellStyle);
            } else if ("严重异常".equals(tunnelOftenCheckDetail.getFlag()) || "3".equals(tunnelOftenCheckDetail.getFlag())) {
                HSSFCell cell28 = row6.createCell(7);
                cell28.setCellValue("√");
                cell28.setCellStyle(cellStyle);
                row6.createCell(5).setCellStyle(cellStyle);
                row6.createCell(6).setCellStyle(cellStyle);
            } else {
                HSSFCell cell28 = row6.createCell(5);
//                            cell28.setCellValue("√");
                cell28.setCellStyle(cellStyle);
                row6.createCell(6).setCellStyle(cellStyle);
                row6.createCell(7).setCellStyle(cellStyle);
            }
            row6.createCell(4).setCellStyle(cellStyle);
        }
        HSSFRow row7 = sheet.createRow(7 + list.size());
        HSSFCell hssfCell = row7.createCell(0);
        hssfCell.setCellStyle(cellStyle);
        hssfCell.setCellValue("负责人");
        sheet.addMergedRegion(new CellRangeAddress(7 + list.size(), 7 + list.size(), 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(7 + list.size(), 7 + list.size(), 4, 7));
        HSSFCell hssfCell2 = row7.createCell(1);
        hssfCell2.setCellStyle(cellStyle);
        hssfCell2.setCellValue(tunnelOftenCheck.getRummager());
        HSSFCell hssfCell3 = row7.createCell(3);
        hssfCell3.setCellStyle(cellStyle);
        hssfCell3.setCellValue("记录人");
        HSSFCell hssfCell4 = row7.createCell(4);
        hssfCell4.setCellStyle(cellStyle);
        hssfCell4.setCellValue(tunnelOftenCheck.getNoteTaker());
        row7.createCell(2).setCellStyle(cellStyle);
        row7.createCell(5).setCellStyle(cellStyle);
        row7.createCell(6).setCellStyle(cellStyle);
        row7.createCell(7).setCellStyle(cellStyle);
        row7.setHeight((short) (22 * 20));
    }

    @Override
    public void exportCulvertOften(String ids, HttpServletResponse response) {
        try {
            long time = System.currentTimeMillis();
            String fileName = "涵洞经常检查记录表" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            //查询涵洞经常检查字典
            Map<String, List<SysDictionaryDetail>> hdjcjcmx = sysDictionaryManager.queryDictItemsByCode("hdjcjcmx");
            List<String> strings = Arrays.asList(ids.split(","));

            List<List<String>> collect = IntStream.range(0, (strings.size() + 3 - 1) / 3)
                    .map(pageNum -> pageNum * 3).parallel()
                    .mapToObj(i -> strings.stream().skip(i).limit(3).collect(Collectors.toList()))
                    .collect(Collectors.toList());
            for (List<String> stringList : collect) {
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                setExcelStyle(cellStyle, workbook);
                HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
                setExcelStyle(cellStyle, workbook);
                HSSFSheet sheet = workbook.createSheet("涵洞经常检查记录表");
                sheet.getPrintSetup().setPaperSize(HSSFPrintSetup.A4_PAPERSIZE);
                sheet.setColumnWidth(0, 10 * 256);
                sheet.setColumnWidth(1, 10 * 256);
                sheet.setColumnWidth(2, 10 * 256);
                sheet.setColumnWidth(3, 8 * 256);
                sheet.setColumnWidth(4, 6 * 256);
                sheet.setColumnWidth(5, 4 * 256);
                sheet.setColumnWidth(6, 8 * 256);
                sheet.setColumnWidth(7, 8 * 256);
                sheet.setColumnWidth(8, 8 * 256);
                sheet.setColumnWidth(9, 8 * 256);
                int rowIndex = 1;
                for (String s : stringList) {
                    //查询涵洞信息
                    BizCulvertInformation culvert = culvertInformationManager.getById(s);
                    //根据桥梁信息查询路段
                    Road road = roadManager.getById(culvert.getRoadSegmentId());

                    HSSFRow row0 = sheet.createRow(0);
                    HSSFCell cell24 = row0.createCell(0);
                    cell24.setCellValue("涵洞经常检查记录表");
                    cell24.setCellStyle(cellStyleTitle);
                    setExcelStyleTitle(cellStyleTitle, workbook);

                    HSSFRow row1 = sheet.createRow(1);
                    HSSFCell cell = row1.createCell(0);
                    cell.setCellStyle(cellStyle);
                    cell.setCellValue("路线名称:");

                    HSSFCell cell1 = row1.createCell(1);
                    cell1.setCellStyle(cellStyle);
                    cell1.setCellValue(road.getName());
                    HSSFCell cell2 = row1.createCell(6);
                    cell2.setCellStyle(cellStyle);
                    cell2.setCellValue("路线编码:");
                    HSSFCell cell3 = row1.createCell(7);
                    row1.createCell(2).setCellStyle(cellStyle);
                    row1.createCell(3).setCellStyle(cellStyle);
                    row1.createCell(4).setCellStyle(cellStyle);
                    row1.createCell(5).setCellStyle(cellStyle);
                    row1.createCell(8).setCellStyle(cellStyle);
                    row1.createCell(9).setCellStyle(cellStyle);
                    cell3.setCellStyle(cellStyle);

                    cell3.setCellValue(road.getCode());
                    if (rowIndex == 1) {
                        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 4));
                        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 9));
                        sheet.addMergedRegion(new CellRangeAddress(1, 1, 7, 9));
                    }
                    QueryWrapper<CulvertOftenCheck> queryWrapper = new QueryWrapper<CulvertOftenCheck>();
                    //查询最新一次的检查信息
                    CulvertOftenCheck culvertOftenCheck = culvertOftenCheckManager.getBaseMapper().selectOne(queryWrapper.eq("CULVERT_ID_", s).orderByDesc("CHECK_DATE_").orderByDesc("CREATE_TIME_").last("limit 0,1"));
                    if (culvertOftenCheck != null) {
                        List<CulvertOftenCheckDetail> list = culvertOftenCheckDetailManager.list(new QueryWrapper<CulvertOftenCheckDetail>().lambda().eq(CulvertOftenCheckDetail::getCulvertOftenCheckId, culvertOftenCheck.getId()));

                        HSSFRow row2 = sheet.createRow(++rowIndex);
                        HSSFCell cell4 = row2.createCell(0);
                        cell4.setCellStyle(cellStyle);
                        cell4.setCellValue("涵洞桩号");
                        HSSFCell cell5 = row2.createCell(1);
                        cell5.setCellStyle(cellStyle);
                        cell5.setCellValue("涵洞类型");
                        HSSFCell cell6 = row2.createCell(2);
                        cell6.setCellStyle(cellStyle);
                        cell6.setCellValue("检查日期");
                        HSSFCell cell7 = row2.createCell(3);
                        cell7.setCellStyle(cellStyle);
                        cell7.setCellValue("检查人");
                        HSSFCell cell8 = row2.createCell(4);
                        cell8.setCellStyle(cellStyle);
                        cell8.setCellValue("记录人");
                        HSSFCell cell9 = row2.createCell(5);
                        cell9.setCellStyle(cellStyle);
                        cell9.setCellValue("总体评价");
                        HSSFCell cell10 = row2.createCell(6);
                        cell10.setCellStyle(cellStyle);
                        cell10.setCellValue("检查内容");
                        HSSFCell cell11 = row2.createCell(7);
                        cell11.setCellStyle(cellStyle);
                        cell11.setCellValue("状态描述");
                        HSSFCell cell12 = row2.createCell(8);
                        cell12.setCellStyle(cellStyle);
                        cell12.setCellValue("判断结论");
                        HSSFCell cell13 = row2.createCell(9);
                        cell13.setCellStyle(cellStyle);
                        cell13.setCellValue("处理措施");
                        row0.setHeight((short) (25 * 20));
                        row1.setHeight((short) (20 * 20));
                        row2.setHeight((short) (20 * 20));
                        Integer rowIndexFor = rowIndex + 1;
                        for (int i = 0; i < list.size(); i++) {
                            HSSFRow row4 = sheet.createRow(rowIndexFor + i);
                            CulvertOftenCheckDetail culvertOftenCheckDetail = list.get(i);
                            HSSFCell cell14 = row4.createCell(6);
                            cell14.setCellStyle(cellStyle);
                            cell14.setCellValue(culvertOftenCheckDetail.getCheckProject());
                            HSSFCell cell15 = row4.createCell(7);
                            cell15.setCellStyle(cellStyle);
                            cell15.setCellValue(culvertOftenCheckDetail.getStatusDesc());
                            HSSFCell cell16 = row4.createCell(8);
                            cell16.setCellStyle(cellStyle);
                            cell16.setCellValue(culvertOftenCheckDetail.getResult());
                            HSSFCell cell17 = row4.createCell(9);
                            cell17.setCellStyle(cellStyle);
                            cell17.setCellValue(culvertOftenCheckDetail.getProcess());
                            row4.setHeight((short) (15 * 20));
                            if (i == 0) {
                                rowIndex++;

                                HSSFCell cell18 = row4.createCell(0);
                                cell18.setCellValue(culvert.getCentPeg() + "(" + culvert.getDirectionValue() + ")");
                                cell18.setCellStyle(cellStyle);
                                HSSFCell cell19 = row4.createCell(1);
                                cell19.setCellValue(culvert.getTypeValue());
                                cell19.setCellStyle(cellStyle);
                                HSSFCell cell20 = row4.createCell(2);
                                cell20.setCellValue(new SimpleDateFormat("yyyy/MM/dd").format(culvertOftenCheck.getCheckDate()));
                                cell20.setCellStyle(cellStyle);
                                HSSFCell cell21 = row4.createCell(3);
                                cell21.setCellValue(culvertOftenCheck.getRummager());
                                cell21.setCellStyle(cellStyle);
                                HSSFCell cell22 = row4.createCell(4);
                                cell22.setCellValue(culvertOftenCheck.getNoteTaker());
                                cell22.setCellStyle(cellStyle);
                                HSSFCell cell23 = row4.createCell(5);
                                cell23.setCellValue(culvertOftenCheck.getEvaluateValue());
                                cell23.setCellStyle(cellStyle);
                            } else {
                                row4.createCell(0).setCellStyle(cellStyle);
                                row4.createCell(1).setCellStyle(cellStyle);
                                row4.createCell(2).setCellStyle(cellStyle);
                                row4.createCell(3).setCellStyle(cellStyle);
                                row4.createCell(4).setCellStyle(cellStyle);
                                row4.createCell(5).setCellStyle(cellStyle);
                                rowIndex++;
                            }

                        }
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 0, 0));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 1, 1));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 2, 2));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 3, 3));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 4, 4));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 5, 5));
//                        rowIndex++;


                    } else {
//                        HSSFRow row0 = sheet.createRow(rowIndex);
//                        HSSFCell cell24 = row0.createCell(0);
//                        cell24.setCellValue("涵洞经常检查");
//                        cell24.setCellStyle(cellStyleTitle);
//                        setExcelStyleTitle(cellStyleTitle, workbook);
//                        sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 0, 9));
//                        HSSFRow row1 = sheet.createRow(++rowIndex);
//                        HSSFCell cell = row1.createCell(0);
//                        cell.setCellStyle(cellStyle);
//                        cell.setCellValue("路线名称:");
//                        sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 1, 4));
//                        HSSFCell cell1 = row1.createCell(1);
//                        cell1.setCellStyle(cellStyle);
//                        cell1.setCellValue(road.getName());
//                        HSSFCell cell2 = row1.createCell(6);
//                        cell2.setCellStyle(cellStyle);
//                        cell2.setCellValue("路线编码:");
//                        HSSFCell cell3 = row1.createCell(7);

//                        row1.createCell(2).setCellStyle(cellStyle);
//                        row1.createCell(3).setCellStyle(cellStyle);
//                        row1.createCell(4).setCellStyle(cellStyle);
//                        row1.createCell(5).setCellStyle(cellStyle);
//                        row1.createCell(8).setCellStyle(cellStyle);
//                        row1.createCell(9).setCellStyle(cellStyle);
//                        cell3.setCellStyle(cellStyle);
//                        sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 7, 9));
//                        cell3.setCellValue(road.getCode());
                        HSSFRow row2 = sheet.createRow(++rowIndex);
                        HSSFCell cell4 = row2.createCell(0);
                        cell4.setCellStyle(cellStyle);
                        cell4.setCellValue("涵洞桩号");
                        HSSFCell cell5 = row2.createCell(1);
                        cell5.setCellStyle(cellStyle);
                        cell5.setCellValue("涵洞类型");
                        HSSFCell cell6 = row2.createCell(2);
                        cell6.setCellStyle(cellStyle);
                        cell6.setCellValue("检查日期");
                        HSSFCell cell7 = row2.createCell(3);
                        cell7.setCellStyle(cellStyle);
                        cell7.setCellValue("检查人");
                        HSSFCell cell8 = row2.createCell(4);
                        cell8.setCellStyle(cellStyle);
                        cell8.setCellValue("记录人");
                        HSSFCell cell9 = row2.createCell(5);
                        cell9.setCellStyle(cellStyle);
                        cell9.setCellValue("总体评价");
                        HSSFCell cell10 = row2.createCell(6);
                        cell10.setCellStyle(cellStyle);
                        cell10.setCellValue("检查内容");
                        HSSFCell cell11 = row2.createCell(7);
                        cell11.setCellStyle(cellStyle);
                        cell11.setCellValue("状态描述");
                        HSSFCell cell12 = row2.createCell(8);
                        cell12.setCellStyle(cellStyle);
                        cell12.setCellValue("判断结论");
                        HSSFCell cell13 = row2.createCell(9);
                        cell13.setCellStyle(cellStyle);
                        cell13.setCellValue("处理措施");
                        row0.setHeight((short) (25 * 20));
                        row1.setHeight((short) (20 * 20));
                        row2.setHeight((short) (20 * 20));
                        Integer rowIndexFor = rowIndex + 1;
                        List<SysDictionaryDetail> list = hdjcjcmx.get("hdjcjcmx");
                        for (int i = 0; i < list.size(); i++) {
                            HSSFRow row4 = sheet.createRow(rowIndexFor + i);
                            Map map = (Map) list.get(i);
                            SysDictionaryDetail detail = BeanUtil.toBean(map, SysDictionaryDetail.class);
                            HSSFCell cell14 = row4.createCell(6);
                            cell14.setCellStyle(cellStyle);
                            cell14.setCellValue(detail.getName());
                            HSSFCell cell15 = row4.createCell(7);
                            cell15.setCellStyle(cellStyle);
                            HSSFCell cell16 = row4.createCell(8);
                            cell16.setCellStyle(cellStyle);
                            row4.setHeight((short) (15 * 20));
                            HSSFCell cell17 = row4.createCell(9);
                            cell17.setCellStyle(cellStyle);

                            if (i == 0) {
                                HSSFCell cell18 = row4.createCell(0);
                                cell18.setCellValue(culvert.getCentPeg() + "(" + culvert.getDirectionValue() + ")");
                                cell18.setCellStyle(cellStyle);
                                HSSFCell cell19 = row4.createCell(1);
                                cell19.setCellValue(culvert.getTypeValue());
                                cell19.setCellStyle(cellStyle);
                                HSSFCell cell20 = row4.createCell(2);

                                cell20.setCellStyle(cellStyle);
                                HSSFCell cell21 = row4.createCell(3);

                                cell21.setCellStyle(cellStyle);
                                HSSFCell cell22 = row4.createCell(4);

                                cell22.setCellStyle(cellStyle);
                                HSSFCell cell23 = row4.createCell(5);

                                cell23.setCellStyle(cellStyle);
                            } else {
                                row4.createCell(0).setCellStyle(cellStyle);
                                row4.createCell(1).setCellStyle(cellStyle);
                                row4.createCell(2).setCellStyle(cellStyle);
                                row4.createCell(3).setCellStyle(cellStyle);
                                row4.createCell(4).setCellStyle(cellStyle);
                                row4.createCell(5).setCellStyle(cellStyle);
                            }

                            rowIndex++;
                        }
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 0, 0));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 1, 1));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 2, 2));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 3, 3));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 4, 4));
                        sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 5, 5));
//                        rowIndex++;
                    }

                }

                try {
                    OutputStream os = new FileOutputStream(file + "/" + "涵洞经常检查记录表" + System.currentTimeMillis() + ".xls");
                    workbook.write(os);
                    os.flush();
                    os.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            //exportCulvert(file, hdjcjcmx, strings);

            this.zip(fileName, true);
            String zip = fileName + ".zip";

            HttpUtil.downLoadFile(response, zip, zip);
            // 删除导出的文件
            FileUtil.deleteFile(zip);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }


    private void exportCulvert(File file, Map<String, List<SysDictionaryDetail>> hdjcjcmx, List<String> strings) {
        strings.forEach(s -> {
                    //查询涵洞信息
                    BizCulvertInformation culvert = culvertInformationManager.getById(s);
                    //根据桥梁信息查询路段
                    Road road = roadManager.getById(culvert.getRoadSegmentId());

                    QueryWrapper<CulvertOftenCheck> queryWrapper = new QueryWrapper<CulvertOftenCheck>();
                    //查询最新一次的检查信息
                    CulvertOftenCheck culvertOftenCheck = culvertOftenCheckManager.getBaseMapper().selectOne(queryWrapper.eq("CULVERT_ID_", s).orderByDesc("CHECK_DATE_").orderByDesc("CREATE_TIME_").last("limit 0,1"));
                    HSSFWorkbook workbook = new HSSFWorkbook();
                    HSSFCellStyle cellStyle = workbook.createCellStyle();
                    setExcelStyle(cellStyle, workbook);
                    HSSFSheet sheet = workbook.createSheet("涵洞经常检查记录表");
                    sheet.setColumnWidth(0, 5000);
                    sheet.setColumnWidth(1, 5000);
                    sheet.setColumnWidth(2, 5000);
                    sheet.setColumnWidth(3, 5000);
                    sheet.setColumnWidth(4, 5000);
                    sheet.setColumnWidth(5, 5000);
                    sheet.setColumnWidth(6, 5000);
                    if (culvertOftenCheck != null) {
                        List<CulvertOftenCheckDetail> list = culvertOftenCheckDetailManager.list(new QueryWrapper<CulvertOftenCheckDetail>().lambda().eq(CulvertOftenCheckDetail::getCulvertOftenCheckId, culvertOftenCheck.getId()));
                        HSSFRow row = sheet.createRow(0);
                        HSSFCell rowCell0 = row.createCell(0);
                        rowCell0.setCellStyle(cellStyle);
                        rowCell0.setCellValue("路线编号");
                        HSSFCell rowCell = row.createCell(1);
                        rowCell.setCellStyle(cellStyle);
                        rowCell.setCellValue(road.getCode());
                        HSSFCell rowCell1 = row.createCell(2);
                        rowCell1.setCellStyle(cellStyle);
                        rowCell1.setCellValue("路线名称");
                        HSSFCell rowCell2 = row.createCell(3);
                        rowCell2.setCellStyle(cellStyle);
                        rowCell2.setCellValue(road.getName());
                        HSSFCell rowCell3 = row.createCell(4);
                        rowCell3.setCellStyle(cellStyle);
                        rowCell3.setCellValue("行政区划");
                        HSSFCell rowCell4 = row.createCell(5);
                        rowCell4.setCellStyle(cellStyle);

                        HSSFRow row1 = sheet.createRow(1);
                        HSSFCell cell1 = row1.createCell(0);
                        cell1.setCellStyle(cellStyle);
                        cell1.setCellValue("中心桩号");
                        HSSFCell cell2 = row1.createCell(1);
                        cell2.setCellStyle(cellStyle);
                        cell2.setCellValue(culvert.getCentPeg());
                        HSSFCell cell3 = row1.createCell(2);
                        cell3.setCellStyle(cellStyle);
                        cell3.setCellValue("涵洞类型");
                        HSSFCell cell4 = row1.createCell(3);
                        cell4.setCellStyle(cellStyle);
                        cell4.setCellValue(culvert.getTypeValue());
                        HSSFCell cell5 = row1.createCell(4);
                        cell5.setCellStyle(cellStyle);
                        cell5.setCellValue("养护单位");
                        HSSFCell cell6 = row1.createCell(5);
                        cell6.setCellStyle(cellStyle);
                        cell6.setCellValue(culvert.getOfficeName());
                        HSSFRow row3 = sheet.createRow(2);

                        HSSFCell cell13 = row3.createCell(0);
                        cell13.setCellStyle(cellStyle);
                        cell13.setCellValue("部件编号");
                        sheet.addMergedRegion(new CellRangeAddress(2, 2, 2, 3));
                        sheet.addMergedRegion(new CellRangeAddress(2, 2, 4, 5));
                        HSSFCell cell14 = row3.createCell(1);
                        cell14.setCellStyle(cellStyle);
                        cell14.setCellValue("缺损类型");
                        row3.createCell(2).setCellStyle(cellStyle);
                        HSSFCell cell15 = row3.createCell(3);
                        cell15.setCellStyle(cellStyle);
                        cell15.setCellValue("缺损范围");

                        HSSFCell cell16 = row3.createCell(4);
                        cell16.setCellStyle(cellStyle);
                        cell16.setCellValue("保养措施意见");
                        row3.createCell(5).setCellStyle(cellStyle);

                        for (int i = 0; i < list.size(); i++) {
                            HSSFRow row4 = sheet.createRow(3 + i);
                            CulvertOftenCheckDetail culvertOftenCheckDetail = list.get(i);
                            HSSFCell cell17 = row4.createCell(0);
                            cell17.setCellStyle(cellStyle);
                            cell17.setCellValue(culvertOftenCheckDetail.getCheckProject());
                            sheet.addMergedRegion(new CellRangeAddress(3 + i, 3 + i, 2, 3));
                            sheet.addMergedRegion(new CellRangeAddress(3 + i, 3 + i, 4, 5));
                            HSSFCell cell18 = row4.createCell(1);
                            cell18.setCellStyle(cellStyle);
                            cell18.setCellValue(culvertOftenCheckDetail.getStatusDesc());
                            HSSFCell cell19 = row4.createCell(3);
                            cell19.setCellStyle(cellStyle);
                            cell19.setCellValue(culvertOftenCheckDetail.getResult());
                            HSSFCell cell20 = row4.createCell(4);
                            cell20.setCellStyle(cellStyle);
                            cell20.setCellValue(culvertOftenCheckDetail.getProcess());
                            row4.createCell(2).setCellStyle(cellStyle);
                            row4.createCell(5).setCellStyle(cellStyle);
                        }
                        HSSFRow row4 = sheet.createRow(3 + list.size());
                        HSSFCell cell = row4.createCell(0);
                        sheet.addMergedRegion(new CellRangeAddress(3 + list.size(), 3 + list.size(), 1, 5));
                        cell.setCellStyle(cellStyle);
                        cell.setCellValue("备注");
                        HSSFCell cell7 = row4.createCell(1);
                        cell7.setCellStyle(cellStyle);
                        cell7.setCellValue(culvertOftenCheck.getRemarks());
                        row4.createCell(2).setCellStyle(cellStyle);
                        row4.createCell(3).setCellStyle(cellStyle);
                        row4.createCell(4).setCellStyle(cellStyle);
                        row4.createCell(5).setCellStyle(cellStyle);
                        try {
                            OutputStream os = new FileOutputStream(file + "/" + culvert.getRoadSegmentName() + "-" + culvert.getNumber() + "-" + culvert.getDirectionValue() + "-" + System.currentTimeMillis() + ".xls");
                            workbook.write(os);
                            os.flush();
                            os.close();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    } else {
                        HSSFRow row = sheet.createRow(0);
                        HSSFCell rowCell0 = row.createCell(0);
                        rowCell0.setCellStyle(cellStyle);
                        rowCell0.setCellValue("路线编号");
                        HSSFCell rowCell = row.createCell(1);
                        rowCell.setCellStyle(cellStyle);
                        rowCell.setCellValue(road.getCode());
                        HSSFCell rowCell1 = row.createCell(2);
                        rowCell1.setCellStyle(cellStyle);
                        rowCell1.setCellValue("路线名称");
                        HSSFCell rowCell2 = row.createCell(3);
                        rowCell2.setCellStyle(cellStyle);
                        rowCell2.setCellValue(road.getName());
                        HSSFCell rowCell3 = row.createCell(4);
                        rowCell3.setCellStyle(cellStyle);
                        rowCell3.setCellValue("行政区划");
                        HSSFCell rowCell4 = row.createCell(5);
                        rowCell4.setCellStyle(cellStyle);

                        HSSFRow row1 = sheet.createRow(1);
                        HSSFCell cell1 = row1.createCell(0);
                        cell1.setCellStyle(cellStyle);
                        cell1.setCellValue("中心桩号");
                        HSSFCell cell2 = row1.createCell(1);
                        cell2.setCellStyle(cellStyle);
                        cell2.setCellValue(culvert.getCentPeg());
                        HSSFCell cell3 = row1.createCell(2);
                        cell3.setCellStyle(cellStyle);
                        cell3.setCellValue("涵洞类型");
                        HSSFCell cell4 = row1.createCell(3);
                        cell4.setCellStyle(cellStyle);
                        cell4.setCellValue(culvert.getTypeValue());
                        HSSFCell cell5 = row1.createCell(4);
                        cell5.setCellStyle(cellStyle);
                        cell5.setCellValue("养护单位");
                        HSSFCell cell6 = row1.createCell(5);
                        cell6.setCellStyle(cellStyle);
                        cell6.setCellValue(culvert.getOfficeName());
                        HSSFRow row3 = sheet.createRow(2);
                        HSSFCell cell13 = row3.createCell(0);
                        cell13.setCellStyle(cellStyle);
                        cell13.setCellValue("部件编号");
                        sheet.addMergedRegion(new CellRangeAddress(2, 2, 2, 3));
                        sheet.addMergedRegion(new CellRangeAddress(2, 2, 4, 5));
                        HSSFCell cell14 = row3.createCell(1);
                        cell14.setCellStyle(cellStyle);
                        cell14.setCellValue("缺损类型");
                        row3.createCell(2).setCellStyle(cellStyle);
                        HSSFCell cell15 = row3.createCell(3);
                        cell15.setCellStyle(cellStyle);
                        cell15.setCellValue("缺损范围");

                        HSSFCell cell16 = row3.createCell(4);
                        cell16.setCellStyle(cellStyle);
                        cell16.setCellValue("保养措施意见");
                        row3.createCell(5).setCellStyle(cellStyle);
                        List<SysDictionaryDetail> list = hdjcjcmx.get("hdjcjcmx");
                        for (int i = 0; i < list.size(); i++) {
                            HSSFRow row4 = sheet.createRow(3 + i);
                            Map map = (Map) list.get(i);
                            SysDictionaryDetail detail = BeanUtil.toBean(map, SysDictionaryDetail.class);
                            HSSFCell cell17 = row4.createCell(0);
                            cell17.setCellStyle(cellStyle);
                            cell17.setCellValue(detail.getName());
                            sheet.addMergedRegion(new CellRangeAddress(3 + i, 3 + i, 2, 3));
                            sheet.addMergedRegion(new CellRangeAddress(3 + i, 3 + i, 4, 5));
                            HSSFCell cell18 = row4.createCell(1);
                            cell18.setCellStyle(cellStyle);
                            HSSFCell cell19 = row4.createCell(3);
                            cell19.setCellStyle(cellStyle);
                            HSSFCell cell20 = row4.createCell(4);
                            cell20.setCellStyle(cellStyle);
                            row4.createCell(2).setCellStyle(cellStyle);
                            row4.createCell(5).setCellStyle(cellStyle);
                        }
                        HSSFRow row4 = sheet.createRow(3 + list.size());
                        HSSFCell cell = row4.createCell(0);
                        sheet.addMergedRegion(new CellRangeAddress(3 + list.size(), 3 + list.size(), 1, 5));
                        cell.setCellStyle(cellStyle);
                        cell.setCellValue("备注");
                        row4.createCell(1).setCellStyle(cellStyle);
                        row4.createCell(2).setCellStyle(cellStyle);
                        row4.createCell(3).setCellStyle(cellStyle);
                        row4.createCell(4).setCellStyle(cellStyle);
                        row4.createCell(5).setCellStyle(cellStyle);
                        try {
                            OutputStream os = new FileOutputStream(file + "/" + culvert.getRoadSegmentName() + "-" + culvert.getNumber() + "-" + culvert.getDirectionValue() + "-" + System.currentTimeMillis() + ".xls");
                            workbook.write(os);
                            os.flush();
                            os.close();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
        );
    }

    @Override
    public void exportSideSlopeOften(String ids, HttpServletResponse response) {
        try {
            long time = System.currentTimeMillis();
            String fileName = "边坡经常检查" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            Map<String, List<SysDictionaryDetail>> bpjcjcmx = sysDictionaryManager.queryDictItemsByCode("bpjcjcmx");
            Map<String, List<SysDictionaryDetail>> fx = sysDictionaryManager.queryDictItemsByCode(FX);

            List<String> strings = Arrays.asList(ids.split(","));
            strings.forEach(s -> {
                SideSlopeInformation sideSlope = sideSlopeInformationManager.getById(s);
                Road road = roadManager.getById(sideSlope.getRoadSegmentId());
                QueryWrapper<SideSlopeOftenCheck> queryWrapper = new QueryWrapper<>();
                SideSlopeOftenCheck sideSlopeOftenCheck = sideSlopeOftenCheckManager.getBaseMapper().selectOne(queryWrapper.eq("SIDE_SLOPE_ID_", s).orderByDesc("CHECK_DATE_").orderByDesc("CREATE_TIME_").last("limit 0,1"));
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                setExcelStyle(cellStyle, workbook);
                HSSFCellStyle cellStyleTitle = workbook.createCellStyle();

                HSSFSheet sheet = workbook.createSheet("边坡经常检查记录表");
                sheet.getPrintSetup().setPaperSize(HSSFPrintSetup.A4_PAPERSIZE);
                sheet.setColumnWidth(0, 20 * 256);
                sheet.setColumnWidth(1, 10 * 256);
                sheet.setColumnWidth(2, 10 * 256);
                sheet.setColumnWidth(3, 15 * 256);
                sheet.setColumnWidth(4, 9 * 256);
                sheet.setColumnWidth(5, 20 * 256);
                //sheet.setColumnWidth(6, 10 * 256);
                if (sideSlopeOftenCheck != null) {
                    exportSideSlopData(file, sideSlope, road, sideSlopeOftenCheck, workbook, cellStyle, cellStyleTitle, sheet,fx);
                } else {
                    exportSideSlop(file, bpjcjcmx, sideSlope, road, workbook, cellStyle, cellStyleTitle, sheet,fx);
                }
            });
            this.zip(fileName, true);
            String zip = fileName + ".zip";

            HttpUtil.downLoadFile(response, zip, zip);
            // 删除导出的文件
            FileUtil.deleteFile(zip);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }

    private void exportSideSlop(File file, Map<String, List<SysDictionaryDetail>> bpjcjcmx, SideSlopeInformation sideSlope, Road road, HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFCellStyle cellStyleTitle, HSSFSheet sheet,Map<String, List<SysDictionaryDetail>> fx  ) {
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 5));
        HSSFRow row0 = sheet.createRow(0);
        HSSFCell cell0 = row0.createCell(0);
        cell0.setCellValue("边坡经常检查");
        cell0.setCellStyle(cellStyleTitle);
        setExcelStyleTitle(cellStyleTitle, workbook);
        HSSFRow row = sheet.createRow(1);
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("管理单位");
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 5));
        HSSFCell cell1 = row.createCell(1);
        cell1.setCellStyle(cellStyle);
        cell1.setCellValue(getCompany(sideSlope.getOfficeName()));
        row.createCell(2).setCellStyle(cellStyle);
        row.createCell(3).setCellStyle(cellStyle);
        row.createCell(4).setCellStyle(cellStyle);
        row.createCell(5).setCellStyle(cellStyle);
        HSSFRow row1 = sheet.createRow(2);
        HSSFCell cell2 = row1.createCell(0);
        cell2.setCellStyle(cellStyle);
        cell2.setCellValue("路线编码");
        HSSFCell cell3 = row1.createCell(1);
        cell3.setCellStyle(cellStyle);
        cell3.setCellValue(road.getCode());
        HSSFCell cell4 = row1.createCell(2);
        cell4.setCellStyle(cellStyle);
        cell4.setCellValue("路线名称");
        HSSFCell cell5 = row1.createCell(3);
        cell5.setCellStyle(cellStyle);
        cell5.setCellValue(road.getName());
        HSSFCell cell6 = row1.createCell(4);
        cell6.setCellStyle(cellStyle);
        cell6.setCellValue("桩号");
        HSSFCell cell7 = row1.createCell(5);
        cell7.setCellStyle(cellStyle);
        cell7.setCellValue(sideSlope.getStartPeg() + "-" + sideSlope.getEndPeg());
        HSSFRow row2 = sheet.createRow(3);
        HSSFCell cell8 = row2.createCell(0);
        cell8.setCellStyle(cellStyle);
        cell8.setCellValue("路线方向");
        HSSFCell cell9 = row2.createCell(1);
        cell9.setCellStyle(cellStyle);
        if(null != fx){
            List<SysDictionaryDetail> details = fx.get(FX);
            if(null != details){
                for (int i = 0; i < details.size(); i++) {
                    Map map = (Map) details.get(i);
                    SysDictionaryDetail detail = BeanUtil.toBean(map, SysDictionaryDetail.class);
                    if(null != detail.getValue() &&  detail.getValue().equals(sideSlope.getDirection())){
                        cell9.setCellValue(detail.getName());
                        continue;
                    }
                }
            }
        }







        HSSFCell cell10 = row2.createCell(2);
        cell10.setCellStyle(cellStyle);
        cell10.setCellValue("防护种类");
        HSSFCell cell11 = row2.createCell(3);
        cell11.setCellStyle(cellStyle);
        cell11.setCellValue(sideSlope.getProtectMaterial());
        HSSFCell cell12 = row2.createCell(4);
        cell12.setCellStyle(cellStyle);
        cell12.setCellValue("边坡高度（m）");
        HSSFCell cell13 = row2.createCell(5);
        cell13.setCellStyle(cellStyle);
        cell13.setCellValue(sideSlope.getHeight());
        HSSFRow row3 = sheet.createRow(4);
        HSSFCell cell14 = row3.createCell(0);
        cell14.setCellStyle(cellStyle);
        cell14.setCellValue("检查日期");
        HSSFCell cell15 = row3.createCell(1);
        cell15.setCellStyle(cellStyle);
        HSSFCell cell16 = row3.createCell(2);
        cell16.setCellStyle(cellStyle);
        cell16.setCellValue("天气");
        HSSFCell cell17 = row3.createCell(3);
        cell17.setCellStyle(cellStyle);
        HSSFCell cell18 = row3.createCell(4);
        cell18.setCellStyle(cellStyle);
        cell18.setCellValue("总体评价");
        HSSFCell cell19 = row3.createCell(5);
        cell19.setCellStyle(cellStyle);
        HSSFRow row4 = sheet.createRow(5);
        HSSFCell cell29 = row4.createCell(0);
        cell29.setCellStyle(cellStyle);
        cell29.setCellValue("备注");
        sheet.addMergedRegion(new CellRangeAddress(5, 5, 1, 5));
        HSSFCell cell20 = row4.createCell(1);
        cell20.setCellStyle(cellStyle);

        row4.createCell(2).setCellStyle(cellStyle);
        row4.createCell(3).setCellStyle(cellStyle);
        row4.createCell(4).setCellStyle(cellStyle);
        row4.createCell(5).setCellStyle(cellStyle);

        HSSFRow row5 = sheet.createRow(6);
        sheet.addMergedRegion(new CellRangeAddress(6, 6, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(6, 6, 3, 4));
        HSSFCell cell21 = row5.createCell(0);
        cell21.setCellStyle(cellStyle);
        cell21.setCellValue("检查项目");
        HSSFCell cell22 = row5.createCell(1);
        cell22.setCellStyle(cellStyle);
        cell22.setCellValue("状态描述");
        HSSFCell cell23 = row5.createCell(3);
        cell23.setCellStyle(cellStyle);
        cell23.setCellValue("判断结论");
        HSSFCell cell24 = row5.createCell(5);
        cell24.setCellStyle(cellStyle);
        cell24.setCellValue("处理措施");
        row5.createCell(2).setCellStyle(cellStyle);
        row5.createCell(4).setCellStyle(cellStyle);
        row0.setHeight((short) (32 * 20));
        row.setHeight((short) (29 * 20));
        row1.setHeight((short) (29 * 20));
        row2.setHeight((short) (29 * 20));
        row3.setHeight((short) (29 * 20));
        row4.setHeight((short) (125 * 20));
        row5.setHeight((short) (29 * 20));
        List<SysDictionaryDetail> list = bpjcjcmx.get("bpjcjcmx");
        for (int i = 0; i < list.size(); i++) {
            HSSFRow row6 = sheet.createRow(7 + i);
            Map map = (Map) list.get(i);
            SysDictionaryDetail detail = BeanUtil.toBean(map, SysDictionaryDetail.class);
            HSSFCell cell25 = row6.createCell(0);
            cell25.setCellStyle(cellStyle);
            cell25.setCellValue(detail.getName());
            sheet.addMergedRegion(new CellRangeAddress(7 + i, 7 + i, 1, 2));
            sheet.addMergedRegion(new CellRangeAddress(7 + i, 7 + i, 3, 4));
            HSSFCell cell26 = row6.createCell(1);
            cell26.setCellStyle(cellStyle);
            HSSFCell cell27 = row6.createCell(3);
            cell27.setCellStyle(cellStyle);
            HSSFCell cell28 = row6.createCell(5);
            cell28.setCellStyle(cellStyle);
            row6.createCell(2).setCellStyle(cellStyle);
            row6.createCell(4).setCellStyle(cellStyle);
            row6.setHeight((short) (52 * 20));
        }
        sheet.addMergedRegion(new CellRangeAddress(7 + list.size(), 7 + list.size(), 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(7 + list.size(), 7 + list.size(), 4, 5));
        HSSFRow row6 = sheet.createRow(7 + list.size());
        HSSFCell cell25 = row6.createCell(0);
        cell25.setCellStyle(cellStyle);
        cell25.setCellValue("检查人");
        HSSFCell cell26 = row6.createCell(1);
        cell26.setCellStyle(cellStyle);
        HSSFCell cell27 = row6.createCell(3);
        cell27.setCellStyle(cellStyle);
        cell27.setCellValue("记录人");
        HSSFCell cell28 = row6.createCell(4);
        cell28.setCellStyle(cellStyle);
        row6.createCell(2).setCellStyle(cellStyle);
        row6.createCell(5).setCellStyle(cellStyle);
        row6.setHeight((short) (22 * 20));
        try {
            OutputStream os = new FileOutputStream(file + "/边坡经常检查" + road.getName() + "-" + sideSlope.getStartPeg() + "-" + sideSlope.getDirectionValue() + "-" + System.currentTimeMillis() + ".xls");
            workbook.write(os);
            os.flush();
            os.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void exportSideSlopData(File file, SideSlopeInformation sideSlope, Road road, SideSlopeOftenCheck sideSlopeOftenCheck, HSSFWorkbook workbook, HSSFCellStyle cellStyle, HSSFCellStyle cellStyleTitle, HSSFSheet sheet,Map<String, List<SysDictionaryDetail>> fx  ) {
        List<SideSlopeOftenCheckDetail> list = sideSlopeOftenCheckDetailManager.list(new QueryWrapper<SideSlopeOftenCheckDetail>().lambda().eq(SideSlopeOftenCheckDetail::getSideSlopeOftenCheckId, sideSlopeOftenCheck.getId()));
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 5));
        HSSFRow row0 = sheet.createRow(0);
        HSSFCell cell0 = row0.createCell(0);
        cell0.setCellValue("边坡经常检查");
        cell0.setCellStyle(cellStyleTitle);
        setExcelStyleTitle(cellStyleTitle, workbook);
        HSSFRow row = sheet.createRow(1);
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle(cellStyle);
        cell.setCellValue("管理单位");
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 5));
        HSSFCell cell1 = row.createCell(1);
        cell1.setCellStyle(cellStyle);
        cell1.setCellValue(getCompany(sideSlope.getOfficeName()));
        row.createCell(2).setCellStyle(cellStyle);
        row.createCell(3).setCellStyle(cellStyle);
        row.createCell(4).setCellStyle(cellStyle);
        row.createCell(5).setCellStyle(cellStyle);
        HSSFRow row1 = sheet.createRow(2);
        HSSFCell cell2 = row1.createCell(0);
        cell2.setCellStyle(cellStyle);
        cell2.setCellValue("路线编码");
        HSSFCell cell3 = row1.createCell(1);
        cell3.setCellStyle(cellStyle);
        cell3.setCellValue(road.getCode());
        HSSFCell cell4 = row1.createCell(2);
        cell4.setCellStyle(cellStyle);
        cell4.setCellValue("路线名称");
        HSSFCell cell5 = row1.createCell(3);
        cell5.setCellStyle(cellStyle);
        cell5.setCellValue(road.getName());
        HSSFCell cell6 = row1.createCell(4);
        cell6.setCellStyle(cellStyle);
        cell6.setCellValue("桩号");
        HSSFCell cell7 = row1.createCell(5);
        cell7.setCellStyle(cellStyle);

            cell7.setCellValue(sideSlope.getStartPeg() + "-" + sideSlope.getEndPeg());

        HSSFRow row2 = sheet.createRow(3);
        HSSFCell cell8 = row2.createCell(0);
        cell8.setCellStyle(cellStyle);
        cell8.setCellValue("路线方向");
        HSSFCell cell9 = row2.createCell(1);
        cell9.setCellStyle(cellStyle);
        if(null != fx){
            List<SysDictionaryDetail> details = fx.get(FX);
            if(null != details){
                for (int i = 0; i < details.size(); i++) {
                    Map map = (Map) details.get(i);
                    SysDictionaryDetail detail = BeanUtil.toBean(map, SysDictionaryDetail.class);
                    if(null != detail.getValue() &&  detail.getValue().equals(sideSlope.getDirection())){
                        cell9.setCellValue(detail.getName());
                        continue;
                    }
                }
            }
        }




        HSSFCell cell10 = row2.createCell(2);
        cell10.setCellStyle(cellStyle);
        cell10.setCellValue("防护种类");
        HSSFCell cell11 = row2.createCell(3);
        cell11.setCellStyle(cellStyle);
        cell11.setCellValue(sideSlope.getProtectMaterial());
        HSSFCell cell12 = row2.createCell(4);
        cell12.setCellStyle(cellStyle);
        cell12.setCellValue("边坡高度（m）");
        HSSFCell cell13 = row2.createCell(5);
        cell13.setCellStyle(cellStyle);
        if (ObjectUtils.isNotEmpty(sideSlope.getHeight())) {
            cell13.setCellValue(sideSlope.getHeight());
        }
        HSSFRow row3 = sheet.createRow(4);
        HSSFCell cell14 = row3.createCell(0);
        cell14.setCellStyle(cellStyle);
        cell14.setCellValue("检查日期");
        HSSFCell cell15 = row3.createCell(1);
        cell15.setCellStyle(cellStyle);
        Date checkDate = sideSlopeOftenCheck.getCheckDate();
        String dateStr = new SimpleDateFormat("yyyy/MM/dd").format(checkDate);

        cell15.setCellValue(dateStr);
        HSSFCell cell16 = row3.createCell(2);
        cell16.setCellStyle(cellStyle);
        cell16.setCellValue("天气");
        HSSFCell cell17 = row3.createCell(3);
        cell17.setCellStyle(cellStyle);
        cell17.setCellValue(sideSlopeOftenCheck.getWeatherValue());
        HSSFCell cell18 = row3.createCell(4);
        cell18.setCellStyle(cellStyle);
        cell18.setCellValue("总体评价");
        HSSFCell cell19 = row3.createCell(5);
        cell19.setCellStyle(cellStyle);
        cell19.setCellValue(sideSlopeOftenCheck.getEvaluateValue());
        HSSFRow row4 = sheet.createRow(5);
        HSSFCell cell29 = row4.createCell(0);
        cell29.setCellStyle(cellStyle);
        cell29.setCellValue("备注");
        sheet.addMergedRegion(new CellRangeAddress(5, 5, 1, 5));
        HSSFCell cell20 = row4.createCell(1);
        cell20.setCellStyle(cellStyle);
        cell20.setCellValue(sideSlopeOftenCheck.getRemarks());
        row4.createCell(2).setCellStyle(cellStyle);
        row4.createCell(3).setCellStyle(cellStyle);
        row4.createCell(4).setCellStyle(cellStyle);
        row4.createCell(5).setCellStyle(cellStyle);

        HSSFRow row5 = sheet.createRow(6);
        sheet.addMergedRegion(new CellRangeAddress(6, 6, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(6, 6, 3, 4));
        HSSFCell cell21 = row5.createCell(0);
        cell21.setCellStyle(cellStyle);
        cell21.setCellValue("检查项目");
        HSSFCell cell22 = row5.createCell(1);
        cell22.setCellStyle(cellStyle);
        cell22.setCellValue("状态描述");
        HSSFCell cell23 = row5.createCell(3);
        cell23.setCellStyle(cellStyle);
        cell23.setCellValue("判断结论");
        HSSFCell cell24 = row5.createCell(5);
        cell24.setCellStyle(cellStyle);
        cell24.setCellValue("处理措施");
        row5.createCell(2).setCellStyle(cellStyle);
        row5.createCell(4).setCellStyle(cellStyle);
        row0.setHeight((short) (32 * 20));
        row.setHeight((short) (29 * 20));
        row1.setHeight((short) (29 * 20));
        row2.setHeight((short) (29 * 20));
        row3.setHeight((short) (29 * 20));
        row4.setHeight((short) (125 * 20));
        row5.setHeight((short) (29 * 20));
        for (int i = 0; i < list.size(); i++) {
            HSSFRow row6 = sheet.createRow(7 + i);
            SideSlopeOftenCheckDetail sideSlopeOftenCheckDetail = list.get(i);
            HSSFCell cell25 = row6.createCell(0);
            cell25.setCellStyle(cellStyle);
            cell25.setCellValue(sideSlopeOftenCheckDetail.getCheckProject());
            sheet.addMergedRegion(new CellRangeAddress(7 + i, 7 + i, 1, 2));
            sheet.addMergedRegion(new CellRangeAddress(7 + i, 7 + i, 3, 4));
            HSSFCell cell26 = row6.createCell(1);
            cell26.setCellStyle(cellStyle);
            cell26.setCellValue(sideSlopeOftenCheckDetail.getStatusDesc());
            HSSFCell cell27 = row6.createCell(3);
            cell27.setCellValue(sideSlopeOftenCheckDetail.getResult());
            cell27.setCellStyle(cellStyle);
            HSSFCell cell28 = row6.createCell(5);
            cell28.setCellStyle(cellStyle);
            cell28.setCellValue(sideSlopeOftenCheckDetail.getProcess());
            row6.createCell(2).setCellStyle(cellStyle);
            row6.createCell(4).setCellStyle(cellStyle);
            row6.setHeight((short) (52 * 20));
        }
        sheet.addMergedRegion(new CellRangeAddress(7 + list.size(), 7 + list.size(), 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(7 + list.size(), 7 + list.size(), 4, 5));
        HSSFRow row6 = sheet.createRow(7 + list.size());
        HSSFCell cell25 = row6.createCell(0);
        cell25.setCellStyle(cellStyle);
        cell25.setCellValue("检查人");
        HSSFCell cell26 = row6.createCell(1);
        cell26.setCellStyle(cellStyle);
        cell26.setCellValue(sideSlopeOftenCheck.getRummager());
        HSSFCell cell27 = row6.createCell(3);
        cell27.setCellStyle(cellStyle);
        cell27.setCellValue("记录人");
        HSSFCell cell28 = row6.createCell(4);
        cell28.setCellStyle(cellStyle);
        cell28.setCellValue(sideSlopeOftenCheck.getNoteTaker());
        row6.createCell(2).setCellStyle(cellStyle);
        row6.createCell(5).setCellStyle(cellStyle);
        row6.setHeight((short) (22 * 20));
        try {
            String direction = sideSlope.getDirection();
            String directionValue="";
            if(direction.equals("1")){
                directionValue="上行方向";
            }
            if(direction.equals("2")){
                directionValue="下行方向";
            }


            OutputStream os = new FileOutputStream(file + "/边坡经常检查" + road.getName() + "-" + sideSlope.getStartPeg() + "-" + directionValue + "-" +new SimpleDateFormat("yyyy-MM-dd").format(checkDate)+ "-"+ sideSlope.getId() + ".xls");
            workbook.write(os);
            os.flush();
            os.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportBridgeOftenHistory(String id, String ids,  Date timeGrateThan, Date timeLessThan,HttpServletResponse response) {

            long time = System.currentTimeMillis();
            String fileName = " 桥梁经常检查记录表" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }


            if (StringUtils.isEmpty(id)) {
                throw new RuntimeException("桥梁id不能为空");
            }



            QueryWrapper<BridgeOftenCheck> queryWrapper = new QueryWrapper<BridgeOftenCheck>();
            List<String> bridgeIds = Arrays.asList(id.split(","));
            queryWrapper.in("BRIGE_ID_",bridgeIds);



            if (null!=ids && !ids.equals("")){
                List<String> strings = Arrays.asList(ids.split(","));
                queryWrapper.in("ID_",strings);
            }

           if(null != timeGrateThan && null != timeLessThan){
               queryWrapper.between("CHECK_DATE_",timeGrateThan,timeLessThan);
           }


            List<BridgeOftenCheck> bridgeOftenChecks = bridgeOftenCheckManager.list(queryWrapper);
            if(null == bridgeOftenChecks || bridgeOftenChecks.size() == 0){
                throw new RuntimeException("该桥梁暂无经常检查记录");

            }

        try {

            //查询桥梁经常检查字典
            Map<String, List<SysDictionaryDetail>> qljcmxb = sysDictionaryManager.queryDictItemsByCode("qljcmxb");
            Map<String, List<SysDictionaryDetail>> qljcmxblsq = sysDictionaryManager.queryDictItemsByCode("qljcmxblsq");
            //查询桥梁信息

            bridgeOftenChecks.forEach(bridgeOftenCheck -> {
                BridgeInformation bridge = bridgeInformationManager.getBridgeById(bridgeOftenCheck.getBrigeId());
                Road road = roadManager.getById(bridge.getRoadSegmentId());

                        //查询检查信息
                        HSSFWorkbook workbook = new HSSFWorkbook();
                        HSSFCellStyle cellStyle = workbook.createCellStyle();
                        HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
                        setExcelStyle(cellStyle, workbook);
                        HSSFSheet sheet = workbook.createSheet("桥梁经常检查记录表");
                        sheet.getPrintSetup().setPaperSize(HSSFPrintSetup.A4_PAPERSIZE);
                        if (bridgeOftenCheck != null) {
                            if (bridge.getBriShape() == null || bridge.getBriShape() == 1) {
                                exportBeamBridgeData(file, bridge, road, bridgeOftenCheck, workbook, cellStyle, cellStyleTitle, sheet);
                            }
                            if (bridge.getBriShape() != null && bridge.getBriShape() == 10) {
                                exportBriCableStayedData(file, bridge, road, bridgeOftenCheck, workbook, cellStyle, cellStyleTitle, sheet);
                            }


                        } else {
                            if (bridge.getBriShape() == null || bridge.getBriShape() == 1) {
                                exportBeamBridge(file, qljcmxblsq, bridge, road, workbook, cellStyle, cellStyleTitle, sheet);
                            }
                            if (bridge.getBriShape() != null && bridge.getBriShape() == 10) {
                                exportBriCableStayed(file, qljcmxb, bridge, road, workbook, cellStyle, cellStyleTitle, sheet);
                            }

                        }
                    }
            );
            this.zip(fileName, true);
            String zip = fileName + ".zip";

            HttpUtil.downLoadFile(response, zip, zip);
            // 删除导出的文件
            FileUtil.deleteFile(zip);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }

    @Override
    public void exportTunnelOftenHistory(String id, String ids, Date timeGrateThan, Date timeLessThan, HttpServletResponse response){
        try {
            long time = System.currentTimeMillis();
            String fileName = "隧道经常检查记录表" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (StringUtils.isEmpty(id)) {
                throw new RuntimeException("隧道id不能为空");
            }



            Map<String, List<SysDictionaryDetail>> qljcmxb = sysDictionaryManager.queryDictItemsByCode("sdsdjcjc");


            QueryWrapper<TunnelOftenCheck> queryWrapper = new QueryWrapper<TunnelOftenCheck>();

            List<String> tunnelIds = Arrays.asList(id.split(","));
            queryWrapper.in("TUNNEL_ID_",tunnelIds);

            if (null!=ids && !ids.equals("")){
                List<String> strings = Arrays.asList(ids.split(","));
                queryWrapper.in("ID_",strings);
            }

            if(null != timeGrateThan && null != timeLessThan){
                queryWrapper.between("CHECK_DATE_",timeGrateThan,timeLessThan);
            }


            List<TunnelOftenCheck> list = tunnelOftenCheckManager.list(queryWrapper);

            if(null == list || list.size() == 0){
                throw new RuntimeException("该隧道暂无经常检查记录");

            }


            list.forEach(tunnelOftenCheck -> {
                TunnelInformation tunnel = tunnelInformationManager.getTunnelById(tunnelOftenCheck.getTunnelId());
                //根据隧道信息查询路段
                Road road = roadManager.getById(tunnel.getRoadSegmentId());
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                setExcelStyle(cellStyle, workbook);
                HSSFCellStyle cellStyleTitle = workbook.createCellStyle();

                HSSFSheet sheet = workbook.createSheet("隧道经常检查记录表");
                sheet.getPrintSetup().setPaperSize(HSSFPrintSetup.A4_PAPERSIZE);
                sheet.setColumnWidth(0, 10 * 256);
                sheet.setColumnWidth(1, 10 * 256);
                sheet.setColumnWidth(2, 30 * 256);
                sheet.setColumnWidth(3, 8 * 256);
                sheet.setColumnWidth(4, 6 * 256);
                sheet.setColumnWidth(5, 5 * 256);
                sheet.setColumnWidth(6, 5 * 256);
                sheet.setColumnWidth(7, 5 * 256);
                if (tunnelOftenCheck != null) {
                    exportTunnelData(tunnel, road, tunnelOftenCheck, workbook, cellStyle, cellStyleTitle, sheet);
                    try {
                        OutputStream os = new FileOutputStream(file + "/" + tunnel.getName() + "-" + tunnel.getNumber() + "-" + tunnel.getDirectionValue() +"-"+new SimpleDateFormat("yyyy-MM-dd").format(tunnelOftenCheck.getCheckDate()) + ".xls");
                        workbook.write(os);
                        os.flush();
                        os.close();
                    } catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException("导出列表失败！");
                    }
                } else {
                    exportTunnel(qljcmxb, tunnel, road, workbook, cellStyle, cellStyleTitle, sheet);
                    try {
                        OutputStream os = new FileOutputStream(file + "/" + tunnel.getName() + "-" + tunnel.getNumber() + "-" + tunnel.getDirectionValue() + System.currentTimeMillis() + ".xls");
                        workbook.write(os);
                        os.flush();
                        os.close();
                    } catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException("导出列表失败！");
                    }
                }

            });
            this.zip(fileName, true);
            String zip = fileName + ".zip";

            HttpUtil.downLoadFile(response, zip, zip);
            // 删除导出的文件
            FileUtil.deleteFile(zip);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }

    @Override
    public void exportCulvertOftenHistory(String id, String ids, Date timeGrateThan, Date timeLessThan, HttpServletResponse response){
        try {
            long time = System.currentTimeMillis();
            String fileName = "涵洞经常检查记录表" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (StringUtils.isEmpty(id)) {
                throw new RuntimeException("涵洞id不能为空");
            }

            //查询涵洞经常检查字典
            Map<String, List<SysDictionaryDetail>> hdjcjcmx = sysDictionaryManager.queryDictItemsByCode("hdjcjcmx");
            QueryWrapper<CulvertOftenCheck> queryWrapper = new QueryWrapper<CulvertOftenCheck>();

            List<String> culvertIds = Arrays.asList(id.split(","));
            queryWrapper.in("CULVERT_ID_",culvertIds);

            if (null!=ids && !ids.equals("")){
                List<String> strings = Arrays.asList(ids.split(","));
                queryWrapper.in("ID_",strings);
            }

            if(null != timeGrateThan && null != timeLessThan){
                queryWrapper.between("CHECK_DATE_",timeGrateThan,timeLessThan);
            }


            List<CulvertOftenCheck> culvertOftenCheckList = culvertOftenCheckManager.list(queryWrapper);

            if(null == culvertOftenCheckList || culvertOftenCheckList.size() == 0){
                throw new RuntimeException("该涵洞暂无经常检查记录");

            }

            Map<String, CulvertOftenCheck> checkMap = StreamUtil.toMap(culvertOftenCheckList,CulvertOftenCheck::getId);
            Map<String, List<CulvertOftenCheck>> detailMap = culvertOftenCheckList.stream().collect(Collectors.groupingBy(CulvertOftenCheck::getCulvertId));

            for (Map.Entry<String, List<CulvertOftenCheck>> entry : detailMap.entrySet()) {
                List<CulvertOftenCheck> checks = entry.getValue();

                List<String> stringIds = checks.stream().sorted(Comparator.comparing(CulvertOftenCheck::getCulvertId)).map(CulvertOftenCheck::getId).collect(Collectors.toList());

                List<List<String>> collect = IntStream.range(0, (stringIds.size() + 3 - 1) / 3)
                        .map(pageNum -> pageNum * 3).parallel()
                        .mapToObj(i -> stringIds.stream().skip(i).limit(3).collect(Collectors.toList()))
                        .collect(Collectors.toList());

                for (List<String> stringList : collect) {
                    HSSFWorkbook workbook = new HSSFWorkbook();
                    HSSFCellStyle cellStyle = workbook.createCellStyle();
                    setExcelStyle(cellStyle, workbook);
                    HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
                    setExcelStyle(cellStyle, workbook);
                    HSSFSheet sheet = workbook.createSheet("涵洞经常检查记录表");
                    sheet.getPrintSetup().setPaperSize(HSSFPrintSetup.A4_PAPERSIZE);
                    sheet.setColumnWidth(0, 10 * 256);
                    sheet.setColumnWidth(1, 10 * 256);
                    sheet.setColumnWidth(2, 10 * 256);
                    sheet.setColumnWidth(3, 8 * 256);
                    sheet.setColumnWidth(4, 6 * 256);
                    sheet.setColumnWidth(5, 4 * 256);
                    sheet.setColumnWidth(6, 8 * 256);
                    sheet.setColumnWidth(7, 8 * 256);
                    sheet.setColumnWidth(8, 8 * 256);
                    sheet.setColumnWidth(9, 8 * 256);
                    int rowIndex = 0;



                    String numberCode ="涵洞经常检查记录表";
                    String dateStr ="";

                    for (String s : stringList) {
                        //查询最新一次的检查信息
                        CulvertOftenCheck culvertOftenCheck = checkMap.get(s);
                        if (culvertOftenCheck != null) {
                            //查询涵洞信息
                            BizCulvertInformation culvert = culvertInformationManager.getById(culvertOftenCheck.getCulvertId());
                            //根据桥梁信息查询路段
                            Road road = roadManager.getById(culvert.getRoadSegmentId());

                            List<CulvertOftenCheckDetail> list = culvertOftenCheckDetailManager.list(new QueryWrapper<CulvertOftenCheckDetail>().lambda().eq(CulvertOftenCheckDetail::getCulvertOftenCheckId, culvertOftenCheck.getId()));
                            HSSFRow row0 = sheet.createRow(rowIndex);
                            HSSFCell cell24 = row0.createCell(0);
                            cell24.setCellValue("涵洞经常检查记录表");
                            cell24.setCellStyle(cellStyleTitle);
                            setExcelStyleTitle(cellStyleTitle, workbook);
                            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 0, 9));
                            HSSFRow row1 = sheet.createRow(++rowIndex);
                            HSSFCell cell = row1.createCell(0);
                            cell.setCellStyle(cellStyle);
                            cell.setCellValue("路线名称:");
                            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 1, 4));
                            HSSFCell cell1 = row1.createCell(1);
                            cell1.setCellStyle(cellStyle);
                            cell1.setCellValue(road.getName());
                            HSSFCell cell2 = row1.createCell(6);
                            cell2.setCellStyle(cellStyle);
                            cell2.setCellValue("路线编码:");
                            HSSFCell cell3 = row1.createCell(7);
                            row1.createCell(2).setCellStyle(cellStyle);
                            row1.createCell(3).setCellStyle(cellStyle);
                            row1.createCell(4).setCellStyle(cellStyle);
                            row1.createCell(5).setCellStyle(cellStyle);
                            row1.createCell(8).setCellStyle(cellStyle);
                            row1.createCell(9).setCellStyle(cellStyle);
                            cell3.setCellStyle(cellStyle);
                            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 7, 9));
                            cell3.setCellValue(road.getCode());
                            HSSFRow row2 = sheet.createRow(++rowIndex);
                            HSSFCell cell4 = row2.createCell(0);
                            cell4.setCellStyle(cellStyle);
                            cell4.setCellValue("涵洞桩号");
                            HSSFCell cell5 = row2.createCell(1);
                            cell5.setCellStyle(cellStyle);
                            cell5.setCellValue("涵洞类型");
                            HSSFCell cell6 = row2.createCell(2);
                            cell6.setCellStyle(cellStyle);
                            cell6.setCellValue("检查日期");
                            HSSFCell cell7 = row2.createCell(3);
                            cell7.setCellStyle(cellStyle);
                            cell7.setCellValue("检查人");
                            HSSFCell cell8 = row2.createCell(4);
                            cell8.setCellStyle(cellStyle);
                            cell8.setCellValue("记录人");
                            HSSFCell cell9 = row2.createCell(5);
                            cell9.setCellStyle(cellStyle);
                            cell9.setCellValue("总体评价");
                            HSSFCell cell10 = row2.createCell(6);
                            cell10.setCellStyle(cellStyle);
                            cell10.setCellValue("检查内容");
                            HSSFCell cell11 = row2.createCell(7);
                            cell11.setCellStyle(cellStyle);
                            cell11.setCellValue("状态描述");
                            HSSFCell cell12 = row2.createCell(8);
                            cell12.setCellStyle(cellStyle);
                            cell12.setCellValue("判断结论");
                            HSSFCell cell13 = row2.createCell(9);
                            cell13.setCellStyle(cellStyle);
                            cell13.setCellValue("处理措施");
                            row0.setHeight((short) (25 * 20));
                            row1.setHeight((short) (20 * 20));
                            row2.setHeight((short) (20 * 20));
                            Integer rowIndexFor = rowIndex + 1;
                            if (list.size() > 0) {
                                for (int i = 0; i < list.size(); i++) {
                                    HSSFRow row4 = sheet.createRow(rowIndexFor + i);
                                    CulvertOftenCheckDetail culvertOftenCheckDetail = list.get(i);
                                    HSSFCell cell14 = row4.createCell(6);
                                    cell14.setCellStyle(cellStyle);
                                    cell14.setCellValue(culvertOftenCheckDetail.getCheckProject());
                                    HSSFCell cell15 = row4.createCell(7);
                                    cell15.setCellStyle(cellStyle);
                                    cell15.setCellValue(culvertOftenCheckDetail.getStatusDesc());
                                    HSSFCell cell16 = row4.createCell(8);
                                    cell16.setCellStyle(cellStyle);
                                    cell16.setCellValue(culvertOftenCheckDetail.getResult());
                                    HSSFCell cell17 = row4.createCell(9);
                                    cell17.setCellStyle(cellStyle);
                                    cell17.setCellValue(culvertOftenCheckDetail.getProcess());
                                    row4.setHeight((short) (15 * 20));
                                    if (i == 0) {
                                        rowIndex++;

                                        HSSFCell cell18 = row4.createCell(0);
                                        cell18.setCellValue(culvert.getCentPeg());
                                        cell18.setCellStyle(cellStyle);
                                        HSSFCell cell19 = row4.createCell(1);
                                        cell19.setCellValue(culvert.getTypeValue());
                                        cell19.setCellStyle(cellStyle);
                                        HSSFCell cell20 = row4.createCell(2);
                                        cell20.setCellValue(new SimpleDateFormat("yyyy/MM/dd").format(culvertOftenCheck.getCheckDate()));
                                        cell20.setCellStyle(cellStyle);
                                        HSSFCell cell21 = row4.createCell(3);
                                        cell21.setCellValue(culvertOftenCheck.getRummager());
                                        cell21.setCellStyle(cellStyle);
                                        HSSFCell cell22 = row4.createCell(4);
                                        cell22.setCellValue(culvertOftenCheck.getNoteTaker());
                                        cell22.setCellStyle(cellStyle);
                                        HSSFCell cell23 = row4.createCell(5);
                                        cell23.setCellValue(culvertOftenCheck.getEvaluateValue());
                                        cell23.setCellStyle(cellStyle);
                                    } else {
                                        row4.createCell(0).setCellStyle(cellStyle);
                                        row4.createCell(1).setCellStyle(cellStyle);
                                        row4.createCell(2).setCellStyle(cellStyle);
                                        row4.createCell(3).setCellStyle(cellStyle);
                                        row4.createCell(4).setCellStyle(cellStyle);
                                        row4.createCell(5).setCellStyle(cellStyle);
                                        rowIndex++;
                                    }

                                }
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 0, 0));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 1, 1));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 2, 2));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 3, 3));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 4, 4));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 5, 5));
                                rowIndex++;
                            } else {
                                List<SysDictionaryDetail> listDict = hdjcjcmx.get("hdjcjcmx");
                                for (int i = 0; i < listDict.size(); i++) {
                                    HSSFRow row4 = sheet.createRow(rowIndexFor + i);
                                    Map map = (Map) listDict.get(i);
                                    SysDictionaryDetail detail = BeanUtil.toBean(map, SysDictionaryDetail.class);
                                    HSSFCell cell14 = row4.createCell(6);
                                    cell14.setCellStyle(cellStyle);
                                    cell14.setCellValue(detail.getName());
                                    HSSFCell cell15 = row4.createCell(7);
                                    cell15.setCellStyle(cellStyle);
                                    HSSFCell cell16 = row4.createCell(8);
                                    cell16.setCellStyle(cellStyle);
                                    row4.setHeight((short) (15 * 20));
                                    HSSFCell cell17 = row4.createCell(9);
                                    cell17.setCellStyle(cellStyle);

                                    if (i == 0) {
                                        HSSFCell cell18 = row4.createCell(0);
                                        cell18.setCellValue(culvert.getCentPeg());
                                        cell18.setCellStyle(cellStyle);
                                        HSSFCell cell19 = row4.createCell(1);
                                        cell19.setCellValue(culvert.getTypeValue());
                                        cell19.setCellStyle(cellStyle);
                                        HSSFCell cell20 = row4.createCell(2);

                                        cell20.setCellStyle(cellStyle);
                                        HSSFCell cell21 = row4.createCell(3);

                                        cell21.setCellStyle(cellStyle);
                                        HSSFCell cell22 = row4.createCell(4);

                                        cell22.setCellStyle(cellStyle);
                                        HSSFCell cell23 = row4.createCell(5);

                                        cell23.setCellStyle(cellStyle);
                                    } else {
                                        row4.createCell(0).setCellStyle(cellStyle);
                                        row4.createCell(1).setCellStyle(cellStyle);
                                        row4.createCell(2).setCellStyle(cellStyle);
                                        row4.createCell(3).setCellStyle(cellStyle);
                                        row4.createCell(4).setCellStyle(cellStyle);
                                        row4.createCell(5).setCellStyle(cellStyle);
                                    }

                                    rowIndex++;
                                }
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 0, 0));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 1, 1));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 2, 2));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 3, 3));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 4, 4));
                                sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 5, 5));
                                rowIndex++;
                            }

                            dateStr = new SimpleDateFormat("yyyy-MM-dd").format(culvertOftenCheck.getCheckDate());
                            numberCode = culvert.getCentPeg();

                        } else {
                            HSSFRow row0 = sheet.createRow(rowIndex);
                            HSSFCell cell24 = row0.createCell(0);
                            cell24.setCellValue("涵洞经常检查记录表");
                            cell24.setCellStyle(cellStyleTitle);
                            setExcelStyleTitle(cellStyleTitle, workbook);
                            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 0, 9));
                            HSSFRow row1 = sheet.createRow(++rowIndex);
                            HSSFCell cell = row1.createCell(0);
                            cell.setCellStyle(cellStyle);
                            cell.setCellValue("路线名称:");
                            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 1, 4));
                            HSSFCell cell1 = row1.createCell(1);
                            cell1.setCellStyle(cellStyle);
//                        cell1.setCellValue(road.getName());
                            HSSFCell cell2 = row1.createCell(6);
                            cell2.setCellStyle(cellStyle);
                            cell2.setCellValue("路线编码:");
                            HSSFCell cell3 = row1.createCell(7);

                            row1.createCell(2).setCellStyle(cellStyle);
                            row1.createCell(3).setCellStyle(cellStyle);
                            row1.createCell(4).setCellStyle(cellStyle);
                            row1.createCell(5).setCellStyle(cellStyle);
                            row1.createCell(8).setCellStyle(cellStyle);
                            row1.createCell(9).setCellStyle(cellStyle);
                            cell3.setCellStyle(cellStyle);
                            sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 7, 9));
//                        cell3.setCellValue(road.getCode());
                            HSSFRow row2 = sheet.createRow(++rowIndex);
                            HSSFCell cell4 = row2.createCell(0);
                            cell4.setCellStyle(cellStyle);
                            cell4.setCellValue("涵洞桩号");
                            HSSFCell cell5 = row2.createCell(1);
                            cell5.setCellStyle(cellStyle);
                            cell5.setCellValue("涵洞类型");
                            HSSFCell cell6 = row2.createCell(2);
                            cell6.setCellStyle(cellStyle);
                            cell6.setCellValue("检查日期");
                            HSSFCell cell7 = row2.createCell(3);
                            cell7.setCellStyle(cellStyle);
                            cell7.setCellValue("检查人");
                            HSSFCell cell8 = row2.createCell(4);
                            cell8.setCellStyle(cellStyle);
                            cell8.setCellValue("记录人");
                            HSSFCell cell9 = row2.createCell(5);
                            cell9.setCellStyle(cellStyle);
                            cell9.setCellValue("总体评价");
                            HSSFCell cell10 = row2.createCell(6);
                            cell10.setCellStyle(cellStyle);
                            cell10.setCellValue("检查内容");
                            HSSFCell cell11 = row2.createCell(7);
                            cell11.setCellStyle(cellStyle);
                            cell11.setCellValue("状态描述");
                            HSSFCell cell12 = row2.createCell(8);
                            cell12.setCellStyle(cellStyle);
                            cell12.setCellValue("判断结论");
                            HSSFCell cell13 = row2.createCell(9);
                            cell13.setCellStyle(cellStyle);
                            cell13.setCellValue("处理措施");
                            row0.setHeight((short) (25 * 20));
                            row1.setHeight((short) (20 * 20));
                            row2.setHeight((short) (20 * 20));
                            Integer rowIndexFor = rowIndex + 1;
                            List<SysDictionaryDetail> list = hdjcjcmx.get("hdjcjcmx");
                            for (int i = 0; i < list.size(); i++) {
                                HSSFRow row4 = sheet.createRow(rowIndexFor + i);
                                Map map = (Map) list.get(i);
                                SysDictionaryDetail detail = BeanUtil.toBean(map, SysDictionaryDetail.class);
                                HSSFCell cell14 = row4.createCell(6);
                                cell14.setCellStyle(cellStyle);
                                cell14.setCellValue(detail.getName());
                                HSSFCell cell15 = row4.createCell(7);
                                cell15.setCellStyle(cellStyle);
                                HSSFCell cell16 = row4.createCell(8);
                                cell16.setCellStyle(cellStyle);
                                row4.setHeight((short) (15 * 20));
                                HSSFCell cell17 = row4.createCell(9);
                                cell17.setCellStyle(cellStyle);

                                if (i == 0) {
                                    HSSFCell cell18 = row4.createCell(0);
//                                cell18.setCellValue(culvert.getCentPegK());
                                    cell18.setCellStyle(cellStyle);
                                    HSSFCell cell19 = row4.createCell(1);
//                                cell19.setCellValue(culvert.getTypeValue());
                                    cell19.setCellStyle(cellStyle);
                                    HSSFCell cell20 = row4.createCell(2);

                                    cell20.setCellStyle(cellStyle);
                                    HSSFCell cell21 = row4.createCell(3);

                                    cell21.setCellStyle(cellStyle);
                                    HSSFCell cell22 = row4.createCell(4);

                                    cell22.setCellStyle(cellStyle);
                                    HSSFCell cell23 = row4.createCell(5);

                                    cell23.setCellStyle(cellStyle);
                                } else {
                                    row4.createCell(0).setCellStyle(cellStyle);
                                    row4.createCell(1).setCellStyle(cellStyle);
                                    row4.createCell(2).setCellStyle(cellStyle);
                                    row4.createCell(3).setCellStyle(cellStyle);
                                    row4.createCell(4).setCellStyle(cellStyle);
                                    row4.createCell(5).setCellStyle(cellStyle);
                                }

                                rowIndex++;
                            }
                            sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 0, 0));
                            sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 1, 1));
                            sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 2, 2));
                            sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 3, 3));
                            sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 4, 4));
                            sheet.addMergedRegion(new CellRangeAddress(rowIndexFor, rowIndex, 5, 5));
                            rowIndex++;
                        }
                    }
                    try {
                        OutputStream os = new FileOutputStream(file+"/" + "涵洞经常检查记录表" + numberCode + "-" +dateStr+ ".xls");
                        workbook.write(os);
                        os.flush();
                        os.close();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }


                }
            }
            //exportCulvert(file, hdjcjcmx, strings);

            this.zip(fileName, true);
            String zip = fileName + ".zip";

            HttpUtil.downLoadFile(response, zip, zip);
            // 删除导出的文件
            FileUtil.deleteFile(zip);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }

    @Override
    public void exportSideSlopeOftenHistory(String id, String ids, Date timeGrateThan, Date timeLessThan, HttpServletResponse response){
        try {
            long time = System.currentTimeMillis();
            String fileName = "边坡经常检查" + time;
            File file = new File(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            Map<String, List<SysDictionaryDetail>> bpjcjcmx = sysDictionaryManager.queryDictItemsByCode("bpjcjcmx");
            Map<String, List<SysDictionaryDetail>> fx = sysDictionaryManager.queryDictItemsByCode(FX);


            QueryWrapper<SideSlopeOftenCheck> queryWrapper = new QueryWrapper<>();



            List<String> sideIds = Arrays.asList(id.split(","));
            queryWrapper.in("SIDE_SLOPE_ID_",sideIds);

            if (null!=ids && !ids.equals("")){
                List<String> strings = Arrays.asList(id.split(","));
                queryWrapper.in("ID_",strings);
            }

            if(null != timeGrateThan && null != timeLessThan){
                queryWrapper.between("CHECK_DATE_",timeGrateThan,timeLessThan);
            }


            List<SideSlopeOftenCheck> SideSlopeOftenCheckList = sideSlopeOftenCheckManager.list(queryWrapper);

            if(null == SideSlopeOftenCheckList || SideSlopeOftenCheckList.size() == 0){
                throw new BaseException("该边坡暂无经常检查记录");
            }
            SideSlopeOftenCheckList.forEach(sideSlopeOftenCheck -> {
                SideSlopeInformation sideSlope = sideSlopeInformationManager.getById(sideSlopeOftenCheck.getSideSlopeId());
                Road road = roadManager.getById(sideSlope.getRoadSegmentId());
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFCellStyle cellStyle = workbook.createCellStyle();
                setExcelStyle(cellStyle, workbook);
                HSSFCellStyle cellStyleTitle = workbook.createCellStyle();

                HSSFSheet sheet = workbook.createSheet("边坡经常检查记录表");
                sheet.getPrintSetup().setPaperSize(HSSFPrintSetup.A4_PAPERSIZE);
                sheet.setColumnWidth(0, 20 * 256);
                sheet.setColumnWidth(1, 10 * 256);
                sheet.setColumnWidth(2, 10 * 256);
                sheet.setColumnWidth(3, 15 * 256);
                sheet.setColumnWidth(4, 9 * 256);
                sheet.setColumnWidth(5, 20 * 256);
                //sheet.setColumnWidth(6, 10 * 256);
                if (sideSlopeOftenCheck != null) {
                    exportSideSlopData(file, sideSlope, road, sideSlopeOftenCheck, workbook, cellStyle, cellStyleTitle, sheet,fx);
                } else {
                    exportSideSlop(file, bpjcjcmx, sideSlope, road, workbook, cellStyle, cellStyleTitle, sheet,fx);
                }
            });
            this.zip(fileName, true);
            String zip = fileName + ".zip";

            HttpUtil.downLoadFile(response, zip, zip);
            // 删除导出的文件
            FileUtil.deleteFile(zip);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("导出列表失败！");
        }
    }


    //设置边框
    private void setExcelStyle(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setWrapText(true);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short) 8);
        cellStyle.setFont(font);
    }

    //标题
    private void setExcelStyleTitle(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short) 18);
        cellStyle.setFont(font);
    }

    /**
     * 压缩文件
     *
     * @param path     压缩文件\文件夹路径
     * @param isDelete 压缩后是否删除原文件\文件夹
     */
    private void zip(String path, Boolean isDelete) {
        ZipFile zipFile = null;
        try {
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(Zip4jConstants.COMP_DEFLATE);
            parameters.setCompressionLevel(Zip4jConstants.DEFLATE_LEVEL_NORMAL);
            File file = new File(path);
            Assert.isTrue(file.exists(), "文件不存在");
            ArrayList<String> list = new ArrayList<>();
            if (file.isDirectory()) {
                zipFile = new ZipFile(new File(path + ".zip"));
                zipFile.setFileNameCharset("GBK");
                zipFile.addFolder(path, parameters);
            } else {
                zipFile = new ZipFile(new File(path.split(".")[0] + ".zip"));
                zipFile.setFileNameCharset("GBK");
                zipFile.addFile(file, parameters);
            }
            if (isDelete) {
                FileUtil.deleteDir(file);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //拼接管理中心名称
    private String getCompany(String officeName) {
        return officeName;
    }
}
