package com.artfess.yhxt.check.regular.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.check.regular.model.TunnelRegularCheck;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.check.regular.vo.TunnelRegularCheckVo;
import org.springframework.web.multipart.MultipartFile;

/**
 * 隧道定期检查表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-17
 */
public interface TunnelRegularCheckManager extends BaseManager<TunnelRegularCheck> {

    PageList<TunnelRegularCheck> queryTunnelRegularCheck(QueryFilter<TunnelRegularCheck> queryFilter);

    /**
     * 保存定期检查  定期检查明细
     * @param vo 隧道定期检查和明细vo
     */
    void saveTunnelRegularCheck(TunnelRegularCheckVo vo);

    /**
     * 修改定期检查  定期检查明细
     * @param vo 隧道定期检查和明细vo
     */
    void updateTunnelRegularCheck(TunnelRegularCheckVo vo);

    /**
     * 根据id获取定期检查  定期检查明细
     * @param id 定期检查ID
     * @return TunnelRegularCheckVo
     */
    TunnelRegularCheckVo getTunnelRegularCheckById(String id);

    void importExcelData(MultipartFile file, TunnelRegularCheck parseObject);
}
