package com.artfess.yhxt.check.regular.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.check.regular.model.SideSlopeOftenCheck;
import com.artfess.yhxt.check.regular.vo.SideSlopeOftenCheckVo;
import org.springframework.web.multipart.MultipartFile;

/**
 * 边坡经常检查表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-05
 */
public interface SideSlopeOftenCheckManager extends BaseManager<SideSlopeOftenCheck> {

    /**
     * 分页不分页查询
     * @param queryFilter
     * @return
     */
    PageList<SideSlopeOftenCheck> querySideSlopeOftenCheck(QueryFilter<SideSlopeOftenCheck> queryFilter);

    /**
     * 保存边坡经常检查信息
     * @param vo
     */
    void saveSideSlopeOftenCheck(SideSlopeOftenCheckVo vo);

    /**
     * 修改边坡经常检查信息
     * @param vo
     */
    void updateSideSlopeOftenCheck(SideSlopeOftenCheckVo vo);

    /**
     * 根据id查询边坡详细信息
     * @param id
     * @return
     */
    SideSlopeOftenCheckVo getSideSlopeOftenCheck(String id);

    void importExcelData(MultipartFile file, SideSlopeOftenCheck parseObject);
}
