package com.artfess.yhxt.budget.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.budget.model.YearBudget;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.budget.vo.YearBudgetVo;
import com.artfess.yhxt.statistics.vo.Org4BudgetVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 年度总预算表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-02
 */
public interface YearBudgetManager extends BaseManager<YearBudget> {

    /**
     * 检查年度预算是否已经添加
     * @param yearBudget
     */
    void checkYear(YearBudget yearBudget);

    /**
     * 根据ID查询
     * @param id
     * @return
     */
    YearBudget getYearBudgetById(String id);

    /**
     * 根据年份修改已用总额
     * @param bigDecimal 已用总额
     * @param ascriptionYear 年份
     */
    void updateYear(BigDecimal bigDecimal, Integer ascriptionYear);

    PageList<YearBudget> queryYearBuget(QueryFilter<YearBudget> queryFilter);

    /**
     * 根据ID查询 预算 和预算明细
     * @param id
     * @return
     */
    YearBudgetVo getYearBudgetVoById(String id);

    /**
     * 保存预算和明细
     * @param yearBudgetVo
     */
    void saveYearBudgetVo(YearBudgetVo yearBudgetVo);

    /**
     * 修改预算和明细
     * @param yearBudgetVo
     */
    void updateYearBudgetVo(YearBudgetVo yearBudgetVo);

    List<Org4BudgetVO> getBudgetCount(String year);
}
