package com.artfess.yhxt.basedata.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 应急物资库管理
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xmz
 * @since 2022-04-19
 */
@ApiModel(value="BizEmergeMaterialManagement对象", description="应急物资库管理")
@TableName("biz_emerge_material_management")
@Data
public class BizEmergeMaterialManagement extends BaseModel<BizEmergeMaterialManagement> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "应急物资库名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "人员数量")
    @TableField("PERSONNEL_QUANTITY_")
    private Integer personnelQuantity;

    @ApiModelProperty(value = "应急物资库所在位置")
    @TableField("LOCATION_MAINTENANCE_AREA_")
    private String locationMaintenanceArea;

    @ApiModelProperty(value = "经度")
    @TableField("LNG")
    private Double lng;

    @ApiModelProperty(value = "纬度")
    @TableField("LAT")
    private Double lat;

    @ApiModelProperty(value = "主线桩号")
    @TableField("CENT_PEG_K_")
    private String centPegK;

    @ApiModelProperty(value = "所在路段id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;



}
