package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.query.*;
import com.artfess.base.util.DateUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.dao.BridgeInformationDao;
import com.artfess.yhxt.basedata.manager.*;
import com.artfess.yhxt.basedata.model.*;
import com.artfess.base.manager.impl.BaseManagerImpl;

import com.artfess.uc.api.model.IUser;
import com.artfess.yhxt.basedata.vo.BridgeCheckVo;
import com.artfess.yhxt.basedata.vo.BridgeRegularVo;
import com.artfess.yhxt.budget.model.YearBudget;
import com.artfess.yhxt.budget.model.YearBudgetDetailed;
import com.artfess.yhxt.check.regular.dao.BridgeOftenCheckDao;
import com.artfess.yhxt.check.regular.dao.BridgeRegularCheckDao;
import com.artfess.yhxt.check.regular.manager.BridgeOftenCheckManager;
import com.artfess.yhxt.check.regular.model.BridgeOftenCheck;
import com.artfess.yhxt.check.regular.model.BridgeRegularCheck;
import com.artfess.yhxt.statistics.dao.WorkbenchDao;
import com.artfess.yhxt.statistics.vo.Org4BridgeVO;
import com.artfess.yhxt.statistics.vo.Org4BudgetVO;
import com.artfess.yhxt.statistics.vo.Org4RoadVO;
import com.artfess.yhxt.statistics.vo.Org4bridgeInfoVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 桥梁信息表 服务实现类
 *
 * @author 向贞好
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-07-27
 */
@Service
public class BridgeInformationManagerImpl extends BaseManagerImpl<BridgeInformationDao, BridgeInformation> implements BridgeInformationManager {

    @Resource
    private BridgeOftenCheckDao checkDao;
    @Resource
    private BridgeRegularCheckDao bridgeRegularCheckDao;
    @Resource
    BaseContext baseContext;
    @Resource
    private AccessoryManager accessoryManager;
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    OrgManager orgManager;
    @Resource
    WorkbenchDao workbenchDao;
    @Resource
    MigrantBuildersInformationManager migrantBuildersInformationManager;

    @Resource
    private OrgDao orgDao;

    @Resource
    private RoadManager roadManager;

    @Resource
    private BizRoadsideFacilitiesManager bizRoadsideFacilitiesManager;

    @Resource
    private TunnelInformationManager tunnelInformationManager;

    @Resource
    private BizVehicleManager bizVehicleManager;

    @Resource
    private BizMaintenanceWorkAreaManager bizMaintenanceWorkAreaManager;

    @Resource
    private BizCulvertInformationManager bizCulvertInformationManager;


    @Override
    public List<Org4bridgeInfoVO> getBridgeInfoCount() {
        String orgId ;
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())&&!"0".equals(baseContext.getCurrentOrgId())){
            orgId = baseContext.getCurrentOrgId();
        }else {
            orgId = "1419863231459102720";
        }
        List<Org4bridgeInfoVO> lists = new ArrayList<>();

        List<Org> rtnList = new ArrayList<Org>();

        QueryWrapper<Org> rgQueryWrapper = new QueryWrapper<>();
        rgQueryWrapper.eq("is_dele_","0");
        List<Org> allList = orgDao.selectList(rgQueryWrapper);

        List<Org> list = getOrgChild(allList, orgId, rtnList);
        for (Org org: list){
            Org4bridgeInfoVO fvo = new Org4bridgeInfoVO();
            BeanUtils.copyProperties(org,fvo);
            lists.add(fvo);
        }
        lists = getChild4Bridge(lists,orgId);


        return this.setCount4Bridge(lists);
    }


    public static List<Org4bridgeInfoVO> getChild4Bridge(List<Org4bridgeInfoVO> allList, String pCode) {
        List<Org4bridgeInfoVO> returnList = new ArrayList<>();
        for (Org4bridgeInfoVO entity : allList){
            if (pCode.equals(entity.getParentId())) {
                entity.setChirldren(getChild4Bridge(allList, entity.getId()));
                returnList.add(entity);
            }
        }
        return returnList;
    }


    public List<Org4bridgeInfoVO> setCount4Bridge(List<Org4bridgeInfoVO> list){

        // 获取迭代器
        Iterator<Org4bridgeInfoVO> it = list.iterator();

        while(it.hasNext()){
            Org4bridgeInfoVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<>();
            if (grade<4){
                QueryWrapper<Road> roadQueryWrapper = new QueryWrapper<>();
                roadQueryWrapper.like( "COMPANY_IDS_", orgVO.getId());
                roadList = roadManager.list(roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }else if (grade==4){
                QueryWrapper<Road> roadByNameQueryWrapper = new QueryWrapper<>();
                roadByNameQueryWrapper.eq("NAME_",orgVO.getName());
                roadList =
                        roadManager.list(roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size()>0){
                orgVO = this.newCountBridge(roadList,orgVO);
            }else {
                it.remove();
            }
            if (orgVO.getChirldren().size()>0&&Integer.valueOf(orgVO.getGrade())<4){
                this.setCount4Bridge(orgVO.getChirldren());
            }
        }
        return list;
    }

    //统计表格
    public Org4bridgeInfoVO newCountBridge(List<String> ids, Org4bridgeInfoVO orgVO) {

        QueryWrapper<BridgeInformation> bridgeWrapper = new QueryWrapper<>();
        bridgeWrapper.in("ROAD_SEGMENT_ID_", ids);
        bridgeWrapper.eq("IS_DELE_",0);
        List<BridgeInformation> bridges = this.list(bridgeWrapper);

        //特大桥
        List<BridgeInformation> biggestList =
                bridges.stream().filter(bridgeInformation -> Objects.equals(bridgeInformation.getType(),"1")).collect(Collectors.toList());

        List<BridgeInformation> biggerList =
                bridges.stream().filter(bridgeInformation -> Objects.equals(bridgeInformation.getType(),"2")).collect(Collectors.toList());

        List<BridgeInformation> bigList =
                bridges.stream().filter(bridgeInformation -> Objects.equals(bridgeInformation.getType(),"3")).collect(Collectors.toList());

        List<BridgeInformation> smallList =
                bridges.stream().filter(bridgeInformation -> Objects.equals(bridgeInformation.getType(),"4")).collect(Collectors.toList());

        String biggest = String.format("%.2f",biggestList.stream().mapToDouble(BridgeInformation::getLength).sum())+"/"+biggestList.size();

        String bigger = String.format("%.2f",biggerList.stream().mapToDouble(BridgeInformation::getLength).sum())+"/"+biggerList.size();

        String big = String.format("%.2f",bigList.stream().mapToDouble(BridgeInformation::getLength).sum())+"/"+bigList.size();

        String small = String.format("%.2f",smallList.stream().mapToDouble(BridgeInformation::getLength).sum())+"/"+smallList.size();

        String all = String.format("%.2f",bridges.stream().mapToDouble(BridgeInformation::getLength).sum())+"/"+bridges.size();

        orgVO.setBig(big);
        orgVO.setBigger(bigger);
        orgVO.setBiggest(biggest);
        orgVO.setSmall(small);
        orgVO.setAll(all);

        if ("4".equals(orgVO.getGrade())){
            orgVO.setRoadSegmentId(ids.get(0));
        }
        return orgVO;
    }

    @Override
    public List<Org4BridgeVO> getBridgeCount() {
        String orgId ;
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())&&!"0".equals(baseContext.getCurrentOrgId())){
            orgId = baseContext.getCurrentOrgId();
        }else {
            orgId = "1419863231459102720";
        }
        List<Org4BridgeVO> lists = new ArrayList<>();

        List<Org> rtnList = new ArrayList<Org>();

        QueryWrapper<Org> rgQueryWrapper = new QueryWrapper<>();
        rgQueryWrapper.eq("is_dele_","0");
        List<Org> allList = orgDao.selectList(rgQueryWrapper);

        List<Org> list = getOrgChild(allList, orgId, rtnList);
        for (Org org: list){
            Org4BridgeVO fvo = new Org4BridgeVO();
            BeanUtils.copyProperties(org,fvo);
            lists.add(fvo);
        }
        lists = getChild(lists,orgId);


        return this.setCount(lists);
    }

    public List<Org4BridgeVO> setCount(List<Org4BridgeVO> list){

        // 获取迭代器
        Iterator<Org4BridgeVO> it = list.iterator();

        while(it.hasNext()){
            Org4BridgeVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<>();
            if (grade<4){
                QueryWrapper<Road> roadQueryWrapper = new QueryWrapper<>();
                roadQueryWrapper.like( "COMPANY_IDS_", orgVO.getId());
                roadList = roadManager.list(roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }else if (grade==4){
                QueryWrapper<Road> roadByNameQueryWrapper = new QueryWrapper<>();
                roadByNameQueryWrapper.eq("NAME_",orgVO.getName());
                roadList =
                        roadManager.list(roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size()>0){
                orgVO = this.newCountWorkOrder(roadList,orgVO);
            }else {
                it.remove();
            }
            if (orgVO.getChirldren().size()>0&&Integer.valueOf(orgVO.getGrade())<4){
                this.setCount(orgVO.getChirldren());
            }
        }
        return list;
    }

    //统计表格
    public Org4BridgeVO newCountWorkOrder(List<String> ids,Org4BridgeVO orgVO) {
        orgVO.setRoadCount(ids.size());
        Calendar calendar = Calendar.getInstance();
        QueryWrapper<BizRoadsideFacilities> orderQueryWrapper = new QueryWrapper<>();
        orderQueryWrapper.in("ROAD_SEGMENT_ID_", ids);
        orderQueryWrapper.eq("IS_DELE_",0);
        List<BizRoadsideFacilities> list = bizRoadsideFacilitiesManager.list(orderQueryWrapper);

        QueryWrapper<BridgeInformation> bridgeWrapper = new QueryWrapper<>();
        bridgeWrapper.in("ROAD_SEGMENT_ID_", ids);
        bridgeWrapper.eq("IS_DELE_",0);
        List<BridgeInformation> bridges = this.list(bridgeWrapper);

        QueryWrapper<TunnelInformation> tunnelWrapper = new QueryWrapper<>();
        tunnelWrapper.in("ROAD_SEGMENT_ID_", ids);
        tunnelWrapper.eq("IS_DELE_",0);
        List<TunnelInformation> tunnels = tunnelInformationManager.list(tunnelWrapper);

        QueryWrapper<BizCulvertInformation> culvertWrapper = new QueryWrapper<>();
        culvertWrapper.in("ROAD_SEGMENT_ID_", ids);
        culvertWrapper.eq("IS_DELE_",0);
        List<BizCulvertInformation> culverts = bizCulvertInformationManager.list(culvertWrapper);

        QueryWrapper<BizVehicle> carWrapper = new QueryWrapper<>();
        carWrapper.in("ROAD_SEGMENT_ID_", ids);
        carWrapper.eq("IS_DELE_",0);
        List<BizVehicle> cars = bizVehicleManager.list(carWrapper);

        //统计人员数量 （通过组织id）
        String companyId = orgVO.getId();
        HashMap<String, String> map = new HashMap<>();
        map.put("id",companyId);
        Map<String, Set<String>> childrenIds = orgManager.getChildrenIds(map);
        Set<String> companyIds = childrenIds.get("id");

        QueryWrapper<MigrantBuildersInformation> migrantBuildersInformationQueryWrapper = new QueryWrapper<>();
        migrantBuildersInformationQueryWrapper.in("COMPANY_ID_", companyIds);
        List<MigrantBuildersInformation> humanList = migrantBuildersInformationManager.list(migrantBuildersInformationQueryWrapper);


        QueryWrapper<BizMaintenanceWorkArea> workWrapper = new QueryWrapper<>();
        workWrapper.in("ROAD_SEGMENT_ID_", ids);
        List<BizMaintenanceWorkArea> works = bizMaintenanceWorkAreaManager.list(workWrapper);
        if (list.size()>0){
            orgVO.setTollGateCount
                    (list.stream().filter(facilities -> Objects.equals(facilities.getType(),"3")).collect(Collectors.toList()).size());

            orgVO.setServiceCount
                    (list.stream().filter(facilities -> Objects.equals(facilities.getType(),"4")).collect(Collectors.toList()).size());

            orgVO.setInterworkingCount(list.stream().filter(facilities -> Objects.equals(facilities.getType(),"1")).collect(Collectors.toList()).size()
            +list.stream().filter(facilities -> Objects.equals(facilities.getType(),"2")).collect(Collectors.toList()).size());

            orgVO.setBridgeCount(bridges.size());

            orgVO.setCulvertCount(culverts.size());

            orgVO.setTunnelCount(tunnels.size());

            orgVO.setCarCount(cars.size());

            orgVO.setWorkCount(works.size());
            orgVO.setHumanNum(humanList.size());

            if ("4".equals(orgVO.getGrade())){
                orgVO.setRoadSegmentId(list.get(0).getRoadSegmentId());
            }
        }


        return orgVO;
    }

    /**
     * 获取某个父节点下面的所有子节点
      * @param orgList
     * @param parentId
     * @return
     */
    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            // 遍历出父id等于参数的id，add进子节点集合
            if (parentId.equals(org.getParentId())) {
                // 递归遍历下一级
                getOrgChild(orgList, org.getId(), rtnList);
                rtnList.add(org);
            }
        }
        return rtnList;
    }

    public static List<Org4BridgeVO> getChild(List<Org4BridgeVO> allList, String pCode) {
        List<Org4BridgeVO> returnList = new ArrayList<>();
        for (Org4BridgeVO entity : allList){
            if (pCode.equals(entity.getParentId())) {
                entity.setChirldren(getChild(allList, entity.getId()));
                returnList.add(entity);
            }
        }
        return returnList;
    }

    private List<String> getOrgIds (String currentOrgId){
        List<Org> orgList = orgManager.getByParentId(currentOrgId);
        List<String> collect = orgList.stream().map(Org::getId).collect(Collectors.toList());
        collect.add(currentOrgId);
        return collect;
    }
    @Override
    public PageList<BridgeCheckVo> queryBridge(QueryFilter<BridgeInformation> queryFilter) throws Exception {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        String baseContextCurrentOrgId = baseContext.getCurrentOrgId();
        if (StringUtils.isNotEmpty(baseContextCurrentOrgId) ){
            permissionUtils.addPermission(queryFilter);
        }
        List<FieldSort> sorter = queryFilter.getSorter();
        for (FieldSort fieldSort : sorter) {
            if(fieldSort.getProperty().equals("checkDate")){
                fieldSort.setProperty("CHECK_DATE_");
            }
        }
        IPage<BridgeCheckVo> result = baseMapper.getBridgeInformation(convert2IPage(queryFilter.getPageBean()), map, convert2Wrapper(queryFilter, currentModelClass()));
        List<BridgeCheckVo> records = result.getRecords();

        LocalDate today = LocalDate.now();
        for (BridgeCheckVo record : records) {
            QueryWrapper<BridgeOftenCheck> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq(record.getCheckDate()!=null,"CHECK_DATE_",record.getCheckDate());
            queryWrapper.eq("BRIGE_ID_",record.getId());
            queryWrapper.eq("IS_DELE_","0");
            List<BridgeOftenCheck> bridgeOftenChecks = checkDao.selectList(queryWrapper);
            if (bridgeOftenChecks!=null && bridgeOftenChecks.size()>0){
                record.setEvaluateValue(bridgeOftenChecks.get(0).getEvaluateValue());
            }
            Date checkDate = record.getCheckDate();
            if(null == checkDate){
                record.setTemporary(0);

            }else {
                Instant instant = checkDate.toInstant();
                ZoneId zoneId = ZoneId.systemDefault();
                LocalDate oldDate = instant.atZone(zoneId).toLocalDate();
                //设置距离上次检查过去多少天
                long dateLength=today.until(oldDate, ChronoUnit.DAYS);
                record.setAlreadyCheckDays((int)Math.abs(dateLength) );

                Date checkNewDay = record.getCheckNewDay();
                Instant instantNew = checkNewDay.toInstant();
                LocalDate newDate = instantNew.atZone(zoneId).toLocalDate();

                long dateDivide=today.until(newDate, ChronoUnit.DAYS);
                if(dateDivide< 0){
                    dateDivide =0;
                }
                record.setCheckDays((int)dateDivide);
            }
        }
        return new PageList<>(result);

    }

    @Override
    public BridgeInformation getBridgeById(String id) {

        BridgeInformation bridgeInformation = baseMapper.selectById(id);
        //根据资源ID查询关联的所有附件
        List<Accessory> accessories = accessoryManager.getAccessoryBySourceId(id);
        List<Accessory> accessoriesFrontView = new ArrayList<>();
        List<Accessory> accessoriesLateralView = new ArrayList<>();
        List<Accessory> accessoriesTwoDimensionalView = new ArrayList<>();
        if (accessories!=null &&accessories.size()>0) {
            accessories.forEach(s -> {
                String group = s.getGroup();
                if ("frontView".equalsIgnoreCase(group)) accessoriesFrontView.add(s);
                if ("lateralView".equalsIgnoreCase(group)) accessoriesLateralView.add(s);
                if ("twoDimensionalPlan".equalsIgnoreCase(group)) accessoriesTwoDimensionalView.add(s);
            });
        }
            bridgeInformation.setAccessoriesFrontView(accessoriesFrontView);
            bridgeInformation.setAccessoriesLateralView(accessoriesLateralView);
            bridgeInformation.setAccessoriesTwoDimensionalView(accessoriesTwoDimensionalView);

        return bridgeInformation;
    }


    @Override
    public BridgeInformation getBridgeByCode(String code,Integer direction) {

        QueryWrapper<BridgeInformation> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("IS_DELE_","0");
        queryWrapper.eq("NUMBER_",code);
        if(null != direction){
            queryWrapper.eq("DIRECTION_",Integer.valueOf(direction));
        }


        List<BridgeInformation> bridgeInformations = baseMapper.selectList(queryWrapper);
        if(null != bridgeInformations && bridgeInformations.size() > 0 ){
            return bridgeInformations.get(0);
        }

        return null;

    }

    @Override
    public void checkNumber(BridgeInformation bridgeInformation) {
        QueryWrapper<BridgeInformation> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotBlank(bridgeInformation.getId())) {
            queryWrapper.notIn("id_", bridgeInformation.getId());
        }
        queryWrapper.eq("NUMBER_", bridgeInformation.getNumber());
        queryWrapper.eq("IS_DELE_", "0");
        List<BridgeInformation> list = baseMapper.selectList(queryWrapper);
        if (list.size() > 0) {
            throw new RuntimeException("该桥梁编码已经存在");
        }
    }

    @Override
    public Integer getSn() {

        HashMap<String, Object> map = new HashMap<>();
        IUser user = ContextUtil.getCurrentUser();
        if (ObjectUtils.isNotEmpty(user)) {
            map.put("tenant_id_", user.getTenantId());
        }
        return this.getNextSequence(map);

    }

    @Override
    public PageList<BridgeInformation> queryBridgeInformation(QueryFilter<BridgeInformation> queryFilter) {
        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())) {
            permissionUtils.addPermission(queryFilter);
        }
        IPage<BridgeInformation> result = baseMapper.queryBridgeInformation(convert2IPage(queryFilter.getPageBean()), map, convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }


    @Override
    public PageList<BridgeRegularVo> queryBridgeRegularCheckVo(QueryFilter<BridgeInformation> queryFilter) throws Exception {

        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())) {
            permissionUtils.addPermission(queryFilter);
        }
        List<FieldSort> sorter = queryFilter.getSorter();
        for (FieldSort fieldSort : sorter) {
            if(fieldSort.getProperty().equals("checkDate")){
                fieldSort.setProperty("CHECK_DATE_");
            }
        }

        IPage<BridgeRegularVo> result = baseMapper.queryBridgeRegularCheckVo(convert2IPage(queryFilter.getPageBean()), map, convert2Wrapper(queryFilter, currentModelClass()));
        List<BridgeRegularVo> records = result.getRecords();

        LocalDate today = LocalDate.now();
        for (BridgeRegularVo record : records) {

            QueryWrapper<BridgeRegularCheck> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq(record.getCheckDate()!=null,"CHECK_DATE_",record.getCheckDate());
            queryWrapper.eq("BRIGE_ID_",record.getId());
            queryWrapper.eq("IS_DELE_","0");
            List<BridgeRegularCheck> bridgeRegularChecks = bridgeRegularCheckDao.selectList(queryWrapper);
            if (bridgeRegularChecks!=null && bridgeRegularChecks.size()>0){
                record.setOverallRatingValue( bridgeRegularChecks.get(0).getOverallRatingValue());
            }

            Date checkDate = record.getCheckDate();
            if(null == checkDate){

                record.setTemporary(0);
            }else {
                Instant instant = checkDate.toInstant();
                ZoneId zoneId = ZoneId.systemDefault();
                LocalDate oldDate = instant.atZone(zoneId).toLocalDate();
                //设置距离上次检查过去多少天
                long dateLength=today.until(oldDate, ChronoUnit.DAYS);
                record.setAlreadyCheckDays((int)Math.abs(dateLength) );

                Date checkNewDay = record.getCheckNewDay();
                Instant instantNew = checkNewDay.toInstant();
                LocalDate newDate = instantNew.atZone(zoneId).toLocalDate();

                long dateDivide=today.until(newDate, ChronoUnit.DAYS);
                if(dateDivide< 0){
                    dateDivide =0;
                }
                record.setCheckDays((int)dateDivide);

            }

        }

        return new PageList<>(result);
    }


    @Override
    public void saveBridge(BridgeInformation bizBridgeInformation) {
        //正面图:frontView  侧面图:lateralView 二维平面图:twoDimensionalPlan
        this.save(bizBridgeInformation);
        //1.保存正面图
        List<Accessory> accessoriesFrontView = bizBridgeInformation.getAccessoriesFrontView();
        if (null != accessoriesFrontView && accessoriesFrontView.size() > 0) {
            //设置附件资源ID
            accessoriesFrontView.forEach(s -> {
                s.setSourceId(bizBridgeInformation.getId());
                s.setGroup("frontView");
            });
            //保存正面图
            this.accessoryManager.saveBatch(accessoriesFrontView);
        }

        //2.保存侧面图
        List<Accessory> accessoriesLateralView = bizBridgeInformation.getAccessoriesLateralView();
        if (null != accessoriesLateralView && accessoriesLateralView.size() > 0) {
            //设置附件资源ID
            accessoriesLateralView.forEach(s -> {
                s.setSourceId(bizBridgeInformation.getId());
                s.setGroup("lateralView");
            });
            //保存侧面图
            this.accessoryManager.saveBatch(accessoriesLateralView);
        }

        //1.保存二维平面图
        List<Accessory> accessoriesTwoDimensionalView = bizBridgeInformation.getAccessoriesTwoDimensionalView();
        if (null != accessoriesTwoDimensionalView && accessoriesTwoDimensionalView.size() > 0) {
            //设置附件资源ID
            accessoriesTwoDimensionalView.forEach(s -> {
                s.setSourceId(bizBridgeInformation.getId());
                s.setGroup("twoDimensionalPlan");
            });
            //保存二维平面图
            this.accessoryManager.saveBatch(accessoriesTwoDimensionalView);
        }

    }

    @Override
    public void updateBridge(BridgeInformation bizBridgeInformation) {


        //正面图:frontView  侧面图:lateralView 二维平面图:twoDimensionalPlan
        this.update(bizBridgeInformation);
        //删除附件
        this.accessoryManager.delAccessoryBySourceId(bizBridgeInformation.getId());
        //1.保存正面图
        List<Accessory> accessoriesFrontView = bizBridgeInformation.getAccessoriesFrontView();
        if (null != accessoriesFrontView && accessoriesFrontView.size() > 0) {
            //设置附件资源ID
            accessoriesFrontView.forEach(s -> {
                s.setSourceId(bizBridgeInformation.getId());
                s.setGroup("frontView");
            });
            //保存正面图
            this.accessoryManager.saveBatch(accessoriesFrontView);
        }

        //2.保存侧面图
        List<Accessory> accessoriesLateralView = bizBridgeInformation.getAccessoriesLateralView();
        if (null != accessoriesLateralView && accessoriesLateralView.size() > 0) {
            //设置附件资源ID
            accessoriesLateralView.forEach(s -> {
                s.setSourceId(bizBridgeInformation.getId());
                s.setGroup("lateralView");
            });
            //保存侧面图
            this.accessoryManager.saveBatch(accessoriesLateralView);
        }

        //3.保存二维平面图
        List<Accessory> accessoriesTwoDimensionalView = bizBridgeInformation.getAccessoriesTwoDimensionalView();
        if (null != accessoriesTwoDimensionalView && accessoriesTwoDimensionalView.size() > 0) {
            //设置附件资源ID
            accessoriesTwoDimensionalView.forEach(s -> {
                s.setSourceId(bizBridgeInformation.getId());
                s.setGroup("twoDimensionalPlan");
            });
            //保存二维平面图
            this.accessoryManager.saveBatch(accessoriesTwoDimensionalView);
        }

    }
}
