package com.artfess.yhxt.basedata.manager;

import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.base.manager.BaseManager;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 附件表 服务类
 *
 * @author wangping
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-03
 */
public interface AccessoryManager extends BaseManager<Accessory> {

    String minioDrawingUpload(MultipartFile file, String sourceId);

    /**
     * @param file         文件
     * @param bizPath      路径
     * @param fileName     文件名
     * @param customBucket 桶名
     * @param sourceId     资源ID
     * @return
     */
    Accessory minIoUpload(MultipartFile file, String bizPath, String fileName, String customBucket, String sourceId);

    /**
     * @param ids      文件ids
     * @param filePath 相对路径
     * @param response 相应对象
     * @param bizPath  路径
     */
    void minIoDownFile(String ids, String bizPath, String filePath, String customBucket, HttpServletResponse response) throws Exception;

    /**
     * 附件通用下载
     * @param ids 文件ids
     * @param bizPath 路径
     * @param response
     * @throws Exception
     */
    void minIoDownFile(String ids,String bizPath,  HttpServletResponse response) throws Exception;

    /**
     * 删除图片
     *
     * @param id
     */
    void minIoRemoveFile(String id, String bizPath, String customBucket);

    /**
     * 附件上传接口
     */
    Accessory minioUpload(MultipartFile file, String bizPath ,HttpServletResponse response) throws Exception;

    /**
     * 根据sourceId查询附件信息
     */
    List<Accessory> getAccessoryBySourceId(String sourceId);

    /**
     * 根据sourceId删除附件信息
     */
    void delAccessoryBySourceId(String sourceId);
}
