package com.artfess.yhxt.assessment.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.assessment.model.CuringAssessment;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.assessment.vo.CuringAssessmentIVo;
import com.artfess.yhxt.check.regular.model.CulvertOftenCheck;
import com.artfess.yhxt.contract.vo.WorkOrderDiseaseVo;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import java.util.List;

/**
 * 养护考核表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2021-11-03
 */
public interface CuringAssessmentManager extends BaseManager<CuringAssessment> {

    /**
     * 保存修改养护考核信息
     * @param curingAssessmentIVo
     * @return
     */
    String saveCuringAssessment(CuringAssessmentIVo curingAssessmentIVo);

    /**
     * 根据查询到的养护工单导出养护工单数据
     * @param workOrderDiseaseVoList
     * @return
     */
    HSSFWorkbook exportCuringOrder(List<WorkOrderDiseaseVo> workOrderDiseaseVoList) throws Exception;


    /**
     * 根据养护考核信息ID导出考核信息，如果不传则默认导出当年所有季度的数据
     * @param ids
     * @return
     */
    HSSFWorkbook exportCuringAssessment(String ids) throws Exception;


}
