/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.open.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.conf.JwtConfig;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.EncryptUtil;
import com.artfess.yhxt.basedata.manager.BridgeInformationManager;
import com.artfess.yhxt.basedata.model.BridgeInformation;
import com.artfess.yhxt.open.base.util.JwtCheckUtils;
import com.artfess.yhxt.open.base.vo.Auth;
import com.artfess.yhxt.thirdparty.manager.BizTpBridgeHealthManager;
import com.artfess.yhxt.thirdparty.manager.BizTpBridgeManager;
import com.artfess.yhxt.thirdparty.manager.BizTpDeviceManager;
import com.artfess.yhxt.thirdparty.manager.BizTpWarningEventsManager;
import com.artfess.yhxt.thirdparty.model.BizTpBridge;
import com.artfess.yhxt.thirdparty.model.BizTpBridgeHealth;
import com.artfess.yhxt.thirdparty.model.BizTpDevice;
import com.artfess.yhxt.thirdparty.model.BizTpWarningEvents;
import com.artfess.yhxt.thirdparty.vo.SynchronizationSignVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Clock;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.DefaultClock;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/server/"})
@Api(tags={"\u7b2c\u4e09\u65b9\u4f20\u8f93\u4fe1\u606f\u5bf9\u5916\u63d0\u4f9b\u5165\u53e3"})
@ApiGroup(group={"group_biz"})
public class TransmissionController {
    @Resource
    BizTpBridgeManager bizTpBridgeManager;
    @Resource
    BridgeInformationManager bridgeInformationManager;
    @Resource
    BizTpDeviceManager bizTpDeviceManager;
    @Resource
    BizTpBridgeHealthManager bizTpBridgeHealthManager;
    @Resource
    BizTpWarningEventsManager bizTpWarningEventsManager;
    @Resource
    JwtCheckUtils jwtCheckUtils;
    @Resource
    JwtConfig jwtConfig;
    private final List<String> accessTransKeyList = Arrays.asList("TJYL001001");
    private static final String SALT = "PASSWORD001001";
    private Clock clock = DefaultClock.INSTANCE;

    @PostMapping(value={"/transmission/save/bridge"})
    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539\u6865\u6881")
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<Map> saveBridge(@ApiParam(name="bizTpBridge", value="\u6865\u6881\u57fa\u7840\u4fe1\u606f") @RequestBody List<BizTpBridge> bizTpBridges, HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (!this.checkToken(token)) {
            return new CommonResult(false, "\u8bf7\u91cd\u65b0\u83b7\u53d6token", null);
        }
        token = token.replaceAll("Bearer ", "");
        String tokenAccessKey = this.jwtCheckUtils.getTokenAccessKey(token);
        for (BizTpBridge bizTpBridge : bizTpBridges) {
            BizTpBridge bridge;
            String bridgeCode = bizTpBridge.getBridgeCode();
            if (null == bridgeCode || bridgeCode.isEmpty()) {
                return new CommonResult(false, "\u6865\u6881\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", null);
            }
            String id = bizTpBridge.getId();
            if (null == id || id.isEmpty()) {
                return new CommonResult(false, "\u6865\u6881ID\u4e0d\u80fd\u4e3a\u7a7a", null);
            }
            bizTpBridge.setId(tokenAccessKey + id);
            Integer direction = bizTpBridge.getDirection();
            BridgeInformation bridgeInformation = this.bridgeInformationManager.getBridgeByCode(bridgeCode, direction);
            if (null == bridgeInformation) {
                return new CommonResult(false, "\u8be5\u6865\u6881\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", null);
            }
            bizTpBridge.setBridgeId(bridgeInformation.getId());
            bizTpBridge.setCompanyIds(bridgeInformation.getCompanyIds());
            bizTpBridge.setCompanyId(bridgeInformation.getCompanyId());
            bizTpBridge.setCompanyName(bridgeInformation.getCompanyName());
            bizTpBridge.setRoadSegmentId(bridgeInformation.getRoadSegmentId());
            bizTpBridge.setRoadSegmentName(bridgeInformation.getRoadSegmentName());
            if (null == bizTpBridge.getIsDele()) {
                bizTpBridge.setIsDele("0");
            }
            if (null == (bridge = this.bizTpBridgeManager.selectById(bizTpBridge.getId()))) {
                this.bizTpBridgeManager.save((Object)bizTpBridge);
                continue;
            }
            bizTpBridge.setTenantId("-1");
            this.bizTpBridgeManager.update((Model)bizTpBridge);
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/transmission/save/device"})
    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539\u8bbe\u5907")
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<Map> saveDevice(@ApiParam(name="bizTpDevice", value="\u8bbe\u5907\u57fa\u7840\u4fe1\u606f") @RequestBody List<BizTpDevice> bizTpDevices, HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (!this.checkToken(token)) {
            return new CommonResult(false, "\u8bf7\u91cd\u65b0\u83b7\u53d6token", null);
        }
        token = token.replaceAll("Bearer ", "");
        String tokenAccessKey = this.jwtCheckUtils.getTokenAccessKey(token);
        for (BizTpDevice bizTpDevice : bizTpDevices) {
            BizTpBridge bridge;
            BizTpDevice device;
            if (null == bizTpDevice.getId() || bizTpDevice.getId().isEmpty()) {
                return new CommonResult(false, "\u8bbe\u5907ID\u4e0d\u80fd\u4e3a\u7a7a", null);
            }
            bizTpDevice.setId(tokenAccessKey + bizTpDevice.getId());
            if (null == bizTpDevice.getIsDele()) {
                bizTpDevice.setIsDele("0");
            }
            if (null != (device = (BizTpDevice)((Object)this.bizTpDeviceManager.getById((Serializable)((Object)bizTpDevice.getId())))) && "0" != device.getIsDele()) {
                device.setState(bizTpDevice.getState());
                if (null != bizTpDevice.getTrBridgeId()) {
                    device.setTrBridgeId(tokenAccessKey + bizTpDevice.getTrBridgeId());
                    bridge = (BizTpBridge)((Object)this.bizTpBridgeManager.getById((Serializable)((Object)bizTpDevice.getTrBridgeId())));
                    if (null == bridge) {
                        return new CommonResult(false, "\u672a\u627e\u5230\u76f8\u5173\u6865\u6881\u4f20\u8f93\u4fe1\u606f", null);
                    }
                    device.setTpBridgeId(bridge.getBridgeId());
                    device.setTpBridgeName(bridge.getBridgeName());
                    device.setTpBridgeType(bridge.getType());
                    device.setCompanyIds(bridge.getCompanyIds());
                    device.setCompanyId(bridge.getCompanyId());
                    device.setCompanyName(bridge.getCompanyName());
                    device.setRoadSegmentId(bridge.getRoadSegmentId());
                    device.setRoadSegmentName(bridge.getRoadSegmentName());
                }
                device.setIsDele(bizTpDevice.getIsDele());
                this.bizTpDeviceManager.update((Model)device);
                continue;
            }
            if (null == bizTpDevice.getDeviceCode() || bizTpDevice.getDeviceCode().isEmpty()) {
                return new CommonResult(false, "\u8bbe\u5907\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", null);
            }
            if (null == bizTpDevice.getTrBridgeId() || bizTpDevice.getTrBridgeId().isEmpty()) {
                return new CommonResult(false, "\u5173\u8054\u6865\u6881ID\u4e0d\u80fd\u4e3a\u7a7a", null);
            }
            bizTpDevice.setTrBridgeId(tokenAccessKey + bizTpDevice.getTrBridgeId());
            bridge = (BizTpBridge)((Object)this.bizTpBridgeManager.getById((Serializable)((Object)bizTpDevice.getTrBridgeId())));
            if (null == bridge) {
                return new CommonResult(false, "\u672a\u627e\u5230\u76f8\u5173\u6865\u6881\u4f20\u8f93\u4fe1\u606f", null);
            }
            bizTpDevice.setTpBridgeId(bridge.getBridgeId());
            bizTpDevice.setTpBridgeName(bridge.getBridgeName());
            bizTpDevice.setTpBridgeType(bridge.getType());
            bizTpDevice.setCompanyIds(bridge.getCompanyIds());
            bizTpDevice.setCompanyId(bridge.getCompanyId());
            bizTpDevice.setCompanyName(bridge.getCompanyName());
            bizTpDevice.setRoadSegmentId(bridge.getRoadSegmentId());
            bizTpDevice.setRoadSegmentName(bridge.getRoadSegmentName());
            boolean bl = this.bizTpDeviceManager.saveOrUpdate((Object)bizTpDevice);
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/transmission/save/monitor"})
    @ApiOperation(value="\u6865\u6881\u5065\u5eb7\u76d1\u6d4b\u6570\u636e\u4f20\u8f93")
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<Map> saveMonitor(@ApiParam(name="bridgeHealth", value="\u6865\u6881\u5065\u5eb7\u76f8\u5173\u4fe1\u606f") @RequestBody List<BizTpBridgeHealth> bridgeHealths, HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (!this.checkToken(token)) {
            return new CommonResult(false, "\u8bf7\u91cd\u65b0\u83b7\u53d6token", null);
        }
        token = token.replaceAll("Bearer ", "");
        String tokenAccessKey = this.jwtCheckUtils.getTokenAccessKey(token);
        for (BizTpBridgeHealth bridgeHealth : bridgeHealths) {
            String trBridgeId = bridgeHealth.getTrBridgeId();
            if (null == trBridgeId || trBridgeId.isEmpty()) {
                return new CommonResult(false, "\u6865\u6881ID\u4e0d\u80fd\u4e3a\u7a7a", null);
            }
            bridgeHealth.setTrBridgeId(tokenAccessKey + bridgeHealth.getTrBridgeId());
            BizTpBridge bridge = (BizTpBridge)((Object)this.bizTpBridgeManager.getById((Serializable)((Object)bridgeHealth.getTrBridgeId())));
            if (null == bridge) {
                return new CommonResult(false, "\u672a\u627e\u5230\u76f8\u5173\u6865\u6881\u4f20\u8f93\u4fe1\u606f", null);
            }
            bridgeHealth.setTpBridgeId(bridge.getBridgeId());
            bridgeHealth.setTpBridgeCode(bridge.getBridgeCode());
            bridgeHealth.setCompanyIds(bridge.getCompanyIds());
            bridgeHealth.setCompanyId(bridge.getCompanyId());
            bridgeHealth.setCompanyName(bridge.getCompanyName());
            bridgeHealth.setRoadSegmentId(bridge.getRoadSegmentId());
            bridgeHealth.setRoadSegmentName(bridge.getRoadSegmentName());
            if (null != bridgeHealth.getIsDele()) continue;
            bridgeHealth.setIsDele("0");
        }
        boolean result = this.bizTpBridgeHealthManager.saveBatch(bridgeHealths);
        if (!result) {
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25", null);
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/transmission/save/events"})
    @ApiOperation(value="\u6865\u6881\u76f8\u5173\u9884\u8b66\u4e8b\u4ef6\u4f20\u8f93")
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<Map> saveWarnEvents(@ApiParam(name="bizTpWarningEvents", value="\u6865\u6881\u76f8\u5173\u9884\u8b66\u4e8b\u4ef6") @RequestBody List<BizTpWarningEvents> bizTpWarningEventss, HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (!this.checkToken(token)) {
            return new CommonResult(false, "\u8bf7\u91cd\u65b0\u83b7\u53d6token", null);
        }
        token = token.replaceAll("Bearer ", "");
        String tokenAccessKey = this.jwtCheckUtils.getTokenAccessKey(token);
        for (BizTpWarningEvents bizTpWarningEvents : bizTpWarningEventss) {
            BizTpWarningEvents tpWarningEvents;
            String id = bizTpWarningEvents.getId();
            if (null == id || id.isEmpty()) {
                return new CommonResult(false, "\u9884\u8b66\u4e8b\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a", null);
            }
            bizTpWarningEvents.setId(tokenAccessKey + bizTpWarningEvents.getId());
            Integer eventsState = bizTpWarningEvents.getEventsState();
            if (null == eventsState) {
                return new CommonResult(false, "\u4e8b\u4ef6\u5904\u7f6e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", null);
            }
            if (null == bizTpWarningEvents.getIsDele()) {
                bizTpWarningEvents.setIsDele("0");
            }
            if (null != (tpWarningEvents = (BizTpWarningEvents)((Object)this.bizTpWarningEventsManager.getById((Serializable)((Object)bizTpWarningEvents.getId()))))) {
                if (eventsState == 1 && null == bizTpWarningEvents.getDealDate()) {
                    return new CommonResult(false, "\u4e8b\u4ef6\u5904\u7f6e\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", null);
                }
                tpWarningEvents.setEventsState(eventsState);
                tpWarningEvents.setDealDate(bizTpWarningEvents.getDealDate());
                this.bizTpWarningEventsManager.update((Model)tpWarningEvents);
                continue;
            }
            String deviceId = bizTpWarningEvents.getDeviceId();
            if (null == deviceId || deviceId.isEmpty()) {
                return new CommonResult(false, "\u8bbe\u5907ID\u4e0d\u80fd\u4e3a\u7a7a", null);
            }
            bizTpWarningEvents.setDeviceId(tokenAccessKey + deviceId);
            bizTpWarningEvents.setTrBridgeId(tokenAccessKey + bizTpWarningEvents.getTrBridgeId());
            BizTpDevice device = (BizTpDevice)((Object)this.bizTpDeviceManager.getById((Serializable)((Object)bizTpWarningEvents.getDeviceId())));
            if (null == device) {
                return new CommonResult(false, "\u672a\u627e\u5230\u76f8\u5173\u5173\u8054\u8bbe\u5907", null);
            }
            bizTpWarningEvents.setTpBridgeName(device.getTpBridgeName());
            bizTpWarningEvents.setTpBridgeId(device.getTpBridgeId());
            bizTpWarningEvents.setTrBridgeId(device.getTrBridgeId());
            bizTpWarningEvents.setCompanyIds(device.getCompanyIds());
            bizTpWarningEvents.setCompanyId(device.getCompanyId());
            bizTpWarningEvents.setCompanyName(device.getCompanyName());
            bizTpWarningEvents.setRoadSegmentId(device.getRoadSegmentId());
            bizTpWarningEvents.setRoadSegmentName(device.getRoadSegmentName());
            boolean bl = this.bizTpWarningEventsManager.saveOrUpdate((Object)bizTpWarningEvents);
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/transmission/getTransToken"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4f20\u8f93\u7cfb\u7edf\u83b7\u53d6token", httpMethod="POST")
    public CommonResult<String> getTransToken(@RequestBody Auth auth) {
        if (auth == null) {
            return new CommonResult(false, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String accessKey = auth.getAccessKey();
        String secret = auth.getSecret();
        if (StringUtils.isBlank((CharSequence)accessKey)) {
            return new CommonResult(false, "\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)secret)) {
            return new CommonResult(false, "\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String str = accessKey + SALT;
        try {
            String curKey = EncryptUtil.md5Hex((String)str);
            if (!curKey.equalsIgnoreCase(secret)) {
                return new CommonResult(false, "\u8ba4\u8bc1\u5931\u8d25\uff0c\u975e\u6cd5\u7684\u79d8\u94a5\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u7cfb\u7edf\u52a0\u89e3\u5bc6\u9519\u8bef\uff01");
        }
        boolean result = this.accessTransKeyList.stream().anyMatch(s -> s.equals(accessKey));
        if (result) {
            Date createdDate = this.clock.now();
            HashMap<String, String> stringObjectHashMap = new HashMap<String, String>();
            stringObjectHashMap.put("accessKey", accessKey);
            Date date = DateUtils.addHours((Date)createdDate, (int)2);
            String token = Jwts.builder().setClaims(stringObjectHashMap).setSubject(accessKey).setIssuedAt(createdDate).setExpiration(date).signWith(SignatureAlgorithm.HS512, this.jwtConfig.getSecret()).compact();
            SynchronizationSignVo signVo = new SynchronizationSignVo();
            QueryWrapper wrapperBridge = new QueryWrapper();
            wrapperBridge.like((Object)"ID_", (Object)accessKey);
            int count1 = this.bizTpBridgeManager.count((Wrapper)wrapperBridge);
            if (count1 == 0) {
                signVo.setNeedBridge(1);
            }
            QueryWrapper wrapperDevice = new QueryWrapper();
            wrapperDevice.like((Object)"ID_", (Object)accessKey);
            int count2 = this.bizTpDeviceManager.count((Wrapper)wrapperDevice);
            if (count2 == 0) {
                signVo.setNeedDevice(1);
            }
            QueryWrapper wrapperHealth = new QueryWrapper();
            wrapperHealth.like((Object)"TR_BRIDGE_ID_", (Object)accessKey);
            int count3 = this.bizTpBridgeHealthManager.count((Wrapper)wrapperHealth);
            if (count3 == 0) {
                signVo.setNeedAssessment(1);
            }
            QueryWrapper wrapperWarn = new QueryWrapper();
            wrapperWarn.like((Object)"ID_", (Object)accessKey);
            int count4 = this.bizTpWarningEventsManager.count((Wrapper)wrapperWarn);
            if (count4 == 0) {
                signVo.setNeedWarningEvents(1);
            }
            signVo.setToken(token);
            return new CommonResult(true, "\u83b7\u53d6token\u6210\u529f", (Object)signVo);
        }
        return new CommonResult(false, "\u672a\u6388\u6743\u7684\u7b2c\u4e09\u65b9\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    private boolean checkToken(String token) {
        if (null == token || token.isEmpty()) {
            return false;
        }
        token = token.replaceAll("Bearer ", "");
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey(this.jwtConfig.getSecret()).parseClaimsJws(token).getBody();
            Object accessKey = claims.get((Object)"accessKey");
            Date expiration = claims.getExpiration();
            Date date = new Date();
            if (date.after(expiration)) {
                return false;
            }
            return this.accessTransKeyList.stream().anyMatch(s -> s.equals(accessKey));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

