/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.contract.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.cqxy.contract.dao.ContractDao;
import com.artfess.cqxy.contract.manager.ContractManager;
import com.artfess.cqxy.contract.manager.ItemManager;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.contract.model.Item;
import com.artfess.cqxy.contract.vo.ContractVo;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.cqxy.utils.ZipUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ContractManagerImpl
extends BaseManagerImpl<ContractDao, Contract>
implements ContractManager {
    @Autowired
    private ItemManager itemManager;
    @Autowired
    private ProjectManagementManager ppm;
    @Autowired
    private AccessoryManager am;
    @Autowired
    private SystemConfigFeignService scfs;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private GlobalRetrievalManager grm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private AccessoryManager accessoryManager;
    @Resource
    private UCFeignService ucFeignService;

    @Override
    public boolean saveContract(ContractVo vo) {
        Contract contractData = vo.getContract();
        Assert.notNull((Object)contractData.getProjectId(), (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)contractData.getType(), (String)"\u5408\u540c\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        String contractInvolved = contractData.getFirstParty();
        contractData.setContractInvolved(StringUtils.isEmpty((CharSequence)contractInvolved) ? ((ProjectManagement)this.ppm.get((Serializable)((Object)contractData.getProjectId()))).getProjectName() : contractInvolved);
        String firstParty = contractData.getFirstParty();
        contractData.setFirstParty(StringUtils.isEmpty((CharSequence)firstParty) ? "\u91cd\u5e86\u897f\u6c38\u5fae\u7535\u5b50\u4ea7\u4e1a\u56ed\u533a\u5f00\u53d1\u6709\u9650\u516c\u53f8" : firstParty);
        String uniqueNumber = this.scfs.getNextIdByAlias("htwybh").replace("\u65bd\u5de5\u5408\u540c", contractData.getTypeValue());
        contractData.setUniqueNumber(uniqueNumber.substring(StringUtils.lastOrdinalIndexOf((CharSequence)uniqueNumber, (CharSequence)"\"", (int)2) + 1, uniqueNumber.lastIndexOf("\"")));
        boolean contract = this.save((Object)contractData);
        List<Object> items = null == vo.getContractItem() ? new ArrayList() : vo.getContractItem();
        for (Item item : items) {
            item.setContractId_(vo.getContract().getId());
            item.setIsDele("0");
        }
        boolean item = items.size() == 0 || this.itemManager.saveOrUpdateBatch(items);
        this.ppm.updateStatusById(contractData.getProjectId(), Integer.valueOf(ProjectStatusEnum.nine.getCode()));
        this.handleRetrieval(new GlobalRetrieval(), vo.getContract());
        return contract && item && this.handleAccessory(vo);
    }

    @Override
    public boolean updateContract(ContractVo vo) {
        boolean contract = this.updateById((Object)vo.getContract());
        boolean item = false;
        item = null == vo.getContractItem() || vo.getContractItem().size() == 0 ? true : this.itemManager.saveOrUpdateBatch(vo.getContractItem());
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(vo.getContract().getId());
        this.handleRetrieval(BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, vo.getContract());
        return contract && item && this.handleAccessory(vo);
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, Contract entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.ppm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.forteen.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.forteen.getName());
        globalRetrieval.setBizTableName(FunctionEnum.forteen.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.forteen.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.forteen.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.forteen.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.forteen.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.forteen.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getContractNumber());
        globalRetrieval.setName(entity.getName());
        globalRetrieval.setSearchTitle(entity.getName() + "_" + entity.getContractNumber() + "_" + entity.getDecisionDocuments() + "_" + entity.getContractInvolved() + "_" + entity.getFirstParty() + "_" + entity.getSecondParty() + "_" + entity.getThirdParty() + "_" + entity.getUniqueNumber() + "_" + entity.getContractExceptionLog() + "_" + entity.getContractSchedule() + "_" + entity.getTreatyContents() + "_" + entity.getContractKeeper() + "_" + entity.getContractStorage() + "_" + entity.getContractReceiver() + "_" + entity.getEstablishmentRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    private boolean handleAccessory(ContractVo vo) {
        ArrayList flag = vo.getAccessoryInfo();
        ArrayList accessoryList = null == flag ? new ArrayList() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(vo.getContract().getId());
            ele.setProjectId(vo.getContract().getProjectId());
            ele.setDirectory(ProjectStatusEnum.nine.getCode());
            ele.setGroup("Contract");
            ele.setNode(ProjectStatusEnum.nine.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
        }
        this.am.removeBySourceId(vo.getContract().getId());
        return accessoryList.size() == 0 || this.am.saveBatch(accessoryList);
    }

    @Override
    public boolean removeContractByIds(List<String> ids) {
        boolean item = false;
        boolean contract = false;
        for (String ele : ids) {
            UpdateWrapper itemWrapper = new UpdateWrapper();
            ((UpdateWrapper)((UpdateWrapper)itemWrapper.set((Object)"IS_DELE_", (Object)"1")).eq((Object)"CONTRACT_ID_", (Object)ele)).eq((Object)"IS_DELE_", (Object)"0");
            List itemList = this.itemManager.getBaseMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"CONTRACT_ID_", (Object)ele));
            item = itemList.size() == 0 || this.itemManager.update((Wrapper)itemWrapper);
            UpdateWrapper contractWrapper = new UpdateWrapper();
            ((UpdateWrapper)((UpdateWrapper)contractWrapper.set((Object)"IS_DELE_", (Object)"1")).eq((Object)"ID_", (Object)ele)).eq((Object)"IS_DELE_", (Object)"0");
            contract = this.update((Wrapper)contractWrapper);
        }
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return item && contract;
    }

    @Override
    public PageList<ContractVo> queryAllByPage(QueryFilter<Contract> queryFilter) {
        IPage<Contract> contract;
        BizUtils.handleFilter(queryFilter, "bc", "pm");
        IUser user = ContextUtil.getCurrentUser();
        if (null != user) {
            JsonNode userJsonNode;
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            CommonResult userNode = this.ucFeignService.getUserById(userId);
            if (userNode.getState().booleanValue() && null != (userJsonNode = (JsonNode)userNode.getValue())) {
                userType = userJsonNode.get("userType").asInt();
            }
            if (userType != null && userType != 0 && userType != 1) {
                HashSet<String> set = new HashSet<String>();
                List list = this.ucFeignService.getRoleListByAccount(user.getAccount());
                if (BeanUtils.isNotEmpty((Object)list)) {
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if (!(set.contains("sysRole") || set.contains("bld") || set.contains("xmjl") || set.contains("htgly"))) {
                    disableAll = true;
                }
            }
            if (disableAll) {
                String fullname = user.getFullname();
                queryFilter.addFilter("bc.contract_receiver_", (Object)fullname, QueryOP.LIKE, FieldRelation.AND, "contractReceiver");
                queryFilter.addFilter("bc.contract_receiver_", (Object)fullname, QueryOP.IS_NULL, FieldRelation.OR, "contractReceiver");
                queryFilter.addFilter("bc.contract_receiver_", (Object)"", QueryOP.EQUAL, FieldRelation.OR, "contractReceiver");
            }
        }
        List contractList = null == (contract = ((ContractDao)this.baseMapper).queryAllByPage((IPage<Contract>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Contract>)this.convert2Wrapper(queryFilter, this.currentModelClass()))).getRecords() ? new ArrayList() : contract.getRecords();
        ArrayList<ContractVo> voList = new ArrayList<ContractVo>();
        for (Contract ele : contractList) {
            QueryWrapper itemWrapper = new QueryWrapper();
            ((QueryWrapper)itemWrapper.eq((Object)"CONTRACT_ID_", (Object)ele.getId())).eq((Object)"IS_DELE_", (Object)"0");
            List items = this.itemManager.getBaseMapper().selectList((Wrapper)itemWrapper);
            List<Accessory> accessoryInfo = this.am.getAccessoryBySourceId(ele.getId());
            ProjectManagement projectManagement = (ProjectManagement)((Object)this.ppm.getById((Serializable)((Object)ele.getProjectId())));
            ContractVo tempVo = new ContractVo(projectManagement, ele, items, accessoryInfo);
            voList.add(tempVo);
        }
        Page result = new Page(contract.getCurrent(), contract.getSize(), contract.getTotal());
        result.setPages(contract.getPages());
        result.setRecords(voList);
        return new PageList((IPage)result);
    }

    @Override
    public PageList<Contract> queryContractByPage(QueryFilter<Contract> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bc", "pm");
        IPage<Contract> contract = ((ContractDao)this.baseMapper).queryAllByPage((IPage<Contract>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Contract>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(contract);
    }

    @Override
    public ContractVo getVoById(String id) {
        QueryWrapper contractWrapper = new QueryWrapper();
        ((QueryWrapper)contractWrapper.eq((Object)"ID_", (Object)id)).eq((Object)"IS_DELE_", (Object)"0");
        Contract contract = (Contract)((Object)((ContractDao)this.baseMapper).selectOne((Wrapper)contractWrapper));
        if (BeanUtils.isEmpty((Object)((Object)contract))) {
            return null;
        }
        QueryWrapper itemWrapper = new QueryWrapper();
        ((QueryWrapper)itemWrapper.eq((Object)"CONTRACT_ID_", (Object)id)).eq((Object)"IS_DELE_", (Object)"0");
        List items = this.itemManager.getBaseMapper().selectList((Wrapper)itemWrapper);
        List<Accessory> accessoryInfo = this.am.getAccessoryBySourceId(id);
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.ppm.getById((Serializable)((Object)contract.getProjectId())));
        return new ContractVo(projectManagement, contract, items, accessoryInfo);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        List secondLevelType = this.sdm.queryDictListItemsByCode("htgl-jsfs");
        List contractTypeDic = this.sdm.queryDictListItemsByCode("htgZ-htLb");
        try (InputStream inputStream = file.getInputStream();){
            List<Contract> data = ExcelImportUtil.importExcel((InputStream)inputStream, Contract.class, (ImportParams)new ImportParams());
            data = this.removeNullData(data);
            for (Contract ele : data) {
                ele.setProjectId(projectId);
                ele.setFirstParty(StringUtils.isBlank((CharSequence)ele.getFirstParty()) ? "\u91cd\u5e86\u897f\u6c38\u5fae\u7535\u5b50\u4ea7\u4e1a\u56ed\u533a\u5f00\u53d1\u6709\u9650\u516c\u53f8" : ele.getFirstParty());
                String type = BizUtils.getDicValueByCode((List<DictModel>)contractTypeDic, ele.getType());
                ele.setType(type);
                String uniqueNumber = this.scfs.getNextIdByAlias("htwybh").replace("\u65bd\u5de5\u5408\u540c", type);
                ele.setUniqueNumber(uniqueNumber.substring(StringUtils.lastOrdinalIndexOf((CharSequence)uniqueNumber, (CharSequence)"\"", (int)2) + 1, uniqueNumber.lastIndexOf("\"")));
                ele.setSecondLevelType(BizUtils.getDicCodeByValue(secondLevelType, ele.getSecondLevelType()));
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Contract> removeNullData(List<Contract> data) {
        ArrayList<Contract> result = new ArrayList<Contract>();
        data.forEach(e -> {
            if (StringUtils.isNotEmpty((CharSequence)e.getName())) {
                result.add((Contract)((Object)e));
            }
        });
        return result;
    }

    @Override
    public void exportDatatoExcel(QueryFilter<Contract> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u5408\u540c\u4fe1\u606f-\u5bfc\u51fa\u7ed3\u679c";
        List payType = this.sdm.queryDictListItemsByCode("htgl-jsfs");
        List biddingChargeType = this.sdm.queryDictListItemsByCode("zbfs");
        List contractPType = this.sdm.queryDictListItemsByCode("htgl-htfl");
        BizUtils.handleFilter(queryFilter, "bc", "pm");
        List data = ((ContractDao)this.baseMapper).queryAllByPage((IPage<Contract>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<Contract>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        for (Contract ele : data) {
            ele.setSecondLevelType(BizUtils.getDicValueByCode((List<DictModel>)payType, ele.getSecondLevelType()));
            ele.setBiddingChargeType(BizUtils.getDicValueByCode((List<DictModel>)biddingChargeType, ele.getBiddingChargeType()));
            ele.setMold(BizUtils.getDicValueByCode((List<DictModel>)contractPType, ele.getMold()));
            ele.setType(ele.getTypeValue());
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, Contract.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }

    @Override
    public List<Map<String, Object>> queryInvestment(StatisticsVo statisticsVo) {
        List<Map<String, Object>> list = ((ContractDao)this.baseMapper).queryInvestment(statisticsVo);
        List contractPType = this.sdm.queryDictListItemsByCode("htgl-htfl");
        if (null != list) {
            for (DictModel dic : contractPType) {
                String name = dic.getName();
                String value = dic.getValue();
                boolean isExistence = true;
                for (Map<String, Object> map : list) {
                    String type = map.get("type") == null ? "" : String.valueOf(map.get("type"));
                    if (!type.equalsIgnoreCase(value)) continue;
                    map.put("typeName", name);
                    isExistence = false;
                    break;
                }
                if (!isExistence) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("type", value);
                map.put("typeName", name);
                map.put("total", 0);
                list.add(map);
            }
        }
        return list;
    }

    @Override
    public BigDecimal queryConstructionAmount(String projectId) {
        BigDecimal constructionAmount = ((ContractDao)this.baseMapper).queryConstructionAmount(projectId);
        BigDecimal constructionAmountResult = BigDecimal.ZERO;
        if (null != constructionAmount && constructionAmount.compareTo(BigDecimal.ZERO) > 0) {
            constructionAmountResult = constructionAmount.divide(new BigDecimal("10000"), 0, 4);
        }
        return constructionAmountResult;
    }

    @Override
    public BigDecimal queryConstructionAmount2(String projectId) {
        BigDecimal constructionAmount = ((ContractDao)this.baseMapper).queryConstructionAmount(projectId);
        BigDecimal constructionAmountResult = BigDecimal.ZERO;
        if (null != constructionAmount && constructionAmount.compareTo(BigDecimal.ZERO) > 0) {
            constructionAmountResult = constructionAmount.divide(new BigDecimal("10000"), 2, 4);
        }
        return constructionAmountResult;
    }

    @Override
    public void downloadBatch(String projectId, List<String> contractIds, HttpServletResponse response) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        ProjectManagement project = (ProjectManagement)((Object)this.ppm.getById((Serializable)((Object)projectId)));
        List accessoryList = Lists.newArrayList();
        accessoryList = BeanUtils.isNotEmpty(contractIds) ? this.accessoryManager.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"SOURCE_ID_", contractIds)).eq((Object)"IS_DELE_", (Object)"0")).eq((Object)"GROUP_", (Object)"Contract")) : this.accessoryManager.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PROJECT_ID_", (Object)projectId)).eq((Object)"IS_DELE_", (Object)"0")).eq((Object)"GROUP_", (Object)"Contract"));
        String zipName = "\u3010" + project.getProjectName() + "\u3011\u5408\u540c\u6279\u91cf\u4e0b\u8f7d";
        String fileTemp = (FileUtil.getIoTmpdir() + "attachFiles/tempZip/" + zipName).replace("/", File.separator);
        File folder = new File(fileTemp);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            for (Accessory accessory : accessoryList) {
                accessoryList.forEach(a -> {
                    if (accessory.getName().equals(a.getName()) && !accessory.getFileSize().equals(a.getFileSize())) {
                        accessory.setName(accessory.getName().replace("." + accessory.getSuffix(), "") + "\u3010\u91cd\u540d\u6587\u4ef6\u4ee5\u65e5\u671f\u6807\u8bc6\u3011" + LocalDateTimeUtil.format((LocalDateTime)accessory.getCreateTime(), (String)"yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2") + "." + accessory.getSuffix());
                    }
                });
                HttpUtil.downLoadByUrl((String)accessory.getUrl(), (String)accessory.getName(), (String)fileTemp);
            }
            FileOutputStream zipOut = new FileOutputStream(new File(fileTemp + ".zip"));
            ZipUtils.toZip(fileTemp, zipOut, true);
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)(fileTemp + ".zip"), (String)(zipName + ".zip"));
            FileUtil.deleteDiretory((String)fileTemp.replace(zipName, ""));
        }
        catch (Exception e) {
            e.printStackTrace();
            FileUtil.deleteDiretory((String)fileTemp.replace(zipName, ""));
        }
    }
}

