/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.contract.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.contract.dao.ItemDao;
import com.artfess.cqxy.contract.manager.ContractManager;
import com.artfess.cqxy.contract.manager.ItemManager;
import com.artfess.cqxy.contract.model.Item;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ItemManagerImpl
extends BaseManagerImpl<ItemDao, Item>
implements ItemManager {
    @Autowired
    ContractManager cm;
    @Autowired
    private GlobalRetrievalManager grm;

    public boolean saveOrUpdate(Item entity) {
        boolean save = StringUtils.isEmpty((Object)entity.getId());
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return save ? this.save((Object)entity) : this.updateById((Object)entity);
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, Item entity) {
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.fivteen.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.fivteen.getName());
        globalRetrieval.setBizTableName(FunctionEnum.fivteen.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.fivteen.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.fivteen.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.fivteen.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.fivteen.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.fivteen.getFunctionPath());
        globalRetrieval.setName(entity.getName());
        globalRetrieval.setSearchTitle(entity.getName() + "_" + entity.getCode() + "_" + entity.getSubjectCode() + "_" + entity.getSubjectName() + "_" + entity.getRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public PageList<Item> queryAllByPage(QueryFilter<Item> queryFilter) {
        String contractId = null;
        List test = queryFilter.getQuerys();
        for (QueryField ele : test) {
            if (!"CONTRACT_ID_".equals(ele.getProperty())) continue;
            contractId = String.valueOf(ele.getValue());
            break;
        }
        Assert.notNull(contractId, (String)"\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a");
        IPage<Item> result = ((ItemDao)this.baseMapper).queryAllByPage((IPage<Item>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Item>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String contractId) {
        Assert.notNull((Object)contractId, (String)"\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a");
        List<Item> data = this.readExcelData(file);
        for (Item ele : data) {
            ele.setContractId_(contractId);
            ((ItemDao)this.baseMapper).insert((Object)ele);
            this.handleRetrieval(new GlobalRetrieval(), ele);
        }
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public List<Item> readExcelData(MultipartFile file) {
        ArrayList<Item> result = new ArrayList<Item>();
        try {
            InputStream inputStream = file.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheetAt = workbook.getSheetAt(0);
            for (Row row : sheetAt) {
                if (row.getRowNum() == 0) continue;
                Item data = new Item();
                data.setSort_(null == row.getCell(0) ? (int)row.createCell(0).getNumericCellValue() : (int)row.getCell(0).getNumericCellValue());
                data.setCode_(null == row.getCell(1) ? row.createCell(1).getStringCellValue() : row.getCell(1).getStringCellValue());
                data.setName_(null == row.getCell(2) ? row.createCell(2).getStringCellValue() : row.getCell(2).getStringCellValue());
                data.setSubjectCode_(null == row.getCell(3) ? row.createCell(3).getStringCellValue() : row.getCell(3).getStringCellValue());
                data.setSubjectName_(null == row.getCell(4) ? row.createCell(4).getStringCellValue() : row.getCell(4).getStringCellValue());
                data.setSpec_(null == row.getCell(5) ? row.createCell(5).getStringCellValue() : row.getCell(5).getStringCellValue());
                data.setPrice_(null == row.getCell(6) ? row.createCell(6).getNumericCellValue() : row.getCell(6).getNumericCellValue());
                data.setAmount_((int)(null == row.getCell(7) ? row.createCell(7).getNumericCellValue() : row.getCell(7).getNumericCellValue()));
                data.setMonty_(null == row.getCell(8) ? row.createCell(8).getNumericCellValue() : row.getCell(8).getNumericCellValue());
                data.setRemarks_(null == row.getCell(9) ? row.createCell(9).getStringCellValue() : row.getCell(9).getStringCellValue());
                result.add(data);
            }
            workbook.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void exportDatatoExcel(QueryFilter<Item> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u5408\u540c\u8be6\u7ec6\u4fe1\u606f-\u5bfc\u51fa\u7ed3\u679c";
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        List data = ((ItemDao)this.baseMapper).queryAllByPage((IPage<Item>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<Item>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, Item.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }
}

