package com.artfess.cqxy.processManagermant.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.processManagermant.model.ProgressManage;
import com.artfess.cqxy.processManagermant.vo.AppropriatedlVo;
import com.artfess.cqxy.processManagermant.vo.ProgressManageTotalVo;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 过程管理 - 进度管理(BizProgressManage)-工程支付表服务接口
 *
 * @author 黎沐华
 * @since 2022-03-04 16:49:30
 */
public interface ProgressManageManager extends BaseManager<ProgressManage> {

    /**
     * 导入Excel数据
     * @param file 文件
     * @param projectId 项目ID
     */
    void importExcelData(MultipartFile file, String projectId, String contractId/**, String registerPersonId, String registerPersonName**/);

    boolean deleteByIds(List<String> ids);

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDataToExcel(QueryFilter<ProgressManage> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    ProgressManage getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 数据集合
     */
    PageList<ProgressManage> queryAllByPage(QueryFilter<ProgressManage> queryFilter);

    /**
     * 更新或保存数据
     * @param entity
     * @return
     */
    boolean saveOrUpdateEntity(ProgressManage entity);

    /**
     * 通过项目ID修改项目ID
     *
     * @param oldProjectIds
     * @param newProjectId
     *
     */
    void updateProjectIdByProiectId(String oldProjectIds, String newProjectId);

    /**
     * 根据条件查询每月投资情况
     * @param statisticsVo
     * @return
     */
    List<Map<String, Object>> queryInvestment(StatisticsVo statisticsVo);


    /**
     * 获取所有累计已拨款额（所有拨款额）
     * @param appropriatedlVo
     * @return
     */
    BigDecimal getAmountAppropriatedl(AppropriatedlVo appropriatedlVo);

    /**
     * 获取工程款累计已拨款额（工程款已拨款额）,不再使用
     * @param projectId
     * @param registerDate
     * @return
     */


    /**
     * 获取工程款累计已拨款额（除开工程款以外的拨款额）
     * @param projectId
     * @param registerDate
     * @return
     */
    BigDecimal getNotAppropriatedl(String projectId, String registerDate);

    /**
     * 根据ID导出西永微电园公司项目拨（付）款申请审批单
     * @param id
     * @param response
     * @throws IOException
     */
    void exportApprovalForm(String id, HttpServletResponse response) throws IOException;

    /**
     * 根据项目ID查询支付汇总数据（查看界面）
     * @param progressManageTotalVo
     * @return
     */
    ProgressManageTotalVo getProgressByProjectId(ProgressManageTotalVo progressManageTotalVo);

    /**
     * 通过项目ID查询有收款单位、账号、开户行的支付单子
     * @param projectId
     * @return
     */
    ProgressManage getProgressManageByProjectId(String projectId);

    /**
     * 通过项目ID查询项目支付总和
     * @param projectId
     * @return
     */
    BigDecimal geTamountAppropriatedTotalByProjectId(String projectId);

    /**
     * 通过项目ID和用途查询项目支付总和
     * @param projectId 项目ID
     * @param operation true就是查询包含的，false查询不包含
     * @param purpose 用途，多个使用逗号分隔
     * @return
     */
    BigDecimal geTamountAppropriatedTotalByProjectIdAndPurpose(String projectId, boolean operation, String purpose);

    List<ProgressManage> fundplanGetProgressManage(LambdaQueryWrapper<ProgressManage> lambdaQueryWrapper);

    BigDecimal getTwoPrice(String projectId,String purpose);

    void recalManage(String projectId);


}

