/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.processManagermant.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.contract.manager.ContractManager;
import com.artfess.cqxy.processManagermant.dao.ChangeManagementDao;
import com.artfess.cqxy.processManagermant.manager.ChangeManagementManager;
import com.artfess.cqxy.processManagermant.model.ChangeManagement;
import com.artfess.cqxy.projectManagement.dao.ProjectManagementDao;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.manager.ProjectPersonnelManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ChangeManagementManagerImpl
extends BaseManagerImpl<ChangeManagementDao, ChangeManagement>
implements ChangeManagementManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private ProjectManagementManager pm;
    @Autowired
    private ContractManager cm;
    @Autowired
    private SystemConfigFeignService scfs;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private GlobalRetrievalManager grm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private ChangeManagementDao changeManagementDao;
    @Autowired
    private ProjectPersonnelManager projectPersonnelManager;
    @Autowired
    private UCFeignService ucFeignService;
    @Autowired
    private ProjectManagementDao projectManagementDao;

    public boolean saveOrUpdate(ChangeManagement entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.eleven.getCode());
            ele.setGroup("ChangeManagement");
            ele.setNode(ProjectStatusEnum.eleven.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.eleven.getCode()));
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, ChangeManagement entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.sicteen.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.sicteen.getName());
        globalRetrieval.setBizTableName(FunctionEnum.sicteen.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.sicteen.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.sicteen.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.sicteen.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.sicteen.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.sicteen.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getChangeCode());
        globalRetrieval.setName(entity.getChangeName());
        globalRetrieval.setSearchTitle(entity.getChangeName() + "_" + entity.getChangeCode() + "_" + entity.getChangeContractName() + "_" + entity.getChangeUnit() + "_" + entity.getChangeReason() + "_" + entity.getChangeContent() + "_" + entity.getRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public ChangeManagement getById(String id) {
        ChangeManagement result = this.changeManagementDao.getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<ChangeManagement> queryAllByPage(QueryFilter<ChangeManagement> queryFilter) {
        List<String> projectList;
        queryFilter.addFilter("pm.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("bcm.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("pm.VALID_FLAG_", (Object)1, QueryOP.EQUAL);
        if (BizUtils.isProjectIdFields(queryFilter.getQuerys()).booleanValue() && null != (projectList = BizUtils.handProjectAuthByUser(this.ucFeignService, this.projectPersonnelManager, this.projectManagementDao)) && projectList.size() > 0) {
            queryFilter.addFilter("bcm.PROJECT_ID_", projectList, QueryOP.IN);
        }
        IPage<ChangeManagement> result = this.changeManagementDao.queryAllByPage((IPage<ChangeManagement>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ChangeManagement>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (ChangeManagement ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId, String contractId, String contractName) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        List chargeType = this.sdm.queryDictListItemsByCode("gcgl-bglx");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, ChangeManagement.class, (ImportParams)new ImportParams());
            for (ChangeManagement ele : data) {
                ele.setProjectId(projectId);
                ele.setChangeContractId(contractId);
                ele.setChangeContractName(contractName);
                ele.setChangeType(BizUtils.getDicCodeByValue(chargeType, ele.getChangeType()));
                String changeCode = this.scfs.getNextIdByAlias("gcgl_bgbh");
                ele.setChangeCode(changeCode.substring(StringUtils.lastOrdinalIndexOf((CharSequence)changeCode, (CharSequence)"\"", (int)2) + 1, changeCode.lastIndexOf("\"")));
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDataToExcel(QueryFilter<ChangeManagement> queryFilter, HttpServletResponse response) throws IOException {
        List chargeType = this.sdm.queryDictListItemsByCode("gcgl-bglx");
        queryFilter.getPageBean().setPage(-1);
        BizUtils.handleFilter(queryFilter, "bcm", false);
        List data = this.changeManagementDao.queryAllByPage((IPage<ChangeManagement>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ChangeManagement>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        String fileName = "\u8fc7\u7a0b\u7ba1\u7406-\u53d8\u66f4\u7ba1\u7406-\u5bfc\u51fa\u7ed3\u679c";
        for (ChangeManagement ele : data) {
            ele.setChangeType(BizUtils.getDicValueByCode((List<DictModel>)chargeType, ele.getChangeType()));
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, ChangeManagement.class, (Collection)data);
        workbook.getSheetAt(0).setColumnWidth(0, 5500);
        for (int i = 6; i < 9; ++i) {
            workbook.getSheetAt(0).setColumnWidth(i, 7000);
        }
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }

    @Override
    public List<Map<String, Object>> queryInvestment(StatisticsVo statisticsVo) {
        List<Map<String, Object>> list = ((ChangeManagementDao)this.baseMapper).queryInvestment(statisticsVo);
        if (null != list) {
            List chargeType = this.sdm.queryDictListItemsByCode("gcgl-bglx");
            for (Map<String, Object> map : list) {
                String type = String.valueOf(map.get("type"));
                map.put("typeName", BizUtils.getDicValueByCode((List<DictModel>)chargeType, type));
            }
        }
        return list;
    }

    @Override
    public List<Map<Integer, Object>> engineeringChangeNumber(StatisticsVo statisticsVo) {
        List<Map<String, Object>> list = ((ChangeManagementDao)this.baseMapper).engineeringChangeNumber(statisticsVo);
        ArrayList<Map<Integer, Object>> result = new ArrayList<Map<Integer, Object>>();
        if (null != list) {
            for (int m = 1; m <= 12; ++m) {
                boolean isMouth = true;
                for (Map<String, Object> map : list) {
                    Integer moutn = map.get("mouth") == null ? 0 : (Integer)map.get("mouth");
                    Object total = map.get("total");
                    if (m != moutn) continue;
                    HashMap<Integer, Object> mp = new HashMap<Integer, Object>();
                    mp.put(m, total);
                    result.add(mp);
                    isMouth = false;
                }
                if (!isMouth) continue;
                HashMap<Integer, Integer> mp = new HashMap<Integer, Integer>();
                mp.put(m, 0);
                result.add(mp);
            }
        }
        return result;
    }

    @Override
    public BigDecimal SumAmount2(String pid) {
        return ((ChangeManagementDao)this.baseMapper).SumAmount2(pid);
    }
}

