import Mock from "mockjs";
const { Random } = Mock;

const baseUrl = '/bizapi2/http-server-base/publish/cockpit/quota-v1';

// 需要暂时屏蔽掉未开通的省份
// 安徽、湖南、新疆、河北、江西
const ignoreOrgCodes = ["AH", "HN", "XJ", "HB", "JX"];

const baseUrlCharge = "/http-server-base/publish/quota-v1";
const NewBaseUrl = "/http-server-base/publish/cockpit/quota-v1";
const api = `/bizapi1${baseUrlCharge}`;
const Newapi = `/bizapi2${NewBaseUrl}`;

// dataMonitor
Mock.mock(`${baseUrl}/cloudCpuUsage`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "availableCpuCapacity": 1228,
            "cpuUsage": 53.3,
            "totalCpuCapacity": 2304
        }
    ]
});

Mock.mock(`${baseUrl}/cloudMemoryUsage`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "availableMemoryCapacity": "3664",
            "memoryUsage": 61.3,
            "totalMemoryCapacity": "5977"
        }
    ]
});

Mock.mock(`${baseUrl}/cloudStorageUsage`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "availableCapacity": 270.9,
            "storageUsage": 41.45,
            "totalCapacity": 653.5
        }
    ]
});

Mock.mock(`${baseUrl}/cloudphostCount`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "disablePhostCount": "0",
            "enablePhostCount": "12",
            "totalPhostCount": "12"
        }
    ]
});

Mock.mock(`${baseUrl}/cloudVhostCount`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "runningVhostCount": "61",
            "stopVhostCount": "19",
            "totalVhostCount": "80"
        }
    ]
});

Mock.mock(`${baseUrl}/cloudPhostCpuLoad?offMinute=3`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:00:35",
            "utilization": 16.34
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:01:06",
            "utilization": 15.14
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:01:36",
            "utilization": 14.23
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:02:06",
            "utilization": 15.19
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:02:36",
            "utilization": 16.23
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:03:07",
            "utilization": 15.66
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:03:36",
            "utilization": 14.52
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:04:06",
            "utilization": 15.61
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:04:37",
            "utilization": 15.67
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:05:07",
            "utilization": 17.64
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:05:36",
            "utilization": 21.02
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:06:05",
            "utilization": 17.06
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:06:36",
            "utilization": 17.09
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:07:04",
            "utilization": 18.73
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:07:35",
            "utilization": 15.93
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:08:05",
            "utilization": 16.87
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:08:35",
            "utilization": 16.39
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:09:06",
            "utilization": 15.31
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:09:36",
            "utilization": 14.78
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:10:09",
            "utilization": 15.85
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:10:36",
            "utilization": 15.34
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:11:05",
            "utilization": 14.87
        }
    ]
});

Mock.mock(`${baseUrl}/cloudPhostMemoryLoad?offMinute=3`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:00:38",
            "usePercent": 56.63
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:01:05",
            "usePercent": 56.63
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:01:38",
            "usePercent": 56.64
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:02:07",
            "usePercent": 56.63
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:02:36",
            "usePercent": 56.64
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:03:07",
            "usePercent": 56.64
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:03:35",
            "usePercent": 56.63
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:04:10",
            "usePercent": 56.64
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:04:38",
            "usePercent": 56.63
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:05:07",
            "usePercent": 56.64
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:05:36",
            "usePercent": 56.64
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:06:07",
            "usePercent": 56.63
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:06:36",
            "usePercent": 56.64
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:07:06",
            "usePercent": 56.63
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:07:35",
            "usePercent": 56.64
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:08:05",
            "usePercent": 56.64
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:08:37",
            "usePercent": 56.64
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:09:05",
            "usePercent": 56.64
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:09:36",
            "usePercent": 56.64
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:10:06",
            "usePercent": 56.64
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:10:36",
            "usePercent": 56.64
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:11:07",
            "usePercent": 56.64
        }
    ]
});

Mock.mock(`${baseUrl}/cloudPhostNetworkIn?offMinute=3`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "dateFlag": "2025-02-14",
            "inBytes": 55.47,
            "shotTime": "14:01:34"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 50.69,
            "shotTime": "14:02:06"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 41.26,
            "shotTime": "14:02:33"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 57.12,
            "shotTime": "14:03:06"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 56.36,
            "shotTime": "14:03:35"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 45.52,
            "shotTime": "14:04:09"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 54.56,
            "shotTime": "14:04:36"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 41.8,
            "shotTime": "14:05:11"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 55.2,
            "shotTime": "14:05:35"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 51.5,
            "shotTime": "14:06:07"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 40.64,
            "shotTime": "14:06:34"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 57.37,
            "shotTime": "14:07:04"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 60.27,
            "shotTime": "14:07:35"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 41.25,
            "shotTime": "14:08:05"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 45.06,
            "shotTime": "14:08:34"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 49.14,
            "shotTime": "14:09:05"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 50.32,
            "shotTime": "14:09:34"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 51.3,
            "shotTime": "14:10:10"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 45.26,
            "shotTime": "14:10:36"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 42.9,
            "shotTime": "14:11:07"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 52.01,
            "shotTime": "14:11:36"
        },
        {
            "dateFlag": "2025-02-14",
            "inBytes": 47.68,
            "shotTime": "14:12:04"
        }
    ]
});

Mock.mock(`${baseUrl}/cloudPhostNetworkOut?offMinute=3`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "dateFlag": "2025-02-14",
            "outBytes": 22.61,
            "shotTime": "14:00:35"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 27.32,
            "shotTime": "14:01:07"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 26.1,
            "shotTime": "14:01:38"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 33.09,
            "shotTime": "14:02:06"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 26.24,
            "shotTime": "14:02:36"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 35.71,
            "shotTime": "14:03:07"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 33.24,
            "shotTime": "14:03:35"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 28.78,
            "shotTime": "14:04:04"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 28.3,
            "shotTime": "14:04:38"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 32.13,
            "shotTime": "14:05:05"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 29.51,
            "shotTime": "14:05:36"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 41.71,
            "shotTime": "14:06:06"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 31.23,
            "shotTime": "14:06:37"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 32.19,
            "shotTime": "14:07:06"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 32.33,
            "shotTime": "14:07:36"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 16.87,
            "shotTime": "14:08:06"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 37.41,
            "shotTime": "14:08:37"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 45.62,
            "shotTime": "14:09:05"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 26.78,
            "shotTime": "14:09:36"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 28.25,
            "shotTime": "14:10:10"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 35.89,
            "shotTime": "14:10:36"
        },
        {
            "dateFlag": "2025-02-14",
            "outBytes": 23.41,
            "shotTime": "14:11:10"
        }
    ]
});

Mock.mock(`${baseUrl}/cloudPhostDiskWrite?offMinute=3`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:00:34",
            "writeBytes": 4251.6
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:01:06",
            "writeBytes": 3872.01
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:01:36",
            "writeBytes": 714.39
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:02:06",
            "writeBytes": 3967.6
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:02:36",
            "writeBytes": 1115.99
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:03:06",
            "writeBytes": 3797.14
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:03:36",
            "writeBytes": 3865.99
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:04:07",
            "writeBytes": 3902
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:04:36",
            "writeBytes": 865.6
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:05:11",
            "writeBytes": 1043.2
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:05:36",
            "writeBytes": 4562.4
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:06:05",
            "writeBytes": 635.2
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:06:36",
            "writeBytes": 4047.19
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:07:05",
            "writeBytes": 823.6
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:07:35",
            "writeBytes": 900.8
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:08:05",
            "writeBytes": 4177.6
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:08:35",
            "writeBytes": 718
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:09:06",
            "writeBytes": 4020.01
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:09:36",
            "writeBytes": 3857.6
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:10:08",
            "writeBytes": 550
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:10:36",
            "writeBytes": 3752
        },
        {
            "dateFlag": "2025-02-14",
            "shotTime": "14:11:05",
            "writeBytes": 4147.19
        }
    ]
});

Mock.mock(`${baseUrl}/cloudPhostDiskRead?offMinute=3`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "dateFlag": "2025-02-14",
            "readBytes": 384,
            "shotTime": "14:00:37"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 422.26,
            "shotTime": "14:01:06"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 345.61,
            "shotTime": "14:01:38"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 332.8,
            "shotTime": "14:02:05"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 345.6,
            "shotTime": "14:02:36"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 345.79,
            "shotTime": "14:03:07"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 294.4,
            "shotTime": "14:03:35"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 307.2,
            "shotTime": "14:04:05"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 345.6,
            "shotTime": "14:04:36"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 345.6,
            "shotTime": "14:05:10"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 384,
            "shotTime": "14:05:36"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 294.4,
            "shotTime": "14:06:06"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 345.6,
            "shotTime": "14:06:36"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 294.4,
            "shotTime": "14:07:06"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 294.4,
            "shotTime": "14:07:35"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 345.6,
            "shotTime": "14:08:07"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 345.6,
            "shotTime": "14:08:37"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 332.8,
            "shotTime": "14:09:05"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 307.19,
            "shotTime": "14:09:36"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 307.2,
            "shotTime": "14:10:09"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 307.19,
            "shotTime": "14:10:36"
        },
        {
            "dateFlag": "2025-02-14",
            "readBytes": 345.6,
            "shotTime": "14:11:09"
        }
    ]
});

Mock.mock(`${baseUrl}/videoIdStatusCount?level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "normalCount": "5803",
            "normalPercent": 90.02,
            "orgCode": "CQ",
            "orgName": "重庆",
            "totalCount": "6446"
        },
        {
            "normalCount": "1328",
            "normalPercent": 94.99,
            "orgCode": "GZ",
            "orgName": "贵州",
            "totalCount": "1398"
        },
        {
            "normalCount": "1172",
            "normalPercent": 99.58,
            "orgCode": "YN",
            "orgName": "云南",
            "totalCount": "1177"
        }
    ]
});

Mock.mock(`${baseUrl}/tollDataMonitor?level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "flowUploadCount": "61",
            "gantryUploadCount": "164",
            "orgCode": "CQ",
            "orgName": "重庆",
            "stationLoadCount": "61"
        },
        {
            "flowUploadCount": "0",
            "gantryUploadCount": "24",
            "orgCode": "SC",
            "orgName": "四川",
            "stationLoadCount": "0"
        },
        {
            "flowUploadCount": "5",
            "gantryUploadCount": "12",
            "orgCode": "YN",
            "orgName": "云南",
            "stationLoadCount": "0"
        }
    ]
});

Mock.mock(`${baseUrl}/elecDataMonitor?level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "connectCount": "733",
            "fineCount": "690",
            "finePercent": 4.56,
            "orgCode": "CQ",
            "orgName": "重庆",
            "totalCount": "15125"
        },
        {
            "connectCount": "0",
            "fineCount": "0",
            "finePercent": 0,
            "orgCode": "SC",
            "orgName": "四川",
            "totalCount": "793"
        },
        {
            "connectCount": "0",
            "fineCount": "0",
            "finePercent": 0,
            "orgCode": "YN",
            "orgName": "云南",
            "totalCount": "500"
        }
    ]
});

Mock.mock(`${baseUrl}/dataApiMonitor`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "handleTime": null,
            "jobDesc": "WS_机电状态&显示_石黔",
            "jobId": 7,
            "runStatus": "失败"
        },
        {
            "handleTime": null,
            "jobDesc": "WS_机电状态&显示_大内",
            "jobId": 8,
            "runStatus": "失败"
        },
        {
            "handleTime": null,
            "jobDesc": "WS_机电状态&显示_合安",
            "jobId": 10,
            "runStatus": "失败"
        },
        {
            "handleTime": null,
            "jobDesc": "WS_机电状态&显示_潼荣",
            "jobId": 11,
            "runStatus": "失败"
        },
        {
            "handleTime": null,
            "jobDesc": "WS_机电状态&显示_秀松",
            "jobId": 12,
            "runStatus": "失败"
        },
        {
            "handleTime": null,
            "jobDesc": "WS_机电状态&显示_永泸",
            "jobId": 13,
            "runStatus": "失败"
        },
        {
            "handleTime": null,
            "jobDesc": "WS_机电状态&显示_渝遂",
            "jobId": 14,
            "runStatus": "失败"
        },
        {
            "handleTime": null,
            "jobDesc": "WS_机电状态&显示_渝筑",
            "jobId": 15,
            "runStatus": "失败"
        },
        {
            "handleTime": "2025-02-14 00:43:00",
            "jobDesc": "HTTP_机电设备信息_遂德",
            "jobId": 19,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 09:02:21",
            "jobDesc": "HTTP_离线时长_旧",
            "jobId": 21,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:02:47",
            "jobDesc": "HTTP_机电设备信息_合安",
            "jobId": 22,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:02:47",
            "jobDesc": "HTTP_机电设备信息_大内",
            "jobId": 23,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:02:44",
            "jobDesc": "HTTP_机电设备信息_石黔",
            "jobId": 24,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:11:44",
            "jobDesc": "HTTP_机电设备信息_秀松",
            "jobId": 25,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:02:47",
            "jobDesc": "HTTP_机电设备信息_渝筑",
            "jobId": 26,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:02:47",
            "jobDesc": "HTTP_机电设备信息_永泸",
            "jobId": 27,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:00:33",
            "jobDesc": "HTTP_在线状态_旧",
            "jobId": 28,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:05:40",
            "jobDesc": "HTTP_收费站减免费用",
            "jobId": 40,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:00:08",
            "jobDesc": "HTTP_门架数据上传状态",
            "jobId": 41,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:05:44",
            "jobDesc": "HTTP_门架交易数据统计（五分钟一次）",
            "jobId": 42,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:04:22",
            "jobDesc": "HTTP_收费站支付方式统计",
            "jobId": 43,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:03:39",
            "jobDesc": "HTTP_特情处理统计",
            "jobId": 44,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:11:42",
            "jobDesc": "HTTP_门架成功率统计",
            "jobId": 45,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 03:05:22",
            "jobDesc": "中间库_bigdataform_前一天数据",
            "jobId": 46,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:06:10",
            "jobDesc": "HTTP_收费站基础数据",
            "jobId": 49,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:20:10",
            "jobDesc": "HTTP_门架基础数据",
            "jobId": 50,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:05:09",
            "jobDesc": "HTTP_特情数量统计",
            "jobId": 51,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:05:36",
            "jobDesc": "HTTP_收费站交易数据统计",
            "jobId": 52,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:05:18",
            "jobDesc": "HTTP_门架交易数据统计",
            "jobId": 53,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:05:07",
            "jobDesc": "HTTP_获取支付方式",
            "jobId": 54,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:04:11",
            "jobDesc": "HTTP_门架收费站基础数据统计",
            "jobId": 55,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:04:22",
            "jobDesc": "HTTP_路段汇总统计_门架",
            "jobId": 56,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:04:25",
            "jobDesc": "HTTP_路段汇总统计_收费站",
            "jobId": 57,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:03:39",
            "jobDesc": "HTTP_车种路段汇总统计_门架",
            "jobId": 58,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:03:42",
            "jobDesc": "HTTP_车种路段汇总统计_收费站",
            "jobId": 59,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:04:22",
            "jobDesc": "HTTP_车型路段汇总统计_门架",
            "jobId": 60,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:04:22",
            "jobDesc": "HTTP_车型路段汇总统计_收费站",
            "jobId": 61,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:03:39",
            "jobDesc": "HTTP_车种路段汇总统计_收费站入口车流量",
            "jobId": 62,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:03:39",
            "jobDesc": "HTTP_车型路段汇总统计_收费站入口车流量",
            "jobId": 63,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 03:26:22",
            "jobDesc": "中间库_清分数据_遂德",
            "jobId": 64,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 13:00:11",
            "jobDesc": "中间库_服务区车流量统计_车型",
            "jobId": 65,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 13:00:11",
            "jobDesc": "中间库_服务区总车流量统计",
            "jobId": 66,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:00:11",
            "jobDesc": "中间库_门架心跳数据统计",
            "jobId": 67,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:15:11",
            "jobDesc": "中间库_收费快报数据统计_昆楚",
            "jobId": 68,
            "runStatus": "成功"
        },
        {
            "handleTime": "2023-07-10 10:52:48",
            "jobDesc": "中间库_bigdataform_全量数据",
            "jobId": 69,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:15:54",
            "jobDesc": "HTTP_工单执行状况统计_月度（业务概况）",
            "jobId": 70,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:20:51",
            "jobDesc": "HTTP_工单执行状况统计_年度（业务概况）",
            "jobId": 71,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:19:43",
            "jobDesc": "HTTP_经常/定期检查信息明细（业务概况）",
            "jobId": 72,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:18:46",
            "jobDesc": "HTTP_预算金额明细统计（业务概况）",
            "jobId": 73,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:18:39",
            "jobDesc": "HTTP_养护专项个数统计（业务概况）",
            "jobId": 74,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:18:44",
            "jobDesc": "HTTP_养护车辆详情信息统计（业务概况）",
            "jobId": 75,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:18:48",
            "jobDesc": "HTTP_养护工单信息（业务概况）",
            "jobId": 76,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:17:44",
            "jobDesc": "HTTP_日/夜巡检信息（业务概况）",
            "jobId": 77,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:17:45",
            "jobDesc": "HTTP_病害类型统计（业务概况）",
            "jobId": 78,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:17:44",
            "jobDesc": "HTTP_病害平均处理天数统计（业务概况）",
            "jobId": 79,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:17:44",
            "jobDesc": "HTTP_病害数量统计（业务概况）",
            "jobId": 80,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:22:36",
            "jobDesc": "HTTP_工单详情信息统计（业务概况）",
            "jobId": 81,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:15:45",
            "jobDesc": "HTTP_养护金额总数统计（业务概况）",
            "jobId": 82,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:15:39",
            "jobDesc": "HTTP_年预算金额统计（业务概况）",
            "jobId": 83,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:15:40",
            "jobDesc": "HTTP_经常/定期检查信息（业务概况）",
            "jobId": 84,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:15:46",
            "jobDesc": "HTTP_养护车辆数量统计（业务概况）",
            "jobId": 85,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:15:46",
            "jobDesc": "HTTP_养护站个数统计（基础概况）",
            "jobId": 86,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:12:43",
            "jobDesc": "HTTP_各个公司人员数统计（基础概况）",
            "jobId": 87,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 03:00:51",
            "jobDesc": "video_分页区域列表",
            "jobId": 88,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 03:10:08",
            "jobDesc": "video_监控点资源",
            "jobId": 89,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:01:30",
            "jobDesc": "video_车辆监控点资源",
            "jobId": 90,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 10:00:22",
            "jobDesc": "HTTP_离线时长_新",
            "jobId": 91,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 14:00:10",
            "jobDesc": "HTTP_在线状态_新",
            "jobId": 92,
            "runStatus": "成功"
        },
        {
            "handleTime": "2024-04-28 04:30:29",
            "jobDesc": "HTTP_服务区店铺档案",
            "jobId": 93,
            "runStatus": "成功"
        },
        {
            "handleTime": "2024-07-09 17:34:05",
            "jobDesc": "HTTP_服务区店铺日销售",
            "jobId": 94,
            "runStatus": "成功"
        },
        {
            "handleTime": "2024-04-28 05:05:29",
            "jobDesc": "HTTP_服务区单品日销售",
            "jobId": 95,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:02:45",
            "jobDesc": "HTTP_机电设备信息_潼荣",
            "jobId": 96,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:02:44",
            "jobDesc": "HTTP_机电设备信息_渝遂",
            "jobId": 97,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:12:42",
            "jobDesc": "HTTP_里程排行统计（基础概况）",
            "jobId": 98,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:12:50",
            "jobDesc": "HTTP_病害详情（基础概况）",
            "jobId": 99,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:12:42",
            "jobDesc": "HTTP_养护车辆统计（基础概况）",
            "jobId": 101,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:11:52",
            "jobDesc": "HTTP_养护工区、应急物资库、救援点的物资类型及数量（基础概况）",
            "jobId": 102,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:11:51",
            "jobDesc": "HTTP_养护工区（基础概况）",
            "jobId": 103,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:10:45",
            "jobDesc": "HTTP_养护工区、应急物资库、救援点的结构物车辆（基础概况）",
            "jobId": 104,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:10:46",
            "jobDesc": "HTTP_救援点（基础概况）",
            "jobId": 105,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 01:10:46",
            "jobDesc": "HTTP_应急物资库（基础概况）",
            "jobId": 106,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:05:49",
            "jobDesc": "HTTP_沿线设施信息",
            "jobId": 107,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:05:49",
            "jobDesc": "HTTP_隧道信息",
            "jobId": 108,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:05:44",
            "jobDesc": "HTTP_边坡信息",
            "jobId": 109,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:05:49",
            "jobDesc": "HTTP_涵洞信息",
            "jobId": 111,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:05:52",
            "jobDesc": "HTTP_桥梁信息",
            "jobId": 112,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:05:43",
            "jobDesc": "HTTP_路段信息",
            "jobId": 113,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:05:43",
            "jobDesc": "HTTP_路线信息",
            "jobId": 114,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 13:50:38",
            "jobDesc": "HTTP_巡查救援_救援信息列表",
            "jobId": 115,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 13:42:43",
            "jobDesc": "HTTP_巡查救援_道路巡查记录列表",
            "jobId": 116,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 13:43:10",
            "jobDesc": "HTTP_巡查救援_事件信息列表",
            "jobId": 117,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-11 09:44:29",
            "jobDesc": "HTTP_机电系统设备数量统计（新）",
            "jobId": 118,
            "runStatus": "成功"
        },
        {
            "handleTime": "2025-02-14 00:09:11",
            "jobDesc": "HTTP_清分数据更新（新）",
            "jobId": 119,
            "runStatus": "成功"
        },
        {
            "handleTime": "2023-04-10 10:19:57",
            "jobDesc": "HTTP_机电系统设备数量统计（旧）",
            "jobId": 129,
            "runStatus": "成功"
        },
        {
            "handleTime": "2023-06-16 17:57:21",
            "jobDesc": "HTTP_清分数据更新（旧）",
            "jobId": 130,
            "runStatus": "成功"
        }
    ]
});

//charge
Mock.mock(`${api}/reduceFee?timemode=year&timeflag=2025&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "reduceAmount": 3214.390373,
            "timeFlag": "2025"
        }
    ]
});

Mock.mock(`${api}/gateupdatastatus?status=&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "direction": "1",
            "gateCode": "S000950001000810010",
            "gateName": "龙形枢纽（潼荣）-潼南北",
            "orgCode": "103",
            "orgName": "第三管理中心",
            "organCode": "70",
            "province": "重庆",
            "provinceId": "CQ",
            "sectionCode": "1430053229818941440",
            "sectionName": "合安高速",
            "status": "正常"
        },
        {
            "direction": "2",
            "gateCode": "S005550001000520010",
            "gateName": "塘坝收费站-田家枢纽立交（渝遂）",
            "orgCode": "102",
            "orgName": "第二管理中心",
            "organCode": "64",
            "province": "重庆",
            "provinceId": "CQ",
            "sectionCode": "1430052457714683904",
            "sectionName": "潼荣高速",
            "status": "正常"
        },
        {
            "direction": "1",
            "gateCode": "G562153002000510010",
            "gateName": "昆楚接武易-谷律站（上行）",
            "orgCode": "401",
            "orgName": "第一管理中心",
            "organCode": "94",
            "province": "云南",
            "provinceId": "YN",
            "sectionCode": "1551973630102081536",
            "sectionName": "昆楚高速",
            "status": "正常"
        },
        {
            "direction": "1",
            "gateCode": "S000950001000110010",
            "gateName": "双凤枢纽（三环）-云门北",
            "orgCode": "103",
            "orgName": "第三管理中心",
            "organCode": "70",
            "province": "重庆",
            "provinceId": "CQ",
            "sectionCode": "1430053229818941440",
            "sectionName": "合安高速",
            "status": "正常"
        },
        {
            "direction": "2",
            "gateCode": "G562153002000520010",
            "gateName": "谷律站-昆楚接武易（下行）",
            "orgCode": "401",
            "orgName": "第一管理中心",
            "organCode": "94",
            "province": "云南",
            "provinceId": "YN",
            "sectionCode": "1551973630102081536",
            "sectionName": "昆楚高速",
            "status": "正常"
        },
        {
            "direction": "1",
            "gateCode": "S000950001000610010",
            "gateName": "隆兴-龙形",
            "orgCode": "103",
            "orgName": "第三管理中心",
            "organCode": "70",
            "province": "重庆",
            "provinceId": "CQ",
            "sectionCode": "1430053229818941440",
            "sectionName": "合安高速",
            "status": "正常"
        },
        {
            "direction": "2",
            "gateCode": "S000950001000920010",
            "gateName": "双江枢纽（渝遂）-潼南北",
            "orgCode": "103",
            "orgName": "第三管理中心",
            "organCode": "70",
            "province": "重庆",
            "provinceId": "CQ",
            "sectionCode": "1430053229818941440",
            "sectionName": "合安高速",
            "status": "正常"
        },
        {
            "direction": "2",
            "gateCode": "S005550001000820010",
            "gateName": "三驱枢纽立交（渝蓉）-龙岗收费站",
            "orgCode": "102",
            "orgName": "第二管理中心",
            "organCode": "64",
            "province": "重庆",
            "provinceId": "CQ",
            "sectionCode": "1430052457714683904",
            "sectionName": "潼荣高速",
            "status": "正常"
        },
        {
            "direction": "2",
            "gateCode": "G752150001001020010",
            "gateName": "赶水南-万盛南",
            "orgCode": "105",
            "orgName": "第五管理中心",
            "organCode": "77",
            "province": "重庆",
            "provinceId": "CQ",
            "sectionCode": "1494144408961028096",
            "sectionName": "渝筑高速",
            "status": "正常"
        },
        {
            "direction": "2",
            "gateCode": "S003450001000320010",
            "gateName": "铜鼓-季家",
            "orgCode": "102",
            "orgName": "第二管理中心",
            "organCode": "76",
            "province": "重庆",
            "provinceId": "CQ",
            "sectionCode": "1493834264024846336",
            "sectionName": "大内高速",
            "status": "正常"
        },
        {
            "direction": "1",
            "gateCode": "G562153002000110010",
            "gateName": "昆楚接楚大-一平浪站（上行）",
            "orgCode": "401",
            "orgName": "第一管理中心",
            "organCode": "94",
            "province": "云南",
            "provinceId": "YN",
            "sectionCode": "1551973630102081536",
            "sectionName": "昆楚高速",
            "status": "正常"
        },
        {
            "direction": "2",
            "gateCode": "S005350001000320010",
            "gateName": "团坝枢纽（渝遂）-依凤",
            "orgCode": "103",
            "orgName": "第三管理中心",
            "organCode": "80",
            "province": "重庆",
            "provinceId": "CQ",
            "sectionCode": "1612639944117981184",
            "sectionName": "合璧津高速",
            "status": "正常"
        },
        {
            "direction": "2",
            "gateCode": "G009350001001220010",
            "gateName": "绕城渝遂立交-璧山北",
            "orgCode": "101",
            "orgName": "第一管理中心",
            "organCode": "30",
            "province": "重庆",
            "provinceId": "CQ",
            "sectionCode": "1430049550537723904",
            "sectionName": "渝遂高速",
            "status": "正常"
        }
    ]
});

Mock.mock(`${api}/dayAvgFlowcount?timemode=year&timeflag=2025&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "amount": 2134305.48,
            "avgamount": 496.35,
            "avgamountperlen": 0.47,
            "avgclearamount": 713.93,
            "avgclearamountperlen": 0.68,
            "avgflowcount": 25.55,
            "dayCount": "43",
            "flowCount": 10987784
        }
    ]
});

Mock.mock(`${api}/daySpecialnum?timemode=year&timeflag=2025&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": []
});

Mock.mock(`${api}/yearTruckFlow?timemode=year&timeflag=2025&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "huoFlowCount": 1352833,
            "keFlowCount": 9620383,
            "timeFlag": "2025"
        }
    ]
});

Mock.mock(`${api}/currentDayFee?day=20250213&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": []
});

Mock.mock(`${api}/qingfenAmount?timemode=year&timeflag=2025&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "amountRate": 12.69,
            "budget": 241850,
            "clearEndDate": "2025-01-30",
            "clearStartDate": "2025-01-01",
            "qingfenAmount": 30699.05
        }
    ]
});

Mock.mock(`${api}/yearEtcFlow?year=2025&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "etcFlowcount": 5903133,
            "flowCount": 10304501,
            "substr(timeFlag, 1, 4)": "2025"
        }
    ]
});

Mock.mock(`${api}/gateSummary?timemode=month&timeflag=202501&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "etcFeeSum": 6088.54,
            "feeSum": 22462.48,
            "flowCount": 31655456,
            "otherFeeSum": 16373.94
        }
    ]
});

Mock.mock(`${api}/gateSummaryChild?timemode=month&timeflag=202501&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "etcFeeSum": 0,
            "feeSum": 0,
            "flowCount": 0,
            "orgCode": "AH",
            "orgName": "安徽",
            "otherFeeSum": 0
        },
        {
            "etcFeeSum": 5548.14,
            "feeSum": 20767.15,
            "flowCount": 30637529,
            "orgCode": "CQ",
            "orgName": "重庆",
            "otherFeeSum": 15219.01
        },
        {
            "etcFeeSum": 0,
            "feeSum": 0,
            "flowCount": 0,
            "orgCode": "GZ",
            "orgName": "贵州",
            "otherFeeSum": 0
        },
        {
            "etcFeeSum": 0,
            "feeSum": 0,
            "flowCount": 0,
            "orgCode": "HN",
            "orgName": "湖南",
            "otherFeeSum": 0
        },
        {
            "etcFeeSum": 0,
            "feeSum": 0,
            "flowCount": 0,
            "orgCode": "SC",
            "orgName": "四川",
            "otherFeeSum": 0
        },
        {
            "etcFeeSum": 540.4,
            "feeSum": 1695.33,
            "flowCount": 1017927,
            "orgCode": "YN",
            "orgName": "云南",
            "otherFeeSum": 1154.93
        }
    ]
});

Mock.mock(`${api}/inOutSummary?timemode=month&timeflag=202501&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "enflowCount": 3570808,
            "exflowCount": 3584682,
            "feeSum": 15792,
            "flowCount": 7155490
        }
    ]
});

Mock.mock(`${api}/inOutSummaryChild?timemode=month&timeflag=202501&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "enflowCount": 0,
            "exflowCount": 0,
            "feeSum": 0,
            "flowCount": 0,
            "orgCode": "AH",
            "orgName": "安徽"
        },
        {
            "enflowCount": 3570808,
            "exflowCount": 3584682,
            "feeSum": 15792,
            "flowCount": 7155490,
            "orgCode": "CQ",
            "orgName": "重庆"
        },
        {
            "enflowCount": 0,
            "exflowCount": 0,
            "feeSum": 0,
            "flowCount": 0,
            "orgCode": "GZ",
            "orgName": "贵州"
        },
        {
            "enflowCount": 0,
            "exflowCount": 0,
            "feeSum": 0,
            "flowCount": 0,
            "orgCode": "HN",
            "orgName": "湖南"
        },
        {
            "enflowCount": 0,
            "exflowCount": 0,
            "feeSum": 0,
            "flowCount": 0,
            "orgCode": "SC",
            "orgName": "四川"
        },
        {
            "enflowCount": 0,
            "exflowCount": 0,
            "feeSum": 0,
            "flowCount": 0,
            "orgCode": "YN",
            "orgName": "云南"
        }
    ]
});

Mock.mock(`${api}/fiveminGateFlowfee?level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
    {
        "feeSum": 132229.06,
        "flowCount": 7081,
        "gantryId": "G009350001001010010",
        "gantryName": "铜梁东-大路",
        "oldFeeSum": 130783.78,
        "oldFlowCount": 6999,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 127604.79,
        "flowCount": 6641,
        "gantryId": "G009350001001020010",
        "gantryName": "大路-铜梁东",
        "oldFeeSum": 126246.8,
        "oldFlowCount": 6562,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 94281.34,
        "flowCount": 6217,
        "gantryId": "G009350001000520010",
        "gantryName": "少云-潼南东（田家）",
        "oldFeeSum": 93214.58,
        "oldFlowCount": 6129,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 92384.84,
        "flowCount": 7531,
        "gantryId": "G009350001000620010",
        "gantryName": "铜梁立交-少云 ",
        "oldFeeSum": 91495.23,
        "oldFlowCount": 7440,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 84489.46,
        "flowCount": 6265,
        "gantryId": "G009350001000510010",
        "gantryName": "潼南东（田家）-少云",
        "oldFeeSum": 83352.58,
        "oldFlowCount": 6176,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 72014.69,
        "flowCount": 4768,
        "gantryId": "S006350001000110010",
        "gantryName": "秀山东立交（秀松）-秀山南",
        "oldFeeSum": 71605.15,
        "oldFlowCount": 4739,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 68088.77,
        "flowCount": 7255,
        "gantryId": "G009350001000610010",
        "gantryName": "少云-铜梁立交 ",
        "oldFeeSum": 67292.32,
        "oldFlowCount": 7152,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 63820.41,
        "flowCount": 4461,
        "gantryId": "S006350001000120010",
        "gantryName": "秀山南-秀山东立交（秀松）",
        "oldFeeSum": 63471.62,
        "oldFlowCount": 4434,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 61700.51,
        "flowCount": 3261,
        "gantryId": "G551550001500210010",
        "gantryName": "六塘-龙潭河",
        "oldFeeSum": 61248.27,
        "oldFlowCount": 3235,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 55179.91,
        "flowCount": 3218,
        "gantryId": "G551550001500410010",
        "gantryName": "马武坝-连湖",
        "oldFeeSum": 54587.34,
        "oldFlowCount": 3188,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 48427.27,
        "flowCount": 3669,
        "gantryId": "G551550001500510010",
        "gantryName": "连湖-黑溪",
        "oldFeeSum": 48010.12,
        "oldFlowCount": 3640,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 45410.56,
        "flowCount": 5668,
        "gantryId": "G551550001500710010",
        "gantryName": "石会-册山枢纽互通",
        "oldFeeSum": 45067.01,
        "oldFlowCount": 5620,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 42679.12,
        "flowCount": 3827,
        "gantryId": "G752150001000510010",
        "gantryName": "接龙南-隆盛",
        "oldFeeSum": 42325.92,
        "oldFlowCount": 3786,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 40657.28,
        "flowCount": 5506,
        "gantryId": "S006350001000210010",
        "gantryName": "秀山南-梅江",
        "oldFeeSum": 40394.92,
        "oldFlowCount": 5466,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 39619.05,
        "flowCount": 3618,
        "gantryId": "G752150001000520010",
        "gantryName": "隆盛-接龙南",
        "oldFeeSum": 39198.28,
        "oldFlowCount": 3576,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 39525.54,
        "flowCount": 2998,
        "gantryId": "G752150001001010010",
        "gantryName": "万盛南-赶水南",
        "oldFeeSum": 39163.29,
        "oldFlowCount": 2969,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 39035.54,
        "flowCount": 9832,
        "gantryId": "G009350001001110010",
        "gantryName": "大路-璧山北",
        "oldFeeSum": 38559.22,
        "oldFlowCount": 9696,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 38612.33,
        "flowCount": 3593,
        "gantryId": "G752150001000810010",
        "gantryName": "南桐枢纽-青年",
        "oldFeeSum": 38155.85,
        "oldFlowCount": 3544,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 37215.56,
        "flowCount": 10626,
        "gantryId": "G009350001001120010",
        "gantryName": "璧山北-大路",
        "oldFeeSum": 36779.93,
        "oldFlowCount": 10502,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 37089.7,
        "flowCount": 5038,
        "gantryId": "S006350001000220010",
        "gantryName": "梅江-秀山南",
        "oldFeeSum": 36850.26,
        "oldFlowCount": 5001,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 36763.13,
        "flowCount": 5716,
        "gantryId": "S000450001000110010",
        "gantryName": "歇马枢纽-七塘互通",
        "oldFeeSum": 36416.28,
        "oldFlowCount": 5658,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 33217.16,
        "flowCount": 9744,
        "gantryId": "G009350001001210010",
        "gantryName": "璧山北-绕城渝遂立交",
        "oldFeeSum": 32911.67,
        "oldFlowCount": 9642,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 33185.8,
        "flowCount": 5417,
        "gantryId": "G551550001500610010",
        "gantryName": "黑溪-石会",
        "oldFeeSum": 32853.02,
        "oldFlowCount": 5365,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 32946.3,
        "flowCount": 9699,
        "gantryId": "G009350001001220010",
        "gantryName": "绕城渝遂立交-璧山北",
        "oldFeeSum": 32503.29,
        "oldFlowCount": 9575,
        "timeFlag": "202502141605"
    },
    {
        "feeSum": 32797.28,
        "flowCount": 3881,
        "gantryId": "G752150001000410010",
        "gantryName": "太平枢纽-接龙南",
        "oldFeeSum": 32490.03,
        "oldFlowCount": 3845,
        "timeFlag": "202502141605"
    },
]
});

Mock.mock(`${api}/gateSuccessRate?timeflag=202502&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "cardTradeCount": 1818351,
            "cardTradeSuccess": 1792852,
            "cardTradeSuccessRate": 0.9200541520349974,
            "cpcPlaterecoSuccessRate": 0.588466219726284,
            "cpcTradeCount": 556697,
            "cpcTradeSuccess": 497996,
            "cpcTradeSuccessRate": 0.8738134927545576,
            "etcPlaterecoSuccessRate": 0.49633718352223744,
            "obuTradeCount": 1818204,
            "obuTradeSuccess": 1802481,
            "obuTradeSuccessRate": 0.9291454783583248,
            "platerecoCount": 13912175,
            "platerecoSuccess": 6098809,
            "timeFlag": "202502"
        }
    ]
});

Mock.mock(`${api}/truckornot?day=20250214&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "cartype": "货车",
            "feeSum": 79547367,
            "feeSumPer": 0.494,
            "feeSumSum": 161026113,
            "flowCount": 12321,
            "flowCountPer": 0.226,
            "flowCountSum": 54510,
            "timeFlag": "20250214"
        },
        {
            "cartype": "客车",
            "feeSum": 81080282,
            "feeSumPer": 0.5035,
            "feeSumSum": 161026113,
            "flowCount": 42015,
            "flowCountPer": 0.7708,
            "flowCountSum": 54510,
            "timeFlag": "20250214"
        },
        {
            "cartype": "其他",
            "feeSum": 398464,
            "feeSumPer": 0.0025,
            "feeSumSum": 161026113,
            "flowCount": 174,
            "flowCountPer": 0.0032,
            "flowCountSum": 54510,
            "timeFlag": "20250214"
        }
    ]
});

Mock.mock(`${api}/cashornot?day=20250214&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "payAmount": 2.08,
            "payCount": 889,
            "payType": "现金",
            "payTypeCode": "0"
        },
        {
            "payAmount": 112.2,
            "payCount": 24198,
            "payType": "记账支付",
            "payTypeCode": "1"
        },
        {
            "payAmount": 3.52,
            "payCount": 184,
            "payType": "钱包支付",
            "payTypeCode": "2"
        },
        {
            "payAmount": 42.54,
            "payCount": 13210,
            "payType": "移动支付",
            "payTypeCode": "3"
        }
    ]
});

Mock.mock(`${api}/cashorNotFlow?timemode=year&timeflag=2025&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "cashFlowCount": 905902,
            "notcashFlowCount": 4555690
        }
    ]
});

Mock.mock(`${api}/gateQingFenFeeFlow?timemode=year&timeflag=2025&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "enddate": "2025-02-13",
            "feesum": 40310.51,
            "flowcount": 14623729,
            "startdate": "2025-01-01"
        }
    ]
});

Mock.mock(`${Newapi}/enExFlowRealTime?timemode=day&timeflag=20250214&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "enFlowCount": "61182",
            "exFlowCount": "66382",
            "flowCount": "127564"
        }
    ]
});

Mock.mock(`${api}/qingfenAmountNew?startdate=20250130&enddate=20250213&level=0`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "feesum": 10352.31
        }
    ]
});

Mock.mock(`/bizapi1/http-server-base/publish/base-v1/systemUrl`, "get", {
    "msgState": "SUCCESS",
    "msgType": "ARR",
    "msgDes": "QUERY",
    "msgContent": [
        {
            "sysCode": "HY",
            "sysName": "养护系统",
            "url": "http://183.64.175.153:20003?code=curingManageyh"
        },
        {
            "sysCode": "JD",
            "sysName": "机电系统",
            "url": "http://183.64.175.153:20003?code=electromechanicalMange"
        },
        {
            "sysCode": "SF",
            "sysName": "收费系统",
            "url": "http://183.64.175.153:20003/?code=charge"
        },
        {
            "sysCode": "GS",
            "sysName": "服务区",
            "url": "http://183.64.175.153:21080/servicearea/index.html#/cqHome"
        }
    ]
});


export default Mock;
