//  token 未设置
// import axios from '@/utils/axios';

import axios from "@/utils/axiosCrossDomain";

// 需要暂时屏蔽掉未开通的省份
// 安徽、湖南、新疆、河北、江西
const ignoreOrgCodes = ["AH", "HN", "XJ", "HB", "JX"];

const baseUrl = "/http-server-base/publish/quota-v1";
const api = `/bizapi1${baseUrl}`;

/**
 * 服务区数量
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */

export function getServiceAreaCount(level, type, dimension) {
    return axios.get(`${api}/serviceAreaCount`, {
        params: { level, type, dimension },
    });
}

/**
 * 服务区数量-子列表
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function serviceAreaCountQueryChild(level, type, dimension) {
    return axios
        .get(`${api}/serviceAreaCountQueryChild`, {
            params: { level, type, dimension },
        })
        .then((res) => {
            res.msgContent = res.msgContent.filter(
                (item) => !ignoreOrgCodes.includes(item.orgCode)
            );
            return res;
        });
}
/**
 * 服务区数量-子列表详情(具体某条路的详情)
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function serviceAreaInfo(level, dimension) {
    return axios.get(`${api}/serviceareaInfo`, {
        params: { level, dimension },
    });
}

/**
 * 收费站数量
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function getStationCount(level, dimension) {
    return axios.get(`${api}/stationCount`, {
        params: { level, dimension },
    });
}

/**
 * 收费站数量-子列表
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function stationCountQueryChild(level, dimension) {
    return axios
        .get(`${api}/stationCountQueryChild`, {
            params: { level, dimension },
        })
        .then((res) => {
            res.msgContent = res.msgContent.filter(
                (item) => !ignoreOrgCodes.includes(item.orgCode)
            );
            return res;
        });
}
/**
 * 收费站数量-子列表详情(具体某条路的详情)
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function stationLaneInfo(level, dimension) {
    return axios.get(`${api}/StationLaneInfo`, {
        params: { level, dimension },
    });
}
/**
 * 路段数量
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function getSectionCount(level, dimension) {
    return axios.get(`${api}/sectionCount`, {
        params: { level, dimension },
    });
}
/**
 * 路段数量-子列表
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function sectionCountlevelChild(level, dimension) {
    return axios.get(`${api}/sectionCountlevelChild`, {
        params: { level, dimension },
    });
}

/**
 * 隧道数量
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} type 是否加类别统计 0-否,1-是
 * @param {string|Number} dimension 维度id
 */
export function getTunnelCount(level, type, dimension) {
    return axios.get(`${api}/tunnelCount`, {
        params: { level, type, dimension },
    });
}

/**
 * 隧道数量-子列表
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} type 是否加类别统计 0-否,1-是
 * @param {string|Number} dimension 维度id
 */
export function tunnelCountQueryChild(level, dimension) {
    return axios.get(`${api}/tunnelCountQueryChild`, {
        params: { level, dimension },
    })
        .then((res) => {
            res.msgContent = res.msgContent.filter(
                (item) => !ignoreOrgCodes.includes(item.orgCode)
            );
            return res;
        });
}
/**
 * 隧道数量-子列表详情(具体某条路的详情)
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function tunnelInfo(level, dimension) {
    return axios.get(`${api}/tunnelInfo`, {
        params: { level, dimension },
    });
}
/**
 * 桥梁数量
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} type 是否加类别统计 0-否,1-是
 * @param {string|Number} dimension 维度id
 */
export function getBridgeCount(level, type, dimension) {
    return axios.get(`${api}/bridgeCount`, {
        params: { level, type, dimension },
    });
}
/**
 * 桥梁数量-子列表
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} type 是否加类别统计 0-否,1-是
 * @param {string|Number} dimension 维度id
 */
export function bridgeCountQueryChild(level, dimension) {
    return axios.get(`${api}/bridgeCountQueryChild`, {
        params: { level, dimension },
    })
        .then((res) => {
            res.msgContent = res.msgContent.filter(
                (item) => !ignoreOrgCodes.includes(item.orgCode)
            );
            return res;
        });
}

/**
 * 互通数量
 * @param {string|number} level  组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 * @param {string|Number} type
 */
export function getHuTongCount(level, dimension, type) {
    return axios.get(`${api}/hutongCount`, {
        params: { level, dimension, type },
    });
}

//收费站车道类型数量
export function getStationLaneTypeCount(level, dimension) {
    return axios.get(`${api}/StationLaneTypeCount`, {
        params: { level, dimension },
    });
}

/**
 * 互通数量子查询
 * @param {string|number} level  组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function hutongCountChild(level, dimension) {
    return axios.get(`${api}/hutongCountChild`, {
        params: { level, dimension },
    })
        .then((res) => {
            res.msgContent = res.msgContent.filter(
                (item) => !ignoreOrgCodes.includes(item.orgCode)
            );
            return res;
        });
}

/**
 * 门架&车道数量
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function getSummarygateorlane(level, dimension) {
    return axios.get(`${api}/summarygateorlane`, {
        params: { level, dimension },
    });
}
/**
 * 门架&车道数量=子列表
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function summarygateorlaneQueryChild(level, dimension) {
    return axios.get(`${api}/summarygateorlaneQueryChild`, {
        params: { level, dimension },
    });
}

/**
 * 机电设备数量
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function getDeviceCount(level, dimension) {
    return axios.get(`${api}/deviceCount`, {
        params: { level, dimension },
    });
}
/**
 * 管控项目&路段数
 */
export function getControlProSecCount() {
    return axios.get(`${api}/controlProSecCount`);
}
/**
 * 投资/管理省市个数
 * @param {string|Number} countType  0-投资,1-管理
 */
export function getMngPrivinceCount(countType) {
    return axios.get(`${api}/mngPrivinceCount?countType=${countType}`);
}
/**
 * 投资经营里程
 */
export function getInvestMileage() {
    return axios.get(`${api}/investMileage`);
}
/**
 * 管理里程
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function getMngSectionLen(level, dimension) {
    return axios.get(`${api}/mngSectionLen`, {
        params: { level, dimension },
    });
}

/**
 * 管理里程=子列表
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function mngSectionLenChild(level, dimension) {
    return axios
        .get(`${api}/mngSectionLenChild`, {
            params: { level, dimension },
        })
        .then((res) => {
            res.msgContent = res.msgContent
                .map((item) => {
                    item.mngSectionLen = item.mngSectionLen - (item.canguLen || 0);
                    return item;
                })
                .filter(
                    (item) => item.orgCode && !ignoreOrgCodes.includes(item.orgCode)
                );
            return res;
        });
}
/**
 * 里程增长
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function mileageIncrease({ level, dimension }) {
    return axios.get(`${api}/mileageIncrease`, {
        params: { level, dimension },
    });
}
/**
 * 里程增长子查询
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 * @param {string|Number} cangu 是否参股
 * @param {string|Number} timeVal 时间值
 */
export function mileageIncreaseChild({ level, dimension, cangu, timeVal }) {
    return axios.get(`${api}/mileageIncreaseChild`, {
        params: { level, dimension, cangu, timeVal },
    });
}

/**
 * 项目公司人员统计
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function staffCount(params) {
    return axios.get(`${api}/staffStatistics`, {
        params,
    });
}
export function staffCountNew(params) {
    return axios.get(`${api}/staffCountNew`, {
        params,
    });
}
/**
 * 项目公司人员统计子查询
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function staffCountChildNew(params) {
    return axios.get(`${api}/staffCountChildNew`, {
        params,
    });
}
/* 
人员聘用方式子查询
*/
export function staffEmployModeCountChild(params) {
    return axios
        .get(`${api}/staffEmployModeCountChild`, {
            params,
        })
    // 取消屏蔽数据
    // .then((res) => {
    //   res.msgContent = res.msgContent.filter(
    //     (item) => !ignoreOrgCodes.includes(item.orgCode)
    //   );
    //   return res;
    // });
}
// staffEmployModeCountChild
/**
 * 项目公司人员统计子查询---新接口
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function staffEmplyModeCount(params) {
    return axios.get(`${api}/staffEmplyModeCount`, {
        params,
    });
}
/**
 * 公司人员占比
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function orgStaffRate(level, dimension) {
    return axios.get(`${api}/orgStaffRate`, {
        params: { level, dimension },
    });
}

/**
 * 公司人员占比-子列表
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function orgStaffRateQueryChild(level, dimension) {
    return axios.get(`${api}/orgStaffRateQueryChild`, {
        params: { level, dimension },
    });
}

/**
 * 每收费车道人员配置
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function coastLaneStaffConfig(params) {
    return axios.get(`${api}/coastLaneStaffConfig`, {
        params,
    });
}

/**
 * 每收费车道人员配置-子列表
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function coastLaneStaffConfigQueryChild(params) {
    return axios.get(`${api}/coastLaneStaffConfigQueryChild`, {
        params,
    });
}
