/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager;

import com.artfess.base.util.AppUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.api.model.IPermission;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service(value="bpmCurrentUserService")
public class CurrentUserService {
    public static String DEFAULT_OBJECT_RIGHTTYPE_BEAN = "defaultObjectRightType";

    public Map<String, String> getUserRightMapString() {
        Map<String, Set<String>> listMap = this.getUserRightMap(DEFAULT_OBJECT_RIGHTTYPE_BEAN);
        return this.getMapStringByMayList(listMap);
    }

    public Map<String, String> getMapStringByMayList(Map<String, Set<String>> listMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : listMap.keySet()) {
            String valueString;
            Set<String> list = listMap.get(key);
            if (list == null || !StringUtil.isNotEmpty((String)(valueString = this.convertListToSingleQuotesString(list)))) continue;
            map.put(key, valueString);
        }
        return map;
    }

    public Map<String, Set<String>> getUserRightMap() {
        return this.getUserRightMap(DEFAULT_OBJECT_RIGHTTYPE_BEAN);
    }

    public Map<String, Set<String>> getUserRightMap(String beanId) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        List<IPermission> objectList = this.getCurUserServiceList(beanId);
        for (IPermission curObj : objectList) {
            try {
                Set list = curObj.getCurrentProfile();
                map.put(curObj.getType(), list);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public Map<String, String> getUserTypeMap(String beanId) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<IPermission> objectList = this.getCurUserServiceList(beanId);
        for (IPermission curObj : objectList) {
            map.put(curObj.getType(), curObj.getTitle());
        }
        return map;
    }

    public List<IPermission> getCurUserServiceList(String beanId) {
        if (StringUtil.isEmpty((String)beanId)) {
            beanId = DEFAULT_OBJECT_RIGHTTYPE_BEAN;
        }
        return (List)AppUtil.getBean((String)beanId);
    }

    private String convertListToSingleQuotesString(Set<String> set) {
        if (set == null) {
            return "";
        }
        String ids = "";
        for (String value : set) {
            ids = ids + "'" + value + "',";
        }
        ids = ids.equals("") ? "" : ids.substring(0, ids.length() - 1);
        return ids;
    }
}

