package com.artfess.uc.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Author: wsf
 * @Description: 招商组织全量同步
 * @DateTime: 2025/6/16 16:38
 **/
@Data
public class SyncOrgTreeVO {

    @ApiModelProperty(value = "主键ID")
    private String id;

    @ApiModelProperty(value = "组织编码")
    private String code;

    @ApiModelProperty(value = "上级组织编码")
    private String parentCode;

    @ApiModelProperty(value = "组织名称")
    private String name;

    @ApiModelProperty(value = "组织类型 1:机构，2:部门")
    private Integer type;

    @ApiModelProperty(value = "上级组织ID")
    private String parentId;

    @ApiModelProperty(value = "组织描述")
    private String orgDesc;

    @ApiModelProperty(value = "机构分组：交警、路政、路方、应急局、清障")
    private String orgTag;

    @ApiModelProperty(value = "数据来源1.本地2.用友")
    private Integer orgLevel;

    @ApiModelProperty(value = "数据来源（如：1=系统录入）")
    private Integer source;

    @ApiModelProperty(value = "组织全名（含层级路径）")
    private String fullName;

    @ApiModelProperty(value = "组织完整编码（含层级路径）")
    private String fullCode;

    @ApiModelProperty(value = "组织机构列席 0:无含义 1:基础组织 2:虚拟组织")
    private Integer orgType;

    @ApiModelProperty(value = "组织类型名称")
    private String orgTypeName;

    @ApiModelProperty(value = "模块编码")
    private String moduleCode;

    @ApiModelProperty(value = "模块名称")
    private String moduleName;

    @ApiModelProperty(value = "组织代码（第三方对接字段）")
    private String orgCode;

    @ApiModelProperty(value = "子组织列表")
    private List<SyncOrgTreeVO> children;
}
