package com.artfess.uc.manager.impl;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.uc.exception.BaseException;
import com.artfess.uc.exception.RequiredException;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.User;
import com.artfess.uc.params.user.UserUnderVo;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.uc.dao.UserUnderDao;
import com.artfess.uc.manager.UserUnderManager;
import com.artfess.uc.model.UserUnder;
import org.springframework.transaction.annotation.Transactional;

/**
 * 
 * <pre> 
 * 描述：下属管理 处理实现类
 * 构建组：x5-bpmx-platform
 * 作者:liyg
 * 邮箱:liyg@jee-soft.cn
 * 日期:2017-07-25 09:24:29
 * 版权：广州宏天软件有限公司
 * </pre>
 */
@Service
public class UserUnderManagerImpl extends BaseManagerImpl <UserUnderDao, UserUnder> implements UserUnderManager{

	@Resource
	UserManager userManager;
	
	@Override
	public IPage<UserUnder> getUserUnder(QueryFilter queryFilter) {
		PageBean pageBean = queryFilter.getPageBean();
		// 设置分页
		//PageHelper.startPage(pageBean.getPage(), pageBean.getPageSize(), pageBean.showTotal());
		queryFilter.addFilter("IS_DELE_", "1", QueryOP.NOT_EQUAL);
		return baseMapper.getUserUnder(convert2IPage(pageBean),convert2Wrapper(queryFilter, currentModelClass()));
	}
	@Override
    @Transactional
	public void delByUpIdAndUderId(String orgId,String underUserId) {
		baseMapper.delByUpIdAndUderId(orgId,underUserId,LocalDateTime.now());
	}
	
	@Override
    @Transactional
	public void delByUserIdAndOrgId(String userId, String orgId) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("orgId", orgId);
		map.put("userId", userId);
		map.put("updateTime", LocalDateTime.now());
		baseMapper.delByUserIdAndOrgId(map);
	}
	@Override
    @Transactional
	public void delByOrgId(String orgId) {
		baseMapper.delByOrgId(orgId,LocalDateTime.now());
	}
	@Override
	public List<UserUnder> getUserUnder(Map<String, Object> params) {
		return baseMapper.getUserUnderNOPage(params);
	}

	@Override
	@Transactional
	public void setUnderUser(UserUnderVo userUnderVo) throws Exception{
		User u = userManager.getByAccount(userUnderVo.getAccount());
		String[] accounts = userUnderVo.getUnderAccounts().split(",");
		for (String account:accounts){
			User user = userManager.getByAccount(account);
			if (BeanUtils.isEmpty(user)){
				throw new RequiredException("用户不存在");
			}
			if (user.getId().equals(u.getId())){
				throw new BaseException("不能设置自己为下属");
			}
			User superior = getSuperior(u.getId(),userUnderVo.getDimenId());
			if (StringUtil.isNotEmpty(superior.getId()) && superior.getId().equals(user.getId())){
				throw new BaseException("不可设置上级为下属");
			}
			UserUnder under = getUnderByUnderIdAndDemId(user.getId(),userUnderVo.getDimenId());
			if (BeanUtils.isEmpty(under)){
				UserUnder userUnder = new UserUnder();
				userUnder.setId(UniqueIdUtil.getSuid());
				userUnder.setUserId(u.getId());
				userUnder.setUnderUserId(user.getId());
				userUnder.setUnderUserName(user.getFullname());
				userUnder.setDimenId(userUnderVo.getDimenId());
				create(userUnder);
			}else{
				under.setDimenId(userUnderVo.getDimenId());
				under.setUserId(u.getId());
				update(under);
			}
		}
	}

	@Override
	public User getSuperior(String underId, String demId) throws Exception {
		UserUnder userUnder = getUnderByUnderIdAndDemId(underId, demId);
		if (BeanUtils.isEmpty(userUnder))
			return new User();
		return userManager.get(userUnder.getUserId());
	}

	private UserUnder getUnderByUnderIdAndDemId(String underUserId,String demId){
		QueryWrapper queryWrapper = new QueryWrapper();
		queryWrapper.eq("under_user_id_",underUserId);
		queryWrapper.eq("dimen_id_",demId);
		return baseMapper.selectOne(queryWrapper);
	}

	@Override
    @Transactional
	public Integer removePhysical() {
		return baseMapper.removePhysical();
	}
}
