package com.artfess.uc.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Author: wsf
 * @Description: 招商-组织增量同步kafka报文内容DTO
 * @DateTime: 2025/6/17 14:33
 **/
@Data
public class OrgKafkaDTO {

    @ApiModelProperty("组织ID")
    private String id;

    @ApiModelProperty("组织名称")
    private String name;

    @ApiModelProperty("组织编码")
    private String code;

    @ApiModelProperty("父级组织编码")
    private String parentCode;

    @ApiModelProperty("组织类型")
    private Integer type;

    @ApiModelProperty("父级组织ID")
    private String parentId;

    @ApiModelProperty("组织描述")
    private String orgDesc;

    @ApiModelProperty("组织类别")
    private Integer orgType;

    @ApiModelProperty("组织标签")
    private String orgTag;

    @ApiModelProperty("组织级别")
    private Integer orgLevel;

    @ApiModelProperty("来源标识")
    private Integer source;

    @ApiModelProperty("组织状态")
    private Integer status;

    @ApiModelProperty("创建时间,时间戳")
    private Long createTime;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("修改时间,时间戳")
    private Long updateTime;

    @ApiModelProperty("修改人")
    private String updateBy;

    @ApiModelProperty("组织全称")
    private String fullName;

    @ApiModelProperty("排序号")
    private Integer sort;

    @ApiModelProperty("是否叶子节点（1=是，0=否）")
    private Integer leafNode;

}
