package com.artfess.uc.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.manager.ShiftRuleManager;
import com.artfess.uc.manager.ShiftUserManager;
import com.artfess.uc.model.ShiftRule;
import com.artfess.uc.model.ShiftUser;
import com.artfess.uc.params.user.DurationParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jdk.nashorn.internal.ir.ObjectNode;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 
 * <pre> 
 * 描述：轮班规则 控制器类
 * 构建组：x7
 * 作者:qiuxd
 * 邮箱:qiuxd@jee-soft.cn
 * 日期:2020-08-04 16:07:34
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@RestController
@RequestMapping(value="/uc/shiftRule/v1")
@Api(tags="shiftRuleController")
public class ShiftRuleController extends BaseController<ShiftRuleManager,ShiftRule>{
	@Resource
	ShiftRuleManager shiftRuleManager;
	@Resource
	ShiftUserManager shiftUserManager;
	
    /**
	 * 新增轮班规则
	 * @param shiftRule
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@PostMapping(value="save")
	@ApiOperation(value = "新增,更新轮班规则数据", httpMethod = "POST", notes = "新增,更新轮班规则数据")
	public CommonResult<String> save(@ApiParam(name="shiftRule",value="uc_shift_rule业务对象", required = true)@RequestBody ShiftRule shiftRule) throws Exception{
		String msg = "添加轮班规则成功";
		if(StringUtil.isEmpty(shiftRule.getId())){
			shiftRuleManager.create(shiftRule);
		}else{
			shiftRuleManager.update(shiftRule);
			 msg = "更新轮班规则成功";
		}
		return new CommonResult<String>(msg);
	}
	
	/**
	 * 批量删除轮班规则记录
	 * @param ids
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@DeleteMapping(value="/remove")
	@ApiOperation(value = "批量删除轮班规则记录", httpMethod = "DELETE", notes = "批量删除轮班规则记录")
	public CommonResult<String> removes(@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true)@RequestParam String...ids) throws Exception{
		shiftRuleManager.removeByIds(ids);
		return new CommonResult<String>(true, "删除成功");
	}

	@PostMapping(value="/saveShiftUser")
	@ApiOperation(value = "保存排班人员", httpMethod = "POST", notes = "保存排班人员")
	public CommonResult<String> saveShiftUser(@RequestBody List<ShiftUser> shiftUsers){
		shiftUserManager.saveShiftUser(shiftUsers);
		return new CommonResult<>(true, "保存成功");
	}

	@DeleteMapping(value="/removeShiftUser")
	@ApiOperation(value = "批量删除轮班规则记录", httpMethod = "DELETE", notes = "批量删除轮班规则记录")
	public CommonResult<String> removeShiftUser(@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true)@RequestParam String...ids) throws Exception{
		shiftUserManager.removeByUserIds(ids);
		return new CommonResult<String>(true, "删除成功");
	}

	@GetMapping(value="/computeSendDate", produces = {"application/json; charset=utf-8" })
	@ApiOperation(value = "计算发送时间", httpMethod = "GET", notes = "计算发送时间")
	public Long computeSendDate(@RequestParam(value="userId") String userId,@RequestParam(value="minute") long minute) throws Exception{
		return shiftRuleManager.computeSendDate(userId,minute);
	}

	@PostMapping(value="/computeDuration", produces = {"application/json; charset=utf-8" })
	@ApiOperation(value = "计算发送时间", httpMethod = "GET", notes = "计算发送时间")
	public Long computeDuration(@RequestParam(value="userId") String userId, @RequestBody DurationParam param) throws Exception{
		return shiftRuleManager.computeDuration(userId, param.getStartDate(), param.getEndDate());
	}
}
