package com.artfess.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.PinyinUtil;
import com.artfess.base.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 角色组织模块接口
 * @author zhangxw
 *
 */
@RestController
@RequestMapping("/api/common/v1/")
@Api(tags="通用")
@ApiGroup(group= {ApiGroupConsts.GROUP_UC})
public class CommonController{
	/**
	 * 汉字转拼音
	 * @param chinese
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="getPinyin",method=RequestMethod.GET, produces = {
	"application/json; charset=utf-8" })
	@ApiOperation(value = "汉字转拼音", httpMethod = "GET", notes = "汉字转拼音")
	public CommonResult<String> getPinyin(@ApiParam(name="chinese",value="需要获取拼音字母的中文", required = true) @RequestParam String chinese,@ApiParam(name="type",value="类型:1 为全拼，否则为首字母", required = true) @RequestParam Integer type) throws Exception{
		String pinyin = "";
		if(StringUtil.isNotEmpty(chinese)){
			if(type == 1){
				pinyin = PinyinUtil.getPinyin(chinese);
			}else{
				pinyin = PinyinUtil.getPinYinHeadChar(chinese);
			}
		}
		return new CommonResult<String>(true,"获取拼音成功！",pinyin);
	}
}
