package com.artfess.security.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 人员+设备登录限制
 * @company 阿特菲斯
 * @author chenshi
 * @email chenshi@artfess.com
 * @since 2021-03-08
 */
@TableName("uc_security_personloginlimit")
@ApiModel(value="SecurityPersonloginlimit对象", description="人员+设备登录限制")
public class SecurityPersonloginlimit extends BaseModel<SecurityPersonloginlimit> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_")
    @ApiModelProperty(value = "ID")
    private String id;

    @ApiModelProperty(value = "设备_ID（外键参考设备表）")
    @TableField("MACHINE_ID_")
    private String machineId;

    @ApiModelProperty(value = "人员_ID")
    @TableField("USER_ID_")
    private String userId;

    @ApiModelProperty(value = "人员_账号")
    @TableField("ACCOUNT_")
    private String account;


    public String getId() {
        return id;
    }
    public void setId(String id) {
        this.id = id;
    }

    public String getMachineId() {
        return machineId;
    }
    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public String getUserId() {
        return userId;
    }
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "UcSecurityPersonloginlimit{" +
            "id=" + id +
            ", machineId=" + machineId +
            ", userId=" + userId +
            ", account=" + account +
        "}";
    }
}
