package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 删除枚举
 */
@Getter
public enum DelStatusEnum {
    /**
     * 删除
     */
    Y("1", "已删除"),

    N("0", "未删除"),
    ;

    DelStatusEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        DelStatusEnum[] values = values();
        for (DelStatusEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
