/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.service.util;

import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ContextThread;
import com.artfess.base.util.JsonUtil;
import com.artfess.service.exception.InvokeException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.Map;
import javax.xml.ws.WebServiceException;
import org.springframework.stereotype.Service;

@Service
public class ParamHandlerUtil
implements ContextThread {
    public static final String INPUT = "input";
    public static final String FLOW_OUTPUT = "flowOutput";
    private static ThreadLocal<String> jsonType = new ThreadLocal();
    private static ThreadLocal<Map<String, Object>> params = new ThreadLocal();
    private static ThreadLocal<String> flowOutPutKey = new ThreadLocal();

    public static Object buildJsonParam(ArrayNode jarray, JsonNode jsonParamObj, Map paramMap, String type) {
        jsonType.set(type);
        params.set(paramMap);
        flowOutPutKey.set("");
        try {
            ParamHandlerUtil.buildJsonParams(jarray, jsonParamObj);
            if (FLOW_OUTPUT.equals(type)) {
                String string = flowOutPutKey.get();
                return string;
            }
            Object var4_5 = null;
            return var4_5;
        }
        catch (Exception e) {
            throw new WebServiceException("webService " + type + "Json \u89e3\u6790\u51fa\u9519\uff01");
        }
        finally {
            jsonType.remove();
            params.remove();
            flowOutPutKey.remove();
        }
    }

    private static void buildJsonParams(ArrayNode jarray, JsonNode jsonParamObj) throws IOException {
        for (JsonNode jelement : jarray) {
            ArrayNode children;
            if (!jelement.isObject()) continue;
            ObjectNode jobject = (ObjectNode)jelement;
            String key = jobject.get("key").asText();
            String type = jobject.get("type").asText();
            JsonNode bind = jobject.get("bind");
            JsonNode genericsValue = jobject.get("generics");
            Boolean generics = false;
            if (BeanUtils.isNotEmpty((Object)genericsValue)) {
                generics = genericsValue.asBoolean();
            }
            TextNode paramJson = null;
            if (!"Bean".equals(type) && !generics.booleanValue() || jsonType.get().equals(FLOW_OUTPUT)) {
                paramJson = new TextNode("");
                paramJson = ParamHandlerUtil.handlerBind(bind, (JsonNode)paramJson);
            } else if ("Bean".equals(type)) {
                children = (ArrayNode)jobject.get("children");
                paramJson = JsonUtil.getMapper().createObjectNode();
                paramJson = ParamHandlerUtil.handlerBind(bind, (JsonNode)paramJson);
                ParamHandlerUtil.buildJsonParams(children, (JsonNode)paramJson);
            } else if (generics.booleanValue()) {
                children = (ArrayNode)jobject.get("children");
                int count = children.size();
                paramJson = count == 1 ? JsonUtil.getMapper().createArrayNode() : JsonUtil.getMapper().createObjectNode();
                paramJson = ParamHandlerUtil.handlerBind(bind, (JsonNode)paramJson);
                ParamHandlerUtil.handlerGenerics(children, (JsonNode)paramJson);
            }
            if (!jsonParamObj.isObject()) continue;
            ((ObjectNode)jsonParamObj).set(key, (JsonNode)paramJson);
        }
    }

    private static JsonNode handlerBind(JsonNode bindElement, JsonNode jsonElement) throws IOException {
        Map<String, Object> param = params.get();
        if (BeanUtils.isEmpty((Object)bindElement)) {
            return jsonElement;
        }
        ObjectNode bind = (ObjectNode)bindElement;
        int type = bind.get("type").asInt();
        String value = bind.get("value").asText();
        TextNode jsonVal = null;
        switch (type) {
            case 1: {
                jsonVal = new TextNode(value);
                break;
            }
            case 2: {
                if (jsonType.get().equals(FLOW_OUTPUT)) {
                    flowOutPutKey.set(value);
                    break;
                }
                jsonVal = new TextNode(param.get(value).toString());
                break;
            }
            case 3: {
                Map<String, Object> map = params.get();
                Object obj = ((GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class)).executeObject(value, map);
                jsonVal = JsonUtil.toJsonNode((Object)obj);
                break;
            }
            case 4: {
                throw new InvokeException("\u65e0\u6cd5\u83b7\u53d6BoData\u683c\u5f0f\u7684\u6570\u636e");
            }
        }
        if (BeanUtils.isEmpty(jsonVal)) {
            return jsonElement;
        }
        if (jsonElement.isArray() && !jsonVal.isArray()) {
            ArrayNode jarray = JsonUtil.getMapper().createArrayNode();
            jarray.add((JsonNode)jsonVal);
            jsonVal = jarray;
        }
        return jsonVal;
    }

    private static void handlerGenerics(ArrayNode childrenAry, JsonNode jsonElement) throws IOException {
        ArrayNode children;
        ObjectNode generics;
        JsonNode jelement = jsonElement.isArray() ? childrenAry.get(0) : childrenAry.get(1);
        if (!jelement.isObject()) {
            return;
        }
        ObjectNode jobject = (ObjectNode)jelement;
        String type = jobject.get("type").asText();
        Boolean isGenerics = false;
        JsonNode genericsValue = jobject.get("generics");
        if (BeanUtils.isNotEmpty((Object)genericsValue)) {
            isGenerics = genericsValue.asBoolean();
        }
        if ("Bean".equals(type)) {
            generics = JsonUtil.getMapper().createObjectNode();
            children = (ArrayNode)jobject.get("children");
            ParamHandlerUtil.buildJsonParams(children, (JsonNode)generics);
        } else if (isGenerics.booleanValue()) {
            generics = JsonUtil.getMapper().createObjectNode();
            children = (ArrayNode)jobject.get("children");
            ParamHandlerUtil.handlerGenerics(children, (JsonNode)generics);
        } else {
            generics = new TextNode("");
        }
        if (jsonElement.isArray()) {
            ArrayNode ja = (ArrayNode)jsonElement;
            if (ja.size() == 0) {
                ja.add((JsonNode)generics);
            }
        } else {
            String key = "";
            JsonNode jsonKey = childrenAry.get(0);
            if (jsonKey.isArray() || jsonKey.isObject()) {
                key = jsonKey.toString();
            } else if (jsonKey.isTextual()) {
                key = jsonKey.asText();
            }
            ((ObjectNode)jsonElement).set(key, (JsonNode)generics);
        }
    }

    public void cleanAll() {
        jsonType.remove();
        params.remove();
        flowOutPutKey.remove();
    }
}

