/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.easyExcel.util.excel;

import com.artfess.easyExcel.annotaion.ExcelSelected;
import com.artfess.easyExcel.service.ExcelDynamicSelect;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelSelectedResolve {
    private static final Logger log = LoggerFactory.getLogger(ExcelSelectedResolve.class);
    private String[] source;
    private int firstRow;
    private int lastRow;

    public String[] resolveSelectedSource(ExcelSelected excelSelected) {
        if (excelSelected == null) {
            return null;
        }
        String[] source = excelSelected.source();
        if (source.length > 0) {
            return source;
        }
        String dictKey = excelSelected.dictKey();
        Class<? extends ExcelDynamicSelect>[] classes = excelSelected.sourceClass();
        if (classes.length > 0) {
            try {
                ExcelDynamicSelect excelDynamicSelect = classes[0].newInstance();
                String[] dynamicSelectSource = excelDynamicSelect.getSource(dictKey);
                if (dynamicSelectSource != null && dynamicSelectSource.length > 0) {
                    return dynamicSelectSource;
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.error("\u89e3\u6790\u52a8\u6001\u4e0b\u62c9\u6846\u6570\u636e\u5f02\u5e38", (Throwable)e);
            }
        }
        return null;
    }

    public String[] getSource() {
        return this.source;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public void setSource(String[] source) {
        this.source = source;
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    public void setLastRow(int lastRow) {
        this.lastRow = lastRow;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelSelectedResolve)) {
            return false;
        }
        ExcelSelectedResolve other = (ExcelSelectedResolve)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSource(), other.getSource())) {
            return false;
        }
        if (this.getFirstRow() != other.getFirstRow()) {
            return false;
        }
        return this.getLastRow() == other.getLastRow();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelSelectedResolve;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getSource());
        result = result * 59 + this.getFirstRow();
        result = result * 59 + this.getLastRow();
        return result;
    }

    public String toString() {
        return "ExcelSelectedResolve(source=" + Arrays.deepToString(this.getSource()) + ", firstRow=" + this.getFirstRow() + ", lastRow=" + this.getLastRow() + ")";
    }
}

