/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.FormFeignService;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.groovy.IUserScript;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.BaseActionCmd;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.uc.api.impl.service.UserServiceImpl;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.workflow.runtime.manager.BpmSelectorDefManager;
import com.artfess.workflow.runtime.manager.ConditionScriptManager;
import com.artfess.workflow.runtime.model.BpmSelectorDef;
import com.artfess.workflow.runtime.model.ConditionScript;
import com.artfess.workflow.runtime.model.IConditionScript;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/runtime/conditionScript/v1/"})
@Api(tags={"\u6761\u4ef6\u811a\u672c\u7ba1\u7406"})
@ApiGroup(group={"group_bpm"})
public class ConditionScriptController
extends BaseController<ConditionScriptManager, ConditionScript> {
    @Resource
    private FormFeignService formFeignService;
    @Resource
    private ConditionScriptManager conditionScriptManager;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6761\u4ef6\u811a\u672c\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)", httpMethod="POST", notes="\u6761\u4ef6\u811a\u672c\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)")
    public PageList<ConditionScript> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, @ApiParam(name="type", value="\u811a\u672c\u7c7b\u578b") @RequestParam Optional<Integer> type) throws Exception {
        Integer itype = type.orElse(null);
        if (BeanUtils.isNotEmpty((Object)itype)) {
            queryFilter.addFilter("type", (Object)itype, QueryOP.EQUAL, FieldRelation.AND, "2");
        }
        PageList fileList = this.conditionScriptManager.query(queryFilter);
        return fileList;
    }

    @RequestMapping(value={"edit"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u811a\u672c\u8bbe\u7f6e\u660e\u7ec6", httpMethod="GET", notes="\u83b7\u53d6\u811a\u672c\u8bbe\u7f6e\u660e\u7ec6")
    public ObjectNode edit(@ApiParam(name="id", value="\u811a\u672cid") @RequestParam String id) throws Exception {
        ParaCtOtion option;
        ObjectNode optgroup;
        ConditionScript conditionScript = null;
        if (StringUtil.isNotEmpty((String)id)) {
            conditionScript = (ConditionScript)this.conditionScriptManager.get((Serializable)((Object)id));
        } else {
            conditionScript = new ConditionScript();
            conditionScript.setType(1);
        }
        BpmSelectorDefManager bpmSelectorDefManager = (BpmSelectorDefManager)AppUtil.getBean(BpmSelectorDefManager.class);
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        PageList pageList = bpmSelectorDefManager.query(queryFilter);
        List bpmSelectorDefs = pageList.getRows();
        List customDialogs = this.formFeignService.getCustomDialogs();
        ArrayList<ParaCtOtion> controlBindList = new ArrayList<ParaCtOtion>();
        ArrayNode optionJson = JsonUtil.getMapper().createArrayNode();
        if (bpmSelectorDefs.size() > 0) {
            optgroup = JsonUtil.getMapper().createObjectNode();
            ArrayNode selectors = JsonUtil.getMapper().createArrayNode();
            for (BpmSelectorDef selector : bpmSelectorDefs) {
                ObjectNode select = JsonUtil.getMapper().createObjectNode();
                select.put("value", "selector:" + selector.getAlias());
                select.put("name", selector.getName());
                selectors.add((JsonNode)select);
                option = new ParaCtOtion();
                option.id = "selector:" + selector.getAlias();
                option.option = selector.getGroupField();
                controlBindList.add(option);
            }
            optgroup.put("lable", "\u9009\u62e9\u5668\u7ec4\u5408\u63a7\u4ef6");
            optgroup.set("option", (JsonNode)selectors);
            optionJson.add((JsonNode)optgroup);
        }
        if (customDialogs.size() > 0) {
            optgroup = JsonUtil.getMapper().createObjectNode();
            ArrayNode cusdgs = JsonUtil.getMapper().createArrayNode();
            for (Object obj : customDialogs) {
                ObjectNode cus = (ObjectNode)JsonUtil.toJsonNode(obj);
                cus.put("value", "cusdg:" + cus.get("alias").asText());
                cus.put("name", cus.get("name").asText());
                cusdgs.add((JsonNode)cus);
                option = new ParaCtOtion();
                option.id = "cusdg:" + cus.get("alias").asText();
                if (BeanUtils.isNotEmpty((Object)cus.get("resultfield")) && StringUtil.isNotEmpty((String)cus.get("resultfield").toString())) {
                    option.option = cus.get("resultfield").toString().replace("\"field\":", "\"name\":").replace("\"comment\":", "\"key\":");
                }
                controlBindList.add(option);
            }
            optgroup.put("lable", "\u9009\u62e9\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846");
            optgroup.set("option", (JsonNode)cusdgs);
            optionJson.add((JsonNode)optgroup);
        }
        ObjectNode result = JsonUtil.getMapper().createObjectNode();
        if (BeanUtils.isNotEmpty(controlBindList)) {
            ArrayNode controlBindSourceJson = (ArrayNode)JsonUtil.toJsonNode(controlBindList);
            String jsonStr = controlBindSourceJson.toString();
            result.put("controlBindSourceJson", jsonStr);
        }
        result.set("conditionScript", JsonUtil.toJsonNode((Object)conditionScript));
        result.set("optionJson", (JsonNode)optionJson);
        result.set("bpmSelectorDefs", JsonUtil.toJsonNode((Object)bpmSelectorDefs));
        return result;
    }

    @RequestMapping(value={"getImplClasses"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u7684\u63a5\u53e3\u6216\u57fa\u7c7b\u83b7\u53d6\u5b9e\u73b0\u7c7b\u5217\u8868", httpMethod="GET", notes="\u6839\u636e\u6307\u5b9a\u7684\u63a5\u53e3\u6216\u57fa\u7c7b\u83b7\u53d6\u5b9e\u73b0\u7c7b\u5217\u8868")
    public List<Class> getImplClasses(@ApiParam(name="type", value="\u811a\u672c\u7c7b\u578b\uff081\uff1a\u6761\u4ef6\u811a\u672c\uff0c2\uff1a\u4eba\u5458\u811a\u672c \uff09", required=true) @RequestParam Integer type) throws Exception {
        List implClasses = null;
        if (type == 1) {
            implClasses = AppUtil.getImplClass(IConditionScript.class);
        } else if (type == 2) {
            implClasses = AppUtil.getImplClass(IUserScript.class);
        }
        return implClasses;
    }

    @RequestMapping(value={"get"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u811a\u672c\u660e\u7ec6", httpMethod="GET", notes="\u83b7\u53d6\u811a\u672c\u660e\u7ec6")
    public ConditionScript get(@ApiParam(name="id", value="\u811a\u672cid", required=true) @RequestParam String id) throws Exception {
        ConditionScript conditionScript = null;
        if (StringUtil.isNotEmpty((String)id)) {
            conditionScript = (ConditionScript)this.conditionScriptManager.get((Serializable)((Object)id));
        }
        return conditionScript;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u811a\u672c\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u811a\u672c\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="conditionScript", value="\u811a\u672c\u8bbe\u7f6e", required=true) @RequestBody ConditionScript conditionScript) throws Exception {
        String resultMsg = null;
        String id = conditionScript.getId();
        try {
            if (StringUtil.isEmpty((String)id)) {
                conditionScript.setId(UniqueIdUtil.getSuid());
                this.conditionScriptManager.create((Model)conditionScript);
                resultMsg = "\u6dfb\u52a0\u811a\u672c\u6210\u529f";
            } else {
                this.conditionScriptManager.update((Model)conditionScript);
                resultMsg = "\u66f4\u65b0\u811a\u672c\u6210\u529f";
            }
            return new CommonResult(true, resultMsg);
        }
        catch (Exception e) {
            return new CommonResult(false, resultMsg + "," + e.getMessage());
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u811a\u672c\u8bbe\u7f6e", httpMethod="DELETE", notes="\u5220\u9664\u811a\u672c\u8bbe\u7f6e")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u6d41\u7a0b\u7684\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6eid\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = null;
            if (!StringUtil.isEmpty((String)ids)) {
                aryIds = ids.split(",");
            }
            this.conditionScriptManager.removeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25");
        }
    }

    @RequestMapping(value={"getMethodsByName"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u7c7b\u540d\u83b7\u53d6\u7c7b\u7684\u6240\u6709\u65b9\u6cd5", httpMethod="GET", notes="\u901a\u8fc7\u7c7b\u540d\u83b7\u53d6\u7c7b\u7684\u6240\u6709\u65b9\u6cd5")
    public CommonResult<String> getMethodsByName(@ApiParam(name="className", value="\u7c7b\u540d", required=true) @RequestParam String className, @ApiParam(name="id", value="id") @RequestParam String id, @ApiParam(name="type", value="\u811a\u672c\u7c7b\u578b") @RequestParam Integer type) throws Exception {
        try {
            ConditionScript conditionScript = null;
            if (StringUtil.isNotEmpty((String)id)) {
                conditionScript = (ConditionScript)this.conditionScriptManager.get((Serializable)((Object)id));
                type = conditionScript.getType();
            }
            ArrayNode jarray = this.conditionScriptManager.getMethodsByClassName(className, conditionScript, type);
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)jarray.toString());
        }
        catch (Exception ex) {
            return new CommonResult(false, ex.getMessage());
        }
    }

    @RequestMapping(value={"testScript"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d4b\u8bd5\u811a\u672c", httpMethod="POST", notes="\u6d4b\u8bd5\u811a\u672c")
    public CommonResult<Object> testScript(@ApiParam(name="param", value="\u53c2\u6570") @RequestBody ObjectNode param) throws Exception {
        try {
            GroovyScriptEngine groovyScriptEngine = (GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class);
            String script = "";
            if (param.hasNonNull("script")) {
                script = param.get("script").asText();
            }
            if (StringUtil.isEmpty((String)script)) {
                return new CommonResult(false, "\u811a\u672c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            HashMap<String, String> variables = new HashMap<String, String>();
            String startId = "";
            startId = param.hasNonNull("startId") && StringUtil.isNotEmpty((String)param.get("startId").asText()) ? param.get("startId").asText() : ContextUtil.getCurrentUserId();
            variables.put("startUser", startId);
            if (param.hasNonNull("userId") && StringUtil.isNotEmpty((String)param.get("userId").asText())) {
                String userId = param.get("userId").asText();
                UserServiceImpl userServiceImpl = (UserServiceImpl)AppUtil.getBean(UserServiceImpl.class);
                IUser userById = userServiceImpl.getUserById(userId);
                ContextUtil.switchCurrentUser((IUser)userById);
            }
            BaseActionCmd actionCmd = new BaseActionCmd();
            actionCmd.addTransitVars("startUser", (Object)startId);
            actionCmd.setVariables(variables);
            ContextThreadUtil.setActionCmd((ActionCmd)actionCmd);
            Set set = (Set)groovyScriptEngine.executeObject(script, variables);
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)set);
        }
        catch (Exception ex) {
            return new CommonResult(false, ex.getMessage());
        }
    }

    public class ParaCtOtion {
        protected String id;
        protected String option;

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setOption(String option) {
            this.option = option;
        }

        public String getOption() {
            return this.option;
        }
    }
}

