/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.security.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.security.dao.SecurityMachineDao;
import com.artfess.security.manager.SecurityMachineManager;
import com.artfess.security.model.SecurityMachine;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SecurityMachineManagerImpl
extends BaseManagerImpl<SecurityMachineDao, SecurityMachine>
implements SecurityMachineManager {
    @Override
    @Transactional
    public String saveMachine(SecurityMachine machine) {
        Assert.notNull((Object)((Object)machine), (String)"\u4fdd\u5b58\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        int num = this.checkSameCode(machine.getId(), machine.getCode());
        if (num > 0) {
            throw new RuntimeException("\u7f16\u7801\u3010" + machine.getCode() + "\u3011\u91cd\u590d\uff01");
        }
        int ipNum = this.checkSameIp(machine.getId(), machine.getIp());
        if (ipNum > 0) {
            throw new RuntimeException("\u5df2\u5b58\u5728IP\u4e3a\uff1a\u3010" + machine.getIp() + "\u3011\u7684\u673a\u5668\uff01");
        }
        if (StringUtils.isBlank((CharSequence)machine.getId())) {
            ((SecurityMachineDao)this.baseMapper).insert((Object)machine);
        } else {
            ((SecurityMachineDao)this.baseMapper).updateById((Object)machine);
        }
        return machine.getId();
    }

    public int checkSameCode(String id, String code) {
        Assert.hasText((String)code, (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code_", (Object)code);
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)id), (Object)"id_", (Object)id);
        int num = ((SecurityMachineDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return num;
    }

    public int checkSameIp(String id, String ip) {
        Assert.hasText((String)ip, (String)"ip\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ip_", (Object)ip);
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)id), (Object)"id_", (Object)id);
        int num = ((SecurityMachineDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return num;
    }
}

