/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.kh.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.portal.kh.dao.KhSchemePlanDao;
import com.artfess.portal.kh.manager.KhAssessSchemeManager;
import com.artfess.portal.kh.manager.KhPlanObjectManager;
import com.artfess.portal.kh.manager.KhSchemeManager;
import com.artfess.portal.kh.manager.KhSchemePlanManager;
import com.artfess.portal.kh.model.KhAssessScheme;
import com.artfess.portal.kh.model.KhPlanObject;
import com.artfess.portal.kh.model.KhScheme;
import com.artfess.portal.kh.model.KhSchemePlan;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class KhSchemePlanManagerImpl
extends BaseManagerImpl<KhSchemePlanDao, KhSchemePlan>
implements KhSchemePlanManager {
    @Autowired
    private KhPlanObjectManager planObjectManager;
    @Autowired
    private KhAssessSchemeManager assessSchemeManager;
    @Autowired
    private KhSchemeManager schemeManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createInfo(KhSchemePlan t) {
        t.setStatus("edit");
        boolean save = this.save((Object)t);
        if (save) {
            this.processDetail(t);
            return save;
        }
        return false;
    }

    private void processDetail(KhSchemePlan t) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(KhPlanObject::getPlanId, (Object)t.getId());
        this.planObjectManager.remove((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isEmpty(t.getPlanObjectList())) {
            return;
        }
        t.getPlanObjectList().forEach(detail -> detail.setPlanId(t.getId()));
        this.planObjectManager.saveBatch(t.getPlanObjectList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(KhSchemePlan t) {
        boolean save = this.updateById((Object)t);
        if (save) {
            this.processDetail(t);
            return save;
        }
        return false;
    }

    @Override
    public KhSchemePlan findById(String id) {
        KhScheme scheme;
        KhAssessScheme khAssessScheme;
        KhSchemePlan KhSchemePlan2 = (KhSchemePlan)this.get((Serializable)((Object)id));
        Assert.notNull((Object)((Object)KhSchemePlan2), (String)"\u8003\u6838\u8ba1\u5212\u4e0d\u5b58\u5728");
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(KhPlanObject::getPlanId, (Object)id);
        List list = this.planObjectManager.list((Wrapper)lambdaQueryWrapper);
        KhSchemePlan2.setPlanObjectList(list);
        if (!StringUtil.isEmpty((String)KhSchemePlan2.getAssessId()) && null != (khAssessScheme = this.assessSchemeManager.findById(KhSchemePlan2.getAssessId()))) {
            KhSchemePlan2.setAssessScheme(khAssessScheme);
        }
        if (!StringUtil.isEmpty((String)KhSchemePlan2.getSchemeId()) && null != (scheme = this.schemeManager.findById(KhSchemePlan2.getSchemeId()))) {
            KhSchemePlan2.setScheme(scheme);
        }
        return KhSchemePlan2;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatus(List<String> ids, String status) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(KhSchemePlan::getId, ids);
        List list = this.list((Wrapper)lambdaQueryWrapper);
        list.forEach(KhSchemePlan2 -> {
            if (status.equals(KhSchemePlan2.getStatus())) {
                throw new BaseException("\u5f53\u524d\u8ba1\u5212\u72b6\u6001\u4e0e\u8981\u4fee\u6539\u72b6\u6001\u4e00\u81f4\uff0c\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539\uff01");
            }
            KhSchemePlan2.setStatus(status);
        });
        boolean b = this.updateBatchById(list);
        return b;
    }
}

