/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bo.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;

public class BoBpmShipGroup
implements Serializable {
    private static final long serialVersionUID = -6784653712175927956L;
    private String flowKey;
    private String flowName;
    private List<BoBpmShip> ships;

    public static BoBpmShipGroup build(String flowKey, String flowName) {
        BoBpmShipGroup boBpmShipGroup = new BoBpmShipGroup();
        boBpmShipGroup.setFlowKey(flowKey);
        boBpmShipGroup.setFlowName(flowName);
        boBpmShipGroup.setShips(new ArrayList<BoBpmShip>());
        return boBpmShipGroup;
    }

    public BoBpmShipGroup addShip(String flowId, String version, boolean isMain) {
        Assert.notNull(this.ships, (String)"ships\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        if (!this.ships.stream().anyMatch(e -> e.getFlowId().equals(flowId))) {
            this.ships.add(new BoBpmShip(flowId, version, isMain));
        }
        return this;
    }

    public String getFlowKey() {
        return this.flowKey;
    }

    public void setFlowKey(String flowKey) {
        this.flowKey = flowKey;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public List<BoBpmShip> getShips() {
        return this.ships;
    }

    public void setShips(List<BoBpmShip> ships) {
        this.ships = ships;
    }

    class BoBpmShip
    implements Serializable {
        private static final long serialVersionUID = 4642319367954742750L;
        private String flowId;
        private String version;
        private boolean isMain;

        public BoBpmShip(String flowId, String version, boolean isMain) {
            this.setFlowId(flowId);
            this.setVersion(version);
            this.setMain(isMain);
        }

        public String getFlowId() {
            return this.flowId;
        }

        public void setFlowId(String flowId) {
            this.flowId = flowId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public boolean isMain() {
            return this.isMain;
        }

        public void setMain(boolean isMain) {
            this.isMain = isMain;
        }
    }
}

