package com.artfess.mdm.uc.model;

import com.artfess.base.entity.AutoOrgFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 组织维度管理
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2025-01-16
 */
@ApiModel(value="MdmOrgDemension对象", description="组织维度管理")
@TableName("MDM_ORG_DEMENSION")
public class MdmOrgDemension extends AutoOrgFillModel<MdmOrgDemension> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请填写维度名称！", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "维度名称")
    @TableField("DEM_NAME_")
    private String demName;

    @NotBlank(message = "请填写维度代码！", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "维度代码")
    @TableField("DEM_CODE_")
    private String demCode;

    @NotNull(message = "请选择是否默认！", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "是否默认(1:默认,0:非默认)")
    @TableField("IS_DEFAULT_")
    private Integer isDefault;

    @ApiModelProperty(value = "描述")
    @TableField("DEM_DESC_")
    private String demDesc;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @ApiModelProperty(value = "最后操作时间")
    @TableField("LAST_OPERATE_TIME_")
    private LocalDateTime lastOperateTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_SEQ_")
    private Long lastTimeSeq;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDemName() {
        return demName;
    }

    public void setDemName(String demName) {
        this.demName = demName;
    }

    public String getDemCode() {
        return demCode;
    }

    public void setDemCode(String demCode) {
        this.demCode = demCode;
    }

    public Integer getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }

    public String getDemDesc() {
        return demDesc;
    }

    public void setDemDesc(String demDesc) {
        this.demDesc = demDesc;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public LocalDateTime getLastOperateTime() {
        return lastOperateTime;
    }

    public void setLastOperateTime(LocalDateTime lastOperateTime) {
        this.lastOperateTime = lastOperateTime;
    }

    public Long getLastTimeSeq() {
        return lastTimeSeq;
    }

    public void setLastTimeSeq(Long lastTimeSeq) {
        this.lastTimeSeq = lastTimeSeq;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "MdmOrgDemension{" +
            "id=" + id +
            ", demName=" + demName +
            ", demCode=" + demCode +
            ", isDefault=" + isDefault +
            ", demDesc=" + demDesc +
            ", version=" + version +
            ", lastOperateTime=" + lastOperateTime +
            ", lastTimeSeq=" + lastTimeSeq +
            ", isDele=" + isDele +
        "}";
    }
}
