/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataCollect.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.dataShare.dataCollect.manager.BizClusterInfoManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterInfoModeManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterTableManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterTableTriggerManager;
import com.artfess.dataShare.dataCollect.model.BizClusterInfo;
import com.artfess.dataShare.dataCollect.model.BizClusterInfoMode;
import com.artfess.dataShare.dataCollect.model.BizClusterTable;
import com.artfess.dataShare.dataCollect.model.BizClusterTableTrigger;
import com.artfess.dataShare.dataCollect.vo.TableDetailVo;
import com.artfess.dataShare.dataResource.ods.vo.CopyTableVo;
import com.artfess.dataShare.factory.QueryParamVo;
import com.artfess.dataShare.factory.QueryResultData;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/biz/dataCollect/clusterTable/v1/"})
@ApiGroup(group={"group_biz_dataShare"})
@Api(tags={"\u6570\u636e\u6c47\u805a-\u6570\u636e\u6c47\u805a\u8868\u4fe1\u606f"})
public class BizClusterTableController
extends BaseController<BizClusterTableManager, BizClusterTable> {
    @Resource
    BizClusterTableManager tableManager;
    @Resource
    BizClusterInfoManager infoManager;
    @Resource
    BizClusterTableTriggerManager tableTriggerManager;
    @Resource
    BizClusterInfoModeManager infoModeManager;

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody BizClusterTable t) {
        boolean result;
        if (StringUtil.isEmpty((String)t.getId())) {
            BizClusterInfo info = (BizClusterInfo)this.infoManager.get((Serializable)((Object)t.getClusterId()));
            t.setDeployed(0);
            t.setIsCreateTable(0);
            t.setIsDele("0");
            t.setTableNameEn(info.getSysTableCode() + "_" + t.getTableNameEn());
        }
        if (!(result = ((BizClusterTableManager)this.baseService).save((Object)t))) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/importFile"})
    @ApiOperation(value="\u5bfc\u5165\u6570\u636e\u6c47\u805a\u8868\u4fe1\u606f", httpMethod="POST", notes="\u5bfc\u5165\u6570\u636e\u6c47\u805a\u8868\u4fe1\u606f")
    public CommonResult<String> export(@RequestParam(value="file", required=true) MultipartFile file, @RequestParam String clusterInfoId) throws Exception {
        this.tableManager.export(file, clusterInfoId);
        return new CommonResult(true, "\u5bfc\u5165\u6570\u636e\u6c47\u805a\u8868\u6210\u529f");
    }

    @PostMapping(value={"/Deploy/{tableId}"})
    @ApiOperation(value="\u76f4\u63a5\u53d1\u5e03\u8868\uff0c\u521b\u5efa\u5b9e\u4f53\u8868-\u4f7f\u7528\u9ed8\u8ba4\u7684SQL")
    public CommonResult<String> Deploy(@PathVariable String tableId) throws Exception {
        this.tableManager.Deploy(tableId);
        return new CommonResult(true, "\u53d1\u5e03\u8868\u6210\u529f");
    }

    @PostMapping(value={"/saveTableVo"})
    @ApiOperation(value="\u4fdd\u5b58\u67e5\u8be2\u8868\u4fe1\u606f\u3001\u5b57\u6bb5\u4fe1\u606f\u3001\u6a21\u578b")
    public CommonResult<String> saveTableVo(@RequestBody TableDetailVo vo) throws Exception {
        this.tableManager.saveTableVo(vo);
        return new CommonResult(true, "\u7ef4\u62a4\u6210\u529f");
    }

    @PostMapping(value={"/queryTableVo/{tableId}"})
    @ApiOperation(value="\u6839\u636e\u8868\u67e5\u8be2\u8868\u4fe1\u606f\u3001\u5b57\u6bb5\u4fe1\u606f\u3001\u6a21\u578b")
    public TableDetailVo queryTableVo(@PathVariable String tableId) throws Exception {
        TableDetailVo vo = this.tableManager.queryTableVo(tableId);
        return vo;
    }

    @PostMapping(value={"/queryTableData"})
    @ApiOperation(value="\u6570\u636e\u67e5\u8be2  \u5206\u9875\uff0c\u52a0\u641c\u7d22\u3001\u6392\u5e8f")
    public QueryResultData queryTableData(@RequestBody QueryParamVo queryParamVo) throws Exception {
        return this.tableManager.queryTableData(queryParamVo);
    }

    @PostMapping(value={"/queryTableInfo/{tableId}"})
    @ApiOperation(value="\u6839\u636e\u8868\u67e5\u8be2\u5efa\u8868\u8bed\u53e5\u3001\u89e6\u53d1\u5668\u8bed\u53e5\u3001\u521b\u5efa\u7ed3\u679c")
    public Map<String, Object> queryTableInfo(@PathVariable String tableId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BizClusterTable table = (BizClusterTable)this.getById(tableId);
        if (null == table) {
            throw new ApplicationException("\u672a\u67e5\u8be2\u5230\u8868");
        }
        BizClusterInfoMode infoMode = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)table.getClusterId())));
        String tableName = table.getTableNameEn();
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)infoMode.getDatabaseAlias());
        String queryTrigger = "SELECT trigger_schema,trigger_name,event_manipulation,event_object_schema,event_object_table,action_statement\nFROM information_schema.triggers\nWHERE EVENT_OBJECT_TABLE = ?";
        List triggers = template.queryForList(queryTrigger, new Object[]{tableName});
        if (triggers.size() > 0) {
            result.put("is_created_trigger", "1");
            ArrayList triggerSql = new ArrayList();
            for (Map map : triggers) {
                String insertTigerSql = "CREATE TRIGGER " + map.get("trigger_name") + "" + map.get("event_object_table") + "\n" + "    AFTER " + map.get("event_manipulation") + "  ON " + tableName + " FOR EACH ROW \n" + map.get("action_statement");
                HashMap<String, String> triggerMap = new HashMap<String, String>();
                triggerMap.put("sql", insertTigerSql);
                triggerMap.put("name", (String)map.get("trigger_name"));
                triggerMap.put("type", (String)map.get("event_manipulation"));
                triggerSql.add(triggerMap);
            }
            result.put("trigger", triggers);
        } else {
            result.put("is_created_trigger", "0");
            result.put("trigger", this.tableManager.queryTriggerSql(tableId));
        }
        result.put("is_created_table", table.getIsCreateTable());
        result.put("createTableSql", this.tableManager.queryTableSql(tableId));
        return result;
    }

    @PostMapping(value={"/createdTable/{tableId}"})
    @ApiOperation(value="\u624b\u52a8\u5efa\u8868")
    public CommonResult<String> createdTable(@PathVariable String tableId) throws Exception {
        this.tableManager.createdTable(tableId);
        return new CommonResult(true, "\u624b\u52a8\u5efa\u8868\u6210\u529f");
    }

    @PostMapping(value={"/createdTrigger/{tableId}"})
    @ApiOperation(value="\u624b\u52a8\u5efa\u89e6\u53d1\u5668")
    public CommonResult<String> createdTrigger(@PathVariable String tableId) throws Exception {
        this.tableManager.createdTrigger(tableId);
        return new CommonResult(true, "\u624b\u52a8\u5efa\u89e6\u53d1\u5668\u6210\u529f");
    }

    @RequestMapping(value={"downloadMainTempFile/{tableId}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f", httpMethod="POST", notes="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f")
    public void downloadMainTempFile(HttpServletResponse response, @ApiParam(name="tableId", value="\u6a21\u677f\u522b\u540d", required=true) @PathVariable String tableId) throws Exception {
        ((BizClusterTableManager)this.baseService).downloadMainTempFile(response, tableId);
    }

    @PostMapping(value={"importMain"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u6c47\u805a\u4e3b\u8868\u6570\u636e", httpMethod="POST", notes="\u5bfc\u5165\u6c47\u805a\u4e3b\u8868\u6570\u636e")
    public CommonResult<String> importMain(@RequestParam(value="file", required=true) MultipartFile file, @RequestParam(value="tableId", required=true) String tableId) throws Exception {
        ((BizClusterTableManager)this.baseService).importMain(file, tableId);
        return new CommonResult("\u5bfc\u5165\u4e3b\u8868\u6570\u636e\u6210\u529f");
    }

    @PostMapping(value={"downTableSql/{tableId}"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0b\u8f7d\u5efa\u8868\u8bed\u53e5\u548c\u89e6\u53d1\u5668SQL\u6587\u4ef6", httpMethod="POST", notes="\u4e0b\u8f7d\u5efa\u8868\u8bed\u53e5\u548c\u89e6\u53d1\u5668SQL\u6587\u4ef6")
    public void downTableSql(HttpServletResponse response, @ApiParam(name="tableId", value="\u6570\u636e\u8868ID") @PathVariable String tableId) throws Exception {
        BizClusterTable table = (BizClusterTable)((Object)this.tableManager.getById((Serializable)((Object)tableId)));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"table_id_", (Object)tableId);
        List list = this.tableTriggerManager.list((Wrapper)queryWrapper);
        String tableSql = table.getCreateTableSql();
        StringBuffer text = new StringBuffer("\u521b\u5efa\u8868SQL:\n");
        text.append(tableSql);
        for (BizClusterTableTrigger item : list) {
            String triggerSql = item.getTriggerSql();
            text.append("\n").append(item.getName()).append("\n").append(triggerSql);
        }
        String rootRealPath = (FileUtil.getIoTmpdir() + "/temp/").replace("/", File.separator);
        FileUtil.createFolder((String)rootRealPath, (boolean)true);
        String path = rootRealPath + File.separator + System.currentTimeMillis() + ".txt";
        FileUtil.writeFile((String)path, (String)text.toString());
        File file = new File(path);
        HttpUtil.downLoadFile((HttpServletResponse)response, (String)path, (String)file.getName());
    }

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u6c47\u805a\u4e3b\u8868\u6570\u636e", httpMethod="POST", notes="\u67e5\u8be2\u6c47\u805a\u4e3b\u8868\u6570\u636e")
    public PageList<BizClusterTable> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        IPage<BizClusterTable> list = ((BizClusterTableManager)this.baseService).getClusterTableQueryList((QueryFilter<BizClusterTable>)queryFilter);
        PageList pageList = new PageList(list);
        return pageList;
    }

    @PostMapping(value={"checkTableExists"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1\u8868\u662f\u5426\u5df2\u7ecf\u5b58\u5728", httpMethod="POST", notes="\u9a8c\u8bc1\u8868\u662f\u5426\u5df2\u7ecf\u5b58\u5728")
    public CommonResult<String> checkTableExists(@ApiParam(name="clusterId", value="\u6c47\u805a\u65b9ID") @RequestParam String clusterId, @ApiParam(name="tableNameEn", value="\u8868\u82f1\u6587\u540d") @RequestParam String tableNameEn, @ApiParam(name="type", value="\u53d1\u5e03\u7c7b\u578b(0:\u672a\u6709\u8868\u53d1\u5e03\uff0c1:\u5df2\u6709\u8868\u53d1\u5e03)") @RequestParam(required=false) String type) throws Exception {
        boolean isExists = this.tableManager.checkTableExists(clusterId, tableNameEn);
        if ("1".equals(type)) {
            if (isExists) {
                return new CommonResult(true, "\u9a8c\u8bc1\u6210\u529f\uff0c\u53ef\u4ee5\u53d1\u5e03");
            }
            return new CommonResult(false, "\u8868" + tableNameEn + "\u4e0d\u5b58\u5728\uff01");
        }
        if (isExists) {
            return new CommonResult(false, "\u8868" + tableNameEn + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u8868\u540d");
        }
        return new CommonResult(true, "\u53ef\u4ee5\u4f7f\u7528\u8868\u540d");
    }

    @PostMapping(value={"checkPhysicsTableExists"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1\u7269\u7406\u8868\u662f\u5426\u5df2\u7ecf\u5b58\u5728", httpMethod="POST", notes="\u9a8c\u8bc1\u8868\u662f\u5426\u5df2\u7ecf\u5b58\u5728")
    public CommonResult<String> checkPhysicsTableExists(@ApiParam(name="clusterId", value="\u6c47\u805a\u65b9ID") @RequestParam String clusterId, @ApiParam(name="tableNameEn", value="\u8868\u82f1\u6587\u540d") @RequestParam String tableNameEn, @ApiParam(name="type", value="\u53d1\u5e03\u7c7b\u578b(0:\u672a\u6709\u8868\u53d1\u5e03\uff0c1:\u5df2\u6709\u8868\u53d1\u5e03)") @RequestParam(required=false) String type) throws Exception {
        boolean isExists = this.tableManager.checkPhysicsTableExists(clusterId, tableNameEn);
        if ("1".equals(type)) {
            if (isExists) {
                return new CommonResult(true, "\u9a8c\u8bc1\u6210\u529f\uff0c\u53ef\u4ee5\u53d1\u5e03");
            }
            return new CommonResult(false, "\u8868" + tableNameEn + "\u4e0d\u5b58\u5728\uff01");
        }
        if (isExists) {
            return new CommonResult(false, "\u8868" + tableNameEn + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u8868\u540d");
        }
        return new CommonResult(true, "\u53ef\u4ee5\u4f7f\u7528\u8868\u540d");
    }

    @PostMapping(value={"copyTable"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5f15\u7528/\u590d\u5236\u521b\u5efa\u7684\u5176\u4ed6\u8868", httpMethod="POST", notes="\u590d\u5236\u521b\u5efa\u7684\u5176\u4ed6\u8868")
    public CommonResult<String> copyTable(@RequestBody CopyTableVo vo) throws Exception {
        this.tableManager.copyTable(vo);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"queryTableSql/{tableId}"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636etableId\u67e5\u8be2\u5efa\u8868\u8bed\u53e5", httpMethod="POST", notes="\u6839\u636etableId\u67e5\u8be2\u5efa\u8868\u8bed\u53e5")
    public CommonResult<String> queryTableSql(@ApiParam(name="tableId", value="\u6570\u636e\u8868ID") @PathVariable String tableId) throws Exception {
        String tableSql = this.tableManager.queryTableSql(tableId);
        return CommonResult.success((Object)tableSql, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"saveTableSql"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5efa\u8868SQL", httpMethod="POST", notes="\u4fdd\u5b58\u5efa\u8868SQL")
    public CommonResult<String> saveTableSql(@ApiParam(name="tableId", value="\u6570\u636e\u8868ID") @RequestParam String tableId, @ApiParam(name="tableSql", value="\u5efa\u8868\u8bed\u53e5") @RequestParam String tableSql) throws Exception {
        BizClusterTable table = (BizClusterTable)((Object)this.tableManager.getById((Serializable)((Object)tableId)));
        table.setCreateTableSql(tableSql);
        this.tableManager.updateById((Object)table);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"deployHaveTable"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5df2\u6709\u8868\u53d1\u5e03-\u540c\u65f6\u521b\u5efa\u89e6\u53d1\u5668", httpMethod="POST", notes="\u5df2\u6709\u8868\u53d1\u5e03")
    public CommonResult<String> deployHaveTable(@ApiParam(name="tableId", value="\u6570\u636e\u8868ID") @RequestParam String tableId, @ApiParam(name="createTrigger", value="\u662f\u5426\u521b\u5efa\u89e6\u53d1\u5668 0\u5426 1\u662f") @RequestParam String createTrigger) throws Exception {
        this.tableManager.deployHaveTable(tableId, createTrigger);
        return new CommonResult(true, "\u5df2\u6709\u8868\u53d1\u5e03\u6210\u529f");
    }

    @RequestMapping(value={"deployDotHaveTable"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u672a\u6709\u8868\u53d1\u5e03-\u540c\u65f6\u521b\u5efa\u89e6\u53d1\u5668", httpMethod="POST", notes="\u672a\u6709\u8868\u53d1\u5e03-\u540c\u65f6\u521b\u5efa\u89e6\u53d1\u5668")
    public CommonResult<String> deployDotHaveTable(@ApiParam(name="tableId", value="\u6570\u636e\u8868ID") @RequestParam String tableId, @ApiParam(name="tableSql", value="\u5efa\u8868\u8bed\u53e5") @RequestParam String tableSql, @ApiParam(name="createTrigger", value="\u662f\u5426\u521b\u5efa\u89e6\u53d1\u5668 0\u5426 1\u662f") @RequestParam String createTrigger) throws Exception {
        this.tableManager.deployDotHaveTable(tableId, tableSql, createTrigger);
        return new CommonResult(true, "\u672a\u6709\u8868\u53d1\u5e03\u6210\u529f");
    }

    @RequestMapping(value={"removeTable"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u522a\u9664\u8868-\u5982\u679c\u8868\u5df2\u7ecf\u521b\u5efa\u540c\u6b65\u5220\u9664\u5b9e\u4f53\u8868", httpMethod="POST", notes="\u522a\u9664\u8868-\u5982\u679c\u8868\u5df2\u7ecf\u521b\u5efa\u540c\u6b65\u5220\u9664\u5b9e\u4f53\u8868")
    public CommonResult<String> removeTable(@ApiParam(name="tableId", value="\u6570\u636e\u8868ID") @RequestParam String tableId) throws Exception {
        this.tableManager.removeTable(tableId);
        return new CommonResult(true, "\u672a\u6709\u8868\u53d1\u5e03\u6210\u529f");
    }
}

