/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataCollect.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.dataShare.dataCollect.manager.BizDatasourcesRelationManager;
import com.artfess.dataShare.dataCollect.model.BizDatasourcesRelation;
import com.artfess.dataShare.dataCollect.vo.BizDataSourceVo;
import com.artfess.sysConfig.persistence.manager.SysDataSourceManager;
import com.artfess.sysConfig.persistence.model.SysDataSource;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/biz/datasourcesRelation/v1/"})
@ApiGroup(group={"group_biz_dataShare"})
@Api(tags={"\u6570\u636e\u6e90\u5173\u8054\u8868"})
public class BizDatasourcesRelationController
extends BaseController<BizDatasourcesRelationManager, BizDatasourcesRelation> {
    @Resource
    SysDataSourceManager sysDataSourceManager;

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6570\u636e\u6e90\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6570\u636e\u6e90\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="sysDataSource", value="\u6570\u636e\u6e90\u5bf9\u8c61", required=true) @RequestBody BizDataSourceVo bizDataSourceVo) throws Exception {
        SysDataSource sysDataSource = new SysDataSource();
        BeanUtils.copyNotNullProperties((Object)sysDataSource, (Object)bizDataSourceVo);
        boolean isConnection = this.sysDataSourceManager.checkConnection(sysDataSource);
        boolean isAliasExist = this.sysDataSourceManager.isAliasExist(sysDataSource.getAlias());
        if (isAliasExist && StringUtil.isEmpty((String)sysDataSource.getId())) {
            return new CommonResult(false, "\u522b\u540d\u5df2\u5b58\u5728");
        }
        if (!isConnection) {
            return new CommonResult(false, "\u8fde\u63a5\u6570\u636e\u5e93\u5931\u8d25\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        String dataSourceId = sysDataSource.getId();
        String resultMsg = null;
        String sourceId = UniqueIdUtil.getSuid();
        if (StringUtil.isEmpty((String)dataSourceId)) {
            sysDataSource.setId(sourceId);
            this.sysDataSourceManager.create((Model)sysDataSource);
            resultMsg = "\u6dfb\u52a0\u6210\u529f,\u5e76\u8fde\u63a5\u6d4b\u8bd5\u901a\u8fc7";
        } else {
            this.sysDataSourceManager.update((Model)sysDataSource);
            resultMsg = "\u66f4\u65b0\u6210\u529f,\u5e76\u8fde\u63a5\u6d4b\u8bd5\u901a\u8fc7";
        }
        if (StringUtil.isEmpty((String)dataSourceId)) {
            BizDatasourcesRelation relation = new BizDatasourcesRelation();
            relation.setAlias(sysDataSource.getAlias());
            relation.setDatasourcesType(bizDataSourceVo.getDatasourcesType());
            relation.setId(sourceId);
            this.create((Model)relation);
        } else {
            BizDatasourcesRelation relation = new BizDatasourcesRelation();
            BeanUtils.copyNotNullProperties((Object)((Object)relation), (Object)bizDataSourceVo);
            this.updateById((Model)relation);
        }
        return new CommonResult(resultMsg);
    }

    @GetMapping(value={"/detail/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53\u548c\u6570\u636e\u6e90")
    public BizDataSourceVo getDataSourceById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) throws Exception {
        BizDataSourceVo vo = new BizDataSourceVo();
        BizDatasourcesRelation relation = (BizDatasourcesRelation)((Object)((BizDatasourcesRelationManager)this.baseService).getById((Serializable)((Object)id)));
        if (relation == null) {
            throw new ApplicationException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u6e90");
        }
        SysDataSource sysDataSource = this.sysDataSourceManager.getByAlias(relation.getAlias());
        if (sysDataSource == null) {
            throw new ApplicationException("\u672a\u67e5\u8be2\u5230\u5173\u8054\u6570\u636e\u6e90");
        }
        BeanUtils.copyNotNullProperties((Object)vo, (Object)((Object)relation));
        BeanUtils.copyNotNullProperties((Object)vo, (Object)sysDataSource);
        return vo;
    }

    @PostMapping(value={"/queryList/{type}"})
    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u6e90\u5217\u8868")
    public List<BizDataSourceVo> queryList(@ApiParam(name="type", value="\u6570\u636e\u6e90\u7c7b\u578b\uff081\uff1a\u6c47\u805a\u4ea4\u6362\uff0c2\uff1aODS\uff0c3\uff1aDW\uff0c4\uff1a\u5171\u4eab\uff09") @PathVariable Integer type) throws Exception {
        if (null == type) {
            type = 1;
        }
        return ((BizDatasourcesRelationManager)this.baseService).queryList(type);
    }
}

